/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.control.IP1516ControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.modbusprocessor.AbstractModbusProcessor;
import cn.com.voltronic.solar.util.VolUtil;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;
import net.wimpi.modbus.util.ModbusUtil;

public class P15ModbusControlModule
extends AbstractControlModule
implements IP1516ControlModule {
    public P15ModbusControlModule(Object handler, ConfigData config, Capability capability) {
        super(handler, config, capability);
    }

    @Override
    public ModbusHandler getHandler() {
        ModbusHandler handler = null;
        try {
            handler = (ModbusHandler)super.getHandler();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handler;
    }

    @Override
    public void excuteCommand(int address, int value) throws Exception {
        byte[] bytes = ModbusUtil.shortToRegister((short)((short)value));
        SimpleRegister reg = new SimpleRegister(bytes[0], bytes[1]);
        this.getHandler().writeMultipleRegisters(address, new Register[]{reg});
    }

    @Override
    public void excuteCommand(int address, double value) throws Exception {
        byte[] bytes = ModbusUtil.shortToRegister((short)((short)value));
        SimpleRegister reg = new SimpleRegister(bytes[0], bytes[1]);
        this.getHandler().writeMultipleRegisters(address, new Register[]{reg});
    }

    @Override
    public boolean setCapability(String x, boolean isEnable) {
        boolean result = true;
        try {
            if (x.equals("A")) {
                this.excuteCommand(14, isEnable ? 32768 : Short.MAX_VALUE);
            } else if (x.equals("B")) {
                this.excuteCommand(14, isEnable ? 16384 : 49151);
            } else if (x.equals("D")) {
                this.excuteCommand(14, isEnable ? 8192 : 57343);
            } else if (x.equals("I")) {
                this.excuteCommand(14, isEnable ? 16 : 65519);
            } else if (x.equals("M")) {
                this.excuteCommand(14, isEnable ? 2048 : 63487);
            } else if (x.equals("R")) {
                this.excuteCommand(14, isEnable ? 1024 : 64511);
            } else if (x.equals("S")) {
                this.excuteCommand(14, isEnable ? 512 : 65023);
            } else if (x.equals("T")) {
                this.excuteCommand(14, isEnable ? 256 : 65279);
            } else if (x.equals("C")) {
                this.excuteCommand(14, isEnable ? 128 : 65407);
            } else if (x.equals("F")) {
                this.excuteCommand(14, isEnable ? 64 : 65471);
            } else if (x.equals("H")) {
                this.excuteCommand(14, isEnable ? 32 : 65503);
            } else if (x.equals("L")) {
                this.excuteCommand(14, isEnable ? 4096 : 61439);
            } else if (x.equals("O")) {
                this.excuteCommand(14, isEnable ? 8 : 65527);
            } else if (x.equals("P")) {
                this.excuteCommand(14, isEnable ? 4 : 65531);
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean setGILTHV(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1484, (int)value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(1484, 1);
            if (value != (double)query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOHF(double value) {
        boolean result = true;
        try {
            this.excuteCommand(852, (int)(value * 10.0));
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(852, 1);
            if ((int)(value * 10.0) != query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOHV(double value) {
        boolean result = true;
        try {
            this.excuteCommand(850, value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(850, 1);
            if (value != (double)query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOLF(double value) {
        boolean result = true;
        try {
            this.excuteCommand(853, (int)(value * 10.0));
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(853, 1);
            if ((int)(value * 10.0) != query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOLV(double value) {
        boolean result = true;
        try {
            this.excuteCommand(851, value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(851, 1);
            if (value != (double)query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setLCD(String value) {
        boolean result = true;
        try {
            value = value.trim();
            Register[] regs = new Register[1];
            byte[] bytes1 = value.getBytes();
            regs[0] = new SimpleRegister(bytes1[0], bytes1[1]);
            this.getHandler().writeMultipleRegisters(1041, regs);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(1041, 1);
            if (!value.trim().equals(new String(query[0].toBytes()))) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOPMP(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1037, (int)value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(1037, 2);
            if (value != (double)AbstractModbusProcessor.convert2Regiters(query[0], query[1])) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPVIPHV(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1040, (int)value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(1040, 1);
            if (value != (double)query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPVIPLV(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1039, (int)value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(1039, 1);
            if (value != (double)query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setCurrentTime(String time) {
        boolean result = true;
        try {
            time = time.trim();
            Register[] regs = new Register[7];
            byte[] bytes1 = time.substring(0, 2).getBytes();
            byte[] bytes2 = time.substring(2, 4).getBytes();
            byte[] bytes3 = time.substring(4, 6).getBytes();
            byte[] bytes4 = time.substring(6, 8).getBytes();
            byte[] bytes5 = time.substring(8, 10).getBytes();
            byte[] bytes6 = time.substring(10, 12).getBytes();
            byte[] bytes7 = time.substring(12).getBytes();
            regs[0] = new SimpleRegister(bytes1[0], bytes1[1]);
            regs[1] = new SimpleRegister(bytes2[0], bytes2[1]);
            regs[2] = new SimpleRegister(bytes3[0], bytes3[1]);
            regs[3] = new SimpleRegister(bytes4[0], bytes4[1]);
            regs[4] = new SimpleRegister(bytes5[0], bytes5[1]);
            regs[5] = new SimpleRegister(bytes6[0], bytes6[1]);
            regs[6] = new SimpleRegister(bytes7[0], bytes7[1]);
            this.getHandler().writeMultipleRegisters(275, regs);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean setMPPTHV(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1485, (int)value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(1485, 1);
            if (value != (double)query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMPPTLV(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1486, (int)value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(1486, 1);
            if (value != (double)query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static void main(String[] args) {
        String str = "20110124105940";
        System.out.println(str.substring(0, 2));
        System.out.println(str.substring(2, 4));
        System.out.println(str.substring(4, 6));
        System.out.println(str.substring(6, 8));
        System.out.println(str.substring(8, 10));
        System.out.println(str.substring(10, 12));
        System.out.println(str.substring(12));
    }

    @Override
    public boolean setPF() {
        boolean result = true;
        try {
            System.out.println("--------------run here---------------");
            this.excuteCommand(48, 32768);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPassword(String oldpwd, String newpwd) {
        boolean result = true;
        try {
            if (this.checkOldPwd(oldpwd)) {
                Register[] newRegs = new Register[4];
                byte[] bytes5 = newpwd.substring(0, 2).getBytes();
                byte[] bytes6 = newpwd.substring(2, 4).getBytes();
                byte[] bytes7 = newpwd.substring(4, 6).getBytes();
                byte[] bytes8 = newpwd.substring(6).getBytes();
                newRegs[0] = new SimpleRegister(bytes5[0], bytes5[1]);
                newRegs[1] = new SimpleRegister(bytes6[0], bytes6[1]);
                newRegs[2] = new SimpleRegister(bytes7[0], bytes7[1]);
                newRegs[3] = new SimpleRegister(bytes8[0], bytes8[1]);
                this.getHandler().writeMultipleRegisters(1310, newRegs);
                Register[] newpwdReg = this.getHandler().readMultipleRegisters(1310, 4);
                String str = "";
                int item = 0;
                while (item < newpwdReg.length) {
                    str = String.valueOf(str) + new String(newpwdReg[item].toBytes());
                    ++item;
                }
                System.out.println(String.valueOf(newpwd) + "------------newpwd:" + str);
                if (!str.equals(newpwd)) {
                    result = false;
                }
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private boolean checkOldPwd(String oldpwd) throws Exception {
        Register[] regs = new Register[4];
        byte[] bytes1 = oldpwd.substring(0, 2).getBytes();
        byte[] bytes2 = oldpwd.substring(2, 4).getBytes();
        byte[] bytes3 = oldpwd.substring(4, 6).getBytes();
        byte[] bytes4 = oldpwd.substring(6).getBytes();
        regs[0] = new SimpleRegister(bytes1[0], bytes1[1]);
        regs[1] = new SimpleRegister(bytes2[0], bytes2[1]);
        regs[2] = new SimpleRegister(bytes3[0], bytes3[1]);
        regs[3] = new SimpleRegister(bytes4[0], bytes4[1]);
        this.getHandler().writeMultipleRegisters(1305, regs);
        Thread.sleep(3000L);
        Register[] passwordResultReg1 = this.getHandler().readMultipleRegisters(1309, 1);
        return passwordResultReg1[0].getValue() == 43690;
    }

    @Override
    public boolean setGridWaittime(double value0) {
        int value = (int)value0;
        String strValue = String.valueOf(value);
        strValue = VolUtil.leftZero(strValue, 4);
        boolean result = true;
        try {
            strValue = strValue.trim();
            Register[] regs = new Register[2];
            byte[] bytes1 = strValue.substring(0, 2).getBytes();
            byte[] bytes2 = strValue.substring(2).getBytes();
            regs[0] = new SimpleRegister(bytes1[0], bytes1[1]);
            regs[1] = new SimpleRegister(bytes2[0], bytes2[1]);
            this.getHandler().writeMultipleRegisters(856, regs);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(856, 2);
            String resultStr = String.valueOf(new String(query[0].toBytes())) + new String(query[1].toBytes());
            if (!strValue.trim().equals(resultStr)) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean selfTest() {
        boolean result = true;
        try {
            this.excuteCommand(48, 16384);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean epoOff() {
        boolean result = true;
        try {
            this.excuteCommand(26, 2);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean epoOn() {
        boolean result = true;
        try {
            this.excuteCommand(26, 1);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPVN(double value) {
        boolean result = true;
        try {
            this.excuteCommand(1474, (int)value);
            Thread.sleep(3000L);
            Register[] query = this.getHandler().readMultipleRegisters(1474, 1);
            if (value != (double)query[0].getValue()) {
                result = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPGF(double value) {
        return false;
    }

    @Override
    public boolean setPHV(double value) {
        return false;
    }

    @Override
    public boolean setPLV(double value) {
        return false;
    }

    @Override
    public boolean setPSF(double value) {
        return false;
    }

    @Override
    public boolean setPowerFactor(double value) {
        return false;
    }

    @Override
    public boolean setPowerPercent(double value) {
        return false;
    }

    @Override
    public boolean setPowerFactorLine(double value) {
        return false;
    }

    @Override
    public boolean setPowerPFCurve(double value) {
        return false;
    }

    @Override
    public boolean setPowerPFPercent(double value) {
        return false;
    }

    @Override
    public boolean setFeefInReactivePower(double value) {
        return false;
    }

    @Override
    public boolean setBatteryNumbers(String value) {
        return false;
    }

    @Override
    public boolean setBTNUM(double value) {
        return false;
    }
}

