/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.util;

import cn.com.voltronic.solar.system.GlobalVariables;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    public static boolean isValidDate(String dateStr, String pattern) {
        boolean isValid = false;
        if (pattern == null || pattern.length() < 1) {
            pattern = "yyyy-MM-dd";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            String date = sdf.format(sdf.parse(dateStr));
            if (date.equalsIgnoreCase(dateStr)) {
                isValid = true;
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        if (!isValid) {
            isValid = DateUtils.isValidDatePatterns(dateStr, "");
        }
        return isValid;
    }

    public static Date getDateParseDate(Date date) {
        SimpleDateFormat FORMAT_TIMESTAMP = new SimpleDateFormat(String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
        String source = FORMAT_TIMESTAMP.format(date);
        try {
            return FORMAT_TIMESTAMP.parse(source);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isValidDatePatterns(String dateStr, String patterns) {
        if (patterns == null || patterns.length() < 1) {
            patterns = "yyyy-MM-dd;dd/MM/yyyy;yyyy/MM/dd;yyyy/M/d h:mm";
        }
        boolean isValid = false;
        String[] patternArr = patterns.split(";");
        int i = 0;
        while (i < patternArr.length) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(patternArr[i]);
                String date = sdf.format(sdf.parse(dateStr));
                if (date.equalsIgnoreCase(dateStr)) {
                    isValid = true;
                    break;
                }
            }
            catch (Exception e) {
                isValid = false;
            }
            ++i;
        }
        return isValid;
    }

    public static String getDateFormat(boolean isFull) {
        String date = GlobalVariables.globalConfig.getDateFormat();
        date = date.equals("yyyy-MM-dd") ? (isFull ? "yyyy-MM-dd" : "yyyy-MM") : (date.equals("yyyy/MM/dd") ? (isFull ? "yyyy/MM/dd" : "yyyy/MM") : (date.equals("MM-dd-yyyy") ? (isFull ? "MM-dd-yyyy" : "MM-dd") : (date.equals("MM/dd/yyyy") ? (isFull ? "MM/dd/yyyy" : "MM/dd") : (isFull ? "yyyy-MM-dd" : "yyyy-MM"))));
        return date;
    }

    public static String getFormatDateStr(String dateStr, String pattern) {
        if (pattern == null || pattern.length() < 1) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            String date = format.format(sdf.parse(dateStr));
            return date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFormatDate(String dateStr, String pattern) {
        if (pattern == null || pattern.length() < 1) {
            pattern = "yyyy-MM-dd";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            String date = format.format(sdf.parse(dateStr));
            return date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFormatDate(Date date, String pattern) {
        if (pattern == null || pattern.length() < 1) {
            pattern = "yyyy-MM-dd";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            String strDate = sdf.format(date);
            return strDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDate(String s) {
        DateFormat df = DateFormat.getDateInstance();
        Date myDate = null;
        try {
            myDate = df.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return myDate;
    }

    public static Date parseDate_yyyy_MM_dd(String s) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date myDate = null;
        try {
            myDate = df.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return myDate;
    }

    public static String getNowDate(String pattern) {
        Date date = new Date();
        String strdate = "";
        SimpleDateFormat FORMAT_DATE = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
        if (pattern == null || pattern.length() < 1) {
            strdate = FORMAT_DATE.format(date);
        } else {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                strdate = sdf.format(date);
            }
            catch (Exception e) {
                strdate = FORMAT_DATE.format(date);
            }
        }
        return strdate;
    }

    public static String getNowDate() {
        Date date = new Date();
        String pattern = GlobalVariables.globalConfig.getDateFormat();
        SimpleDateFormat formate = new SimpleDateFormat(pattern);
        return formate.format(date);
    }

    public static String getFormatTimestamp(Date date) {
        SimpleDateFormat FORMAT_TIMESTAMP = new SimpleDateFormat(String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
        return FORMAT_TIMESTAMP.format(date);
    }

    public static Date parseTimestamp(String s) {
        Date date = null;
        try {
            SimpleDateFormat FORMAT_TIMESTAMP = new SimpleDateFormat(String.valueOf(GlobalVariables.globalConfig.getDateFormat()) + " HH:mm:ss");
            date = FORMAT_TIMESTAMP.parse(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date parseDate(String s, String pattern) {
        Date date = null;
        if (s != null && DateUtils.isValidDate(s, pattern)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                date = sdf.parse(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return date;
    }

    public static String getFormatDate(Date date) {
        SimpleDateFormat FORMAT_DATE = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
        return FORMAT_DATE.format(date);
    }

    public static void main(String[] args) {
    }

    public static boolean isFullYear(Calendar startdate, Calendar enddate) {
        return startdate.get(1) == enddate.get(1) && startdate.get(2) == 0 && startdate.get(5) == 1 && enddate.get(2) == 11 && enddate.get(5) == 31;
    }

    public static boolean isFullMonth(Calendar startdate, Calendar enddate) {
        Calendar nextdate = Calendar.getInstance();
        nextdate.setTime(enddate.getTime());
        nextdate.add(5, 1);
        return startdate.get(5) == 1 && nextdate.get(5) == 1;
    }

    public static Calendar getEndofMonth(Calendar date) {
        Calendar enddate = Calendar.getInstance();
        enddate.setTime(date.getTime());
        enddate.add(2, 1);
        enddate.set(5, 1);
        enddate.add(5, -1);
        return enddate;
    }

    public static Calendar getStartofMonth(Calendar date) {
        Calendar startdate = Calendar.getInstance();
        startdate.set(date.get(1), date.get(2), 1);
        return startdate;
    }

    public static int getCurrentYear() {
        Calendar c = Calendar.getInstance();
        return c.get(1);
    }

    public static int getCurrentMonth() {
        Calendar c = Calendar.getInstance();
        return c.get(2);
    }

    public static int getCurrentWeek() {
        Calendar c = Calendar.getInstance();
        return c.get(7);
    }

    public static int getCurrentDay() {
        Calendar c = Calendar.getInstance();
        return c.get(5);
    }

    public static int getCurrentHour() {
        Calendar c = Calendar.getInstance();
        return c.get(11);
    }

    public static Calendar getNextMonth(Calendar date) {
        Calendar enddate = Calendar.getInstance();
        enddate.setTime(date.getTime());
        enddate.add(2, 1);
        enddate.set(5, 1);
        return enddate;
    }

    public static Calendar getShortdate(Calendar longdate) {
        Calendar cal = (Calendar)longdate.clone();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static boolean sqlAfter(Timestamp first0, Calendar second, int field) {
        Calendar first = Calendar.getInstance();
        first.setTime(first0);
        if (field == 2) {
            int secondyear;
            int firstyear = first.get(1);
            if (firstyear > (secondyear = second.get(1))) {
                return true;
            }
            if (firstyear == secondyear) {
                return first.get(2) > first.get(2);
            }
            return false;
        }
        if (field == 5) {
            return DateUtils.getShortdate(first).after(DateUtils.getShortdate(second));
        }
        if (field == 11) {
            if (DateUtils.getShortdate(first).compareTo(DateUtils.getShortdate(second)) == 0) {
                return first.get(11) > second.get(11);
            }
            return first.after(second);
        }
        if (field == 12) {
            Calendar fircopy = (Calendar)first.clone();
            fircopy.set(13, 0);
            fircopy.set(14, 0);
            Calendar seccopy = (Calendar)second.clone();
            seccopy.set(13, 0);
            seccopy.set(14, 0);
            return fircopy.after(seccopy);
        }
        return first.after(second);
    }

    public static Calendar getEndofDayFullTime(Calendar date) {
        Calendar end = date;
        end.set(11, 23);
        end.set(12, 59);
        end.set(13, 59);
        return end;
    }

    public static Timestamp getEndofDayFullTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Calendar getStartofDayFullTime(Calendar date) {
        Calendar start = date;
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        return start;
    }
}

