/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.work;

import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.dao.EnergyDao;
import cn.com.voltronic.solar.data.bean.EnergyBean;
import cn.com.voltronic.solar.data.bean.SynchroEnergyPlan;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.SynchronizeDataJDialog;
import cn.com.voltronic.solar.webservice.WebServices;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class SynchroHandler {
    public void synchroEnergy(Calendar enddate, SynchroEnergyPlan plan, AbstractProcessor processor, boolean isAuto) {
        WebServices web = new WebServices();
        if (isAuto) {
            SystemEnv.energySynchroing = true;
            EventsHandler.handleEvent(processor.getProtocol().getProtocolID(), plan.getSerialno(), processor.getCurrentTime().getTime(), "3004");
        } else {
            EventsHandler.handleEvent(processor.getProtocol().getProtocolID(), plan.getSerialno(), processor.getCurrentTime().getTime(), "3006");
        }
        if (SynchronizeDataJDialog.startButton != null) {
            SynchronizeDataJDialog.startButton.setEnabled(false);
        }
        Calendar begindate = (Calendar)enddate.clone();
        if (plan.getSynchroTime() == 0) {
            begindate.set(11, 0);
            begindate.set(12, 0);
            begindate.set(13, 0);
        }
        if (plan.getCycle().equals("daily")) {
            begindate.add(5, plan.getSynchroTime() * -1);
        } else if (plan.getCycle().equals("monthly")) {
            begindate.add(2, plan.getSynchroTime() * -1);
        } else if (plan.getCycle().equals("weekly")) {
            begindate.add(5, plan.getSynchroTime() * 7 * -1);
        }
        EnergyDao energydao = new EnergyDao();
        Calendar startdate = energydao.queryEnergyBeginDate(plan.getSerialno());
        if (startdate == null) {
            try {
                startdate = processor.getEnergyBeginDate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (startdate == null) {
            return;
        }
        if (startdate.compareTo(begindate) > 0) {
            begindate.setTime(startdate.getTime());
        }
        List<EnergyBean> listHours = energydao.queryHour(plan.getSerialno(), begindate, 0, enddate, enddate.get(11));
        HashMap<String, EnergyBean> mapHours = new HashMap<String, EnergyBean>();
        for (EnergyBean list : listHours) {
            if (SystemEnv.stopping) break;
            String hourStr = list.getHour() > 9 ? "" + list.getHour() : "0" + list.getHour();
            String key = String.valueOf(DateUtils.getFormatDate(list.getTrandate().getTime())) + hourStr;
            if (mapHours.containsKey(key)) {
                energydao.deleteHour(processor.getProtocol().getProtocolID(), plan.getSerialno(), list);
                mapHours.remove(key);
                continue;
            }
            if (!list.isComplete()) continue;
            mapHours.put(key, list);
        }
        Calendar enddateDay = (Calendar)enddate.clone();
        List<EnergyBean> listDays = energydao.queryDay(plan.getSerialno(), begindate, enddateDay);
        HashMap<String, EnergyBean> mapDays = new HashMap<String, EnergyBean>();
        for (EnergyBean list : listDays) {
            if (SystemEnv.stopping) break;
            String key = DateUtils.getFormatDate(list.getTrandate().getTime());
            if (mapDays.containsKey(key)) {
                energydao.deleteDay(processor.getProtocol().getProtocolID(), plan.getSerialno(), list);
                mapDays.remove(key);
                continue;
            }
            if (!list.isComplete()) continue;
            mapDays.put(key, list);
        }
        Calendar tempDate = DateUtils.getShortdate(enddate);
        while (tempDate.compareTo(begindate) >= 0) {
            String key;
            int hour = 0;
            while (hour <= 23) {
                if (SystemEnv.stopping || tempDate.compareTo(begindate) == 0 && hour > enddate.get(11)) break;
                String hourStr = hour > 9 ? "" + hour : "0" + hour;
                String key2 = String.valueOf(DateUtils.getFormatDate(begindate.getTime())) + hourStr;
                if (!mapHours.containsKey(key2)) {
                    try {
                        EnergyBean bean = new EnergyBean();
                        if (tempDate.compareTo(begindate) == 0 && hour == enddate.get(11)) {
                            bean.setComplete(false);
                        } else {
                            bean.setComplete(true);
                        }
                        double energy = 0.0;
                        if (!processor.getProtocol().getProtocolID().equals("P1730K")) {
                            energy = processor.queryEnergyHour(begindate, hour);
                        }
                        if (web.hourEnergyException(processor, energy)) {
                            int pre = hour - 1;
                            if (pre < 0) {
                                pre = 0;
                            }
                            energy = processor.queryEnergyHour(begindate, pre);
                            energy *= 1.05;
                        }
                        energy = VolUtil.round(energy * 0.001, 3);
                        bean.setQueryperiod(3);
                        bean.setQuantity(energy);
                        bean.setTrandate((Calendar)begindate.clone());
                        bean.setHour(hour);
                        energydao.insertHour(processor.getProtocol().getProtocolID(), plan.getSerialno(), bean);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++hour;
            }
            if (tempDate.compareTo(begindate) >= 0 && !mapDays.containsKey(key = DateUtils.getFormatDate(begindate.getTime()))) {
                try {
                    EnergyBean bean = new EnergyBean();
                    if (tempDate.compareTo(begindate) == 0) {
                        bean.setComplete(false);
                    } else {
                        bean.setComplete(true);
                    }
                    double energy = processor.queryEnergyDay(begindate);
                    if (web.dayEnergyException(processor, energy)) {
                        energy = energydao.querySummaryHour(plan.getSerialno(), begindate);
                        energy *= 1000.0;
                    }
                    energy = VolUtil.round(energy * 0.001, 3);
                    bean.setQueryperiod(2);
                    bean.setQuantity(energy);
                    bean.setTrandate((Calendar)begindate.clone());
                    energydao.insertDay(processor.getProtocol().getProtocolID(), plan.getSerialno(), bean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            begindate.add(5, 1);
        }
        Calendar currentTime = processor.getCurrentTime();
        Calendar currentMonth = DateUtils.getStartofMonth(currentTime);
        int currentYear = currentTime.get(1);
        Calendar startdateMonth = DateUtils.getStartofMonth((Calendar)startdate.clone());
        String startyearmonth = DateUtils.getFormatDate(DateUtils.getFormatDate(startdateMonth.getTime()), "yyyyMM");
        Calendar enddateMonth = DateUtils.getStartofMonth((Calendar)enddate.clone());
        String endyearmonth = DateUtils.getFormatDate(DateUtils.getFormatDate(enddateMonth.getTime()), "yyyyMM");
        if (Integer.parseInt(startyearmonth) <= Integer.parseInt(endyearmonth)) {
            energydao.deleteMonths(plan.getSerialno(), startyearmonth, endyearmonth);
            while (startdateMonth.compareTo(enddateMonth) <= 0) {
                if (SystemEnv.stopping) break;
                EnergyBean bean = new EnergyBean();
                bean.setQueryperiod(1);
                bean.setYear(startdateMonth.get(1));
                bean.setYearmonth(String.format("%4d%02d", startdateMonth.get(1), startdateMonth.get(2) + 1));
                if (startdateMonth.compareTo(enddateMonth) == 0 && startdateMonth.compareTo(currentMonth) == 0) {
                    bean.setComplete(false);
                } else {
                    bean.setComplete(true);
                }
                Calendar startday = startdateMonth;
                Calendar endday = DateUtils.getEndofMonth(startday);
                double energyValue = energydao.queryMonthEnergy(plan.getSerialno(), startday, endday);
                bean.setQuantity(energyValue);
                energydao.insertMonth(processor.getProtocol().getProtocolID(), plan.getSerialno(), bean);
                startdateMonth.add(2, 1);
            }
        }
        int startyear = startdate.get(1);
        int endyear = enddate.get(1);
        if (endyear >= startyear) {
            while (endyear >= startyear) {
                if (SystemEnv.stopping) break;
                try {
                    energydao.deleteYears(plan.getSerialno(), startyear);
                    EnergyBean bean = new EnergyBean();
                    bean.setQueryperiod(0);
                    bean.setYear(startyear);
                    if (endyear == startyear && startyear == currentYear) {
                        bean.setComplete(false);
                    } else {
                        bean.setComplete(true);
                    }
                    String startMonth = String.format("%4d%02d", startyear, 1);
                    String endMonth = String.format("%4d%02d", endyear, 12);
                    double energy = energydao.queryYearEnergy(plan.getSerialno(), startMonth, endMonth);
                    bean.setQuantity(energy);
                    energydao.insertYear(processor.getProtocol().getProtocolID(), plan.getSerialno(), bean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++startyear;
            }
        }
        if (isAuto) {
            SystemEnv.energySynchroing = false;
            EventsHandler.handleEvent(processor.getProtocol().getProtocolID(), plan.getSerialno(), processor.getCurrentTime().getTime(), "3005");
        } else {
            EventsHandler.handleEvent(processor.getProtocol().getProtocolID(), plan.getSerialno(), processor.getCurrentTime().getTime(), "3007");
        }
        if (SynchronizeDataJDialog.startButton != null) {
            SynchronizeDataJDialog.startButton.setEnabled(true);
        }
    }
}

