/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalComboBoxUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (MetalLookAndFeel.usingOcean()) {
            super.paint(graphics, jComponent);
        }
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        if (MetalLookAndFeel.usingOcean()) {
            rectangle.x += 2;
            rectangle.width -= 3;
            if (this.arrowButton != null) {
                Insets insets = this.arrowButton.getInsets();
                rectangle.y += insets.top;
                rectangle.height -= insets.top + insets.bottom;
            } else {
                rectangle.y += 2;
                rectangle.height -= 4;
            }
            super.paintCurrentValue(graphics, rectangle, bl);
        } else if (graphics == null || rectangle == null) {
            throw new NullPointerException("Must supply a non-null Graphics and Rectangle");
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        if (MetalLookAndFeel.usingOcean()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 3);
            if (bl && !this.isPopupVisible(this.comboBox) && this.arrowButton != null) {
                graphics.setColor(this.listBox.getSelectionBackground());
                Insets insets = this.arrowButton.getInsets();
                if (insets.top > 2) {
                    graphics.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 3, insets.top - 2);
                }
                if (insets.bottom > 2) {
                    graphics.fillRect(rectangle.x + 2, rectangle.y + rectangle.height - insets.bottom, rectangle.width - 3, insets.bottom - 2);
                }
            }
        } else if (graphics == null || rectangle == null) {
            throw new NullPointerException("Must supply a non-null Graphics and Rectangle");
        }
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        int n3;
        if (MetalLookAndFeel.usingOcean() && n2 >= 4) {
            n3 = super.getBaseline(jComponent, n, n2 -= 4);
            if (n3 >= 0) {
                n3 += 2;
            }
        } else {
            n3 = super.getBaseline(jComponent, n, n2);
        }
        return n3;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    @Override
    protected ComboPopup createPopup() {
        return super.createPopup();
    }

    @Override
    protected JButton createArrowButton() {
        boolean bl = this.comboBox.isEditable() || MetalLookAndFeel.usingOcean();
        MetalComboBoxButton metalComboBoxButton = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), bl, this.currentValuePane, this.listBox);
        metalComboBoxButton.setMargin(new Insets(0, 1, 1, 3));
        if (MetalLookAndFeel.usingOcean()) {
            metalComboBoxButton.putClientProperty(MetalBorders.NO_BUTTON_ROLLOVER, Boolean.TRUE);
        }
        this.updateButtonForOcean(metalComboBoxButton);
        return metalComboBoxButton;
    }

    private void updateButtonForOcean(JButton jButton) {
        if (MetalLookAndFeel.usingOcean()) {
            jButton.setFocusPainted(this.comboBox.isEditable());
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    @Deprecated
    protected void editablePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    public void layoutComboBox(Container container, MetalComboBoxLayoutManager metalComboBoxLayoutManager) {
        Cloneable cloneable;
        if (this.comboBox.isEditable() && !MetalLookAndFeel.usingOcean()) {
            metalComboBoxLayoutManager.superLayout(container);
            return;
        }
        if (this.arrowButton != null) {
            if (MetalLookAndFeel.usingOcean()) {
                cloneable = this.comboBox.getInsets();
                int n = this.arrowButton.getMinimumSize().width;
                this.arrowButton.setBounds(MetalUtils.isLeftToRight(this.comboBox) ? this.comboBox.getWidth() - cloneable.right - n : cloneable.left, cloneable.top, n, this.comboBox.getHeight() - cloneable.top - cloneable.bottom);
            } else {
                cloneable = this.comboBox.getInsets();
                int n = this.comboBox.getWidth();
                int n2 = this.comboBox.getHeight();
                this.arrowButton.setBounds(cloneable.left, cloneable.top, n - (cloneable.left + cloneable.right), n2 - (cloneable.top + cloneable.bottom));
            }
        }
        if (this.editor != null && MetalLookAndFeel.usingOcean()) {
            cloneable = this.rectangleForCurrentValue();
            this.editor.setBounds((Rectangle)cloneable);
        }
    }

    @Deprecated
    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public void configureEditor() {
        super.configureEditor();
    }

    @Override
    public void unconfigureEditor() {
        super.unconfigureEditor();
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null) {
            Insets insets = this.arrowButton.getInsets();
            Insets insets2 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.width += insets2.left + insets2.right;
            dimension.width += insets.right;
            dimension.width += this.arrowButton.getMinimumSize().width;
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            Insets insets = this.arrowButton.getMargin();
            dimension.height += insets.top + insets.bottom;
            dimension.width += insets.left + insets.right;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        @Override
        public void layoutContainer(Container container) {
            MetalComboBoxUI.this.layoutComboBox(container, this);
        }

        public void superLayout(Container container) {
            super.layoutContainer(container);
        }
    }

    @Deprecated
    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public void delegateFocus(MouseEvent mouseEvent) {
            super.delegateFocus(mouseEvent);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string == "editable") {
                if (MetalComboBoxUI.this.arrowButton instanceof MetalComboBoxButton) {
                    MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)MetalComboBoxUI.this.arrowButton;
                    metalComboBoxButton.setIconOnly(MetalComboBoxUI.this.comboBox.isEditable() || MetalLookAndFeel.usingOcean());
                }
                MetalComboBoxUI.this.comboBox.repaint();
                MetalComboBoxUI.this.updateButtonForOcean(MetalComboBoxUI.this.arrowButton);
            } else if (string == "background") {
                Color color = (Color)propertyChangeEvent.getNewValue();
                MetalComboBoxUI.this.arrowButton.setBackground(color);
                MetalComboBoxUI.this.listBox.setBackground(color);
            } else if (string == "foreground") {
                Color color = (Color)propertyChangeEvent.getNewValue();
                MetalComboBoxUI.this.arrowButton.setForeground(color);
                MetalComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

