/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.ClassUtils;

abstract class AutowireUtils {
    AutowireUtils() {
    }

    public static void sortConstructors(Constructor[] constructorArray) {
        Arrays.sort(constructorArray, new Comparator(){

            public int compare(Object object, Object object2) {
                boolean bl;
                Constructor constructor = (Constructor)object;
                Constructor constructor2 = (Constructor)object2;
                boolean bl2 = Modifier.isPublic(constructor.getModifiers());
                if (bl2 != (bl = Modifier.isPublic(constructor2.getModifiers()))) {
                    return bl2 ? -1 : 1;
                }
                int n = constructor.getParameterTypes().length;
                int n2 = constructor2.getParameterTypes().length;
                return new Integer(n).compareTo(new Integer(n2)) * -1;
            }
        });
    }

    public static int getTypeDifferenceWeight(Class[] classArray, Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            if (!ClassUtils.isAssignableValue((Class)classArray[i], (Object)objectArray[i])) {
                return Integer.MAX_VALUE;
            }
            if (objectArray[i] == null) continue;
            Class<?> clazz = objectArray[i].getClass().getSuperclass();
            while (clazz != null) {
                if (ClassUtils.isAssignable((Class)classArray[i], clazz)) {
                    ++n;
                    clazz = clazz.getSuperclass();
                    continue;
                }
                clazz = null;
            }
        }
        return n;
    }

    public static boolean isExcludedFromDependencyCheck(PropertyDescriptor propertyDescriptor) {
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            return false;
        }
        if (method.getDeclaringClass().getName().indexOf("$$") == -1) {
            return false;
        }
        Class<?> clazz = method.getDeclaringClass().getSuperclass();
        return !ClassUtils.hasMethod(clazz, (String)method.getName(), (Class[])method.getParameterTypes());
    }

    public static boolean isSetterDefinedInInterface(PropertyDescriptor propertyDescriptor, Set set) {
        Method method = propertyDescriptor.getWriteMethod();
        if (method != null) {
            Class<?> clazz = method.getDeclaringClass();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Class clazz2 = (Class)iterator.next();
                if (!clazz2.isAssignableFrom(clazz) || !ClassUtils.hasMethod((Class)clazz2, (String)method.getName(), (Class[])method.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }
}

