/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class ArgumentConvertingMethodInvoker
extends MethodInvoker {
    private TypeConverter typeConverter;
    private boolean useDefaultConverter = true;

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        this.useDefaultConverter = false;
    }

    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null && this.useDefaultConverter) {
            this.typeConverter = this.getDefaultTypeConverter();
        }
        return this.typeConverter;
    }

    protected TypeConverter getDefaultTypeConverter() {
        return new SimpleTypeConverter();
    }

    public void registerCustomEditor(Class clazz, PropertyEditor propertyEditor) {
        TypeConverter typeConverter = this.getTypeConverter();
        if (!(typeConverter instanceof PropertyEditorRegistry)) {
            throw new IllegalStateException("TypeConverter does not implement PropertyEditorRegistry interface: " + typeConverter);
        }
        ((PropertyEditorRegistry)((Object)typeConverter)).registerCustomEditor(clazz, propertyEditor);
    }

    protected Method findMatchingMethod() {
        Method[] methodArray = this.getTargetClass().getMethods();
        Object[] objectArray = this.getArguments();
        int n = objectArray.length;
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            if (!methodArray[i].getName().equals(this.getTargetMethod()) || (classArray = methodArray[i].getParameterTypes()).length != n) continue;
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                if (!ClassUtils.isAssignableValue(classArray[j], (Object)objectArray[j])) continue;
                ++n2;
            }
            if (n2 != n) continue;
            return methodArray[i];
        }
        TypeConverter typeConverter = this.getTypeConverter();
        if (typeConverter != null) {
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?>[] classArray;
                if (!methodArray[i].getName().equals(this.getTargetMethod()) || (classArray = methodArray[i].getParameterTypes()).length != n) continue;
                Object[] objectArray2 = new Object[n];
                int n3 = 0;
                for (int j = 0; j < n; ++j) {
                    try {
                        objectArray2[j] = typeConverter.convertIfNecessary(objectArray[j], classArray[j]);
                        ++n3;
                        continue;
                    }
                    catch (TypeMismatchException typeMismatchException) {
                        // empty catch block
                    }
                }
                if (n3 != objectArray2.length) continue;
                this.setArguments(objectArray2);
                return methodArray[i];
            }
        }
        return null;
    }
}

