/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;
import sun.nio.fs.AbstractUserDefinedFileAttributeView;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixPath;

class LinuxUserDefinedFileAttributeView
extends AbstractUserDefinedFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final String USER_NAMESPACE = "user.";
    private static final int XATTR_NAME_MAX = 255;
    private final UnixPath file;
    private final boolean followLinks;

    private byte[] nameAsBytes(UnixPath unixPath, String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("'name' is null");
        }
        string = USER_NAMESPACE + string;
        byte[] byArray = string.getBytes();
        if (byArray.length > 255) {
            throw new FileSystemException(unixPath.getPathForExceptionMessage(), null, "'" + string + "' is too big");
        }
        return byArray;
    }

    private List<String> asList(long l, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (unsafe.getByte(l + (long)i) != 0) continue;
            int n3 = i - n2;
            byte[] byArray = new byte[n3];
            unsafe.copyMemory(null, l + (long)n2, byArray, Unsafe.ARRAY_BYTE_BASE_OFFSET, n3);
            String string = new String(byArray);
            if (string.startsWith(USER_NAMESPACE)) {
                string = string.substring(USER_NAMESPACE.length());
                arrayList.add(string);
            }
            n2 = i + 1;
        }
        return arrayList;
    }

    LinuxUserDefinedFileAttributeView(UnixPath unixPath, boolean bl) {
        this.file = unixPath;
        this.followLinks = bl;
    }

    @Override
    public List<String> list() throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int n = this.file.openForAttributeAccess(this.followLinks);
        NativeBuffer nativeBuffer = null;
        try {
            int n2 = 1024;
            nativeBuffer = NativeBuffers.getNativeBuffer(n2);
            while (true) {
                try {
                    int n3 = LinuxNativeDispatcher.flistxattr(n, nativeBuffer.address(), n2);
                    List<String> list = this.asList(nativeBuffer.address(), n3);
                    List<String> list2 = Collections.unmodifiableList(list);
                    return list2;
                }
                catch (UnixException unixException) {
                    if (unixException.errno() == 34 && n2 < 32768) {
                        nativeBuffer.release();
                        nativeBuffer = null;
                        nativeBuffer = NativeBuffers.getNativeBuffer(n2 *= 2);
                        continue;
                    }
                    throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get list of extended attributes: " + unixException.getMessage());
                }
                break;
            }
        }
        finally {
            if (nativeBuffer != null) {
                nativeBuffer.release();
            }
            LinuxNativeDispatcher.close(n);
        }
    }

    @Override
    public int size(String string) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            int n2 = LinuxNativeDispatcher.fgetxattr(n, this.nameAsBytes(this.file, string), 0L, 0);
            return n2;
        }
        catch (UnixException unixException) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get size of extended attribute '" + string + "': " + unixException.getMessage());
        }
        finally {
            LinuxNativeDispatcher.close(n);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int read(String string, ByteBuffer byteBuffer) throws IOException {
        long l;
        NativeBuffer nativeBuffer;
        int n;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (byteBuffer instanceof DirectBuffer) {
            nativeBuffer = null;
            l = ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2;
        } else {
            nativeBuffer = NativeBuffers.getNativeBuffer(n);
            l = nativeBuffer.address();
        }
        int n5 = this.file.openForAttributeAccess(this.followLinks);
        try {
            int n6;
            try {
                int n7 = LinuxNativeDispatcher.fgetxattr(n5, this.nameAsBytes(this.file, string), l, n);
                if (n == 0) {
                    if (n7 > 0) {
                        throw new UnixException(34);
                    }
                    int n8 = 0;
                    return n8;
                }
                if (nativeBuffer != null) {
                    n6 = byteBuffer.arrayOffset() + n2 + Unsafe.ARRAY_BYTE_BASE_OFFSET;
                    unsafe.copyMemory(null, l, byteBuffer.array(), n6, n7);
                }
                byteBuffer.position(n2 + n7);
                n6 = n7;
            }
            catch (UnixException unixException) {
                String string2 = unixException.errno() == 34 ? "Insufficient space in buffer" : unixException.getMessage();
                throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Error reading extended attribute '" + string + "': " + string2);
            }
            finally {
                LinuxNativeDispatcher.close(n5);
            }
            return n6;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (nativeBuffer != null) {
                nativeBuffer.release();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int write(String string, ByteBuffer byteBuffer) throws IOException {
        int n;
        long l;
        NativeBuffer nativeBuffer;
        int n2;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        assert (n3 <= n4);
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (byteBuffer instanceof DirectBuffer) {
            nativeBuffer = null;
            l = ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3;
        } else {
            nativeBuffer = NativeBuffers.getNativeBuffer(n2);
            l = nativeBuffer.address();
            if (byteBuffer.hasArray()) {
                n = byteBuffer.arrayOffset() + n3 + Unsafe.ARRAY_BYTE_BASE_OFFSET;
                unsafe.copyMemory(byteBuffer.array(), n, null, l, n2);
            } else {
                byte[] byArray = new byte[n2];
                byteBuffer.get(byArray);
                byteBuffer.position(n3);
                unsafe.copyMemory(byArray, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, l, n2);
            }
        }
        n = this.file.openForAttributeAccess(this.followLinks);
        try {
            try {
                LinuxNativeDispatcher.fsetxattr(n, this.nameAsBytes(this.file, string), l, n2);
                byteBuffer.position(n3 + n2);
                int n6 = n2;
                return n6;
            }
            catch (UnixException unixException) {
                throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Error writing extended attribute '" + string + "': " + unixException.getMessage());
            }
            finally {
                LinuxNativeDispatcher.close(n);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (nativeBuffer != null) {
                nativeBuffer.release();
            }
        }
    }

    @Override
    public void delete(String string) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            LinuxNativeDispatcher.fremovexattr(n, this.nameAsBytes(this.file, string));
        }
        catch (UnixException unixException) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to delete extended attribute '" + string + "': " + unixException.getMessage());
        }
        finally {
            LinuxNativeDispatcher.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyExtendedAttributes(int n, int n2) {
        NativeBuffer nativeBuffer = null;
        try {
            int n3 = 1024;
            nativeBuffer = NativeBuffers.getNativeBuffer(n3);
            while (true) {
                try {
                    n3 = LinuxNativeDispatcher.flistxattr(n, nativeBuffer.address(), n3);
                }
                catch (UnixException unixException) {
                    if (unixException.errno() == 34 && n3 < 32768) {
                        nativeBuffer.release();
                        nativeBuffer = null;
                        nativeBuffer = NativeBuffers.getNativeBuffer(n3 *= 2);
                        continue;
                    }
                    if (nativeBuffer != null) {
                        nativeBuffer.release();
                    }
                    return;
                }
                break;
            }
            long l = nativeBuffer.address();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                if (unsafe.getByte(l + (long)i) != 0) continue;
                int n5 = i - n4;
                byte[] byArray = new byte[n5];
                unsafe.copyMemory(null, l + (long)n4, byArray, Unsafe.ARRAY_BYTE_BASE_OFFSET, n5);
                try {
                    LinuxUserDefinedFileAttributeView.copyExtendedAttribute(n, byArray, n2);
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
                n4 = i + 1;
            }
        }
        finally {
            if (nativeBuffer != null) {
                nativeBuffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyExtendedAttribute(int n, byte[] byArray, int n2) throws UnixException {
        int n3 = LinuxNativeDispatcher.fgetxattr(n, byArray, 0L, 0);
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(n3);
        try {
            long l = nativeBuffer.address();
            n3 = LinuxNativeDispatcher.fgetxattr(n, byArray, l, n3);
            LinuxNativeDispatcher.fsetxattr(n2, byArray, l, n3);
        }
        finally {
            nativeBuffer.release();
        }
    }
}

