/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.control.IP1516ControlModule;
import cn.com.voltronic.solar.control.IP16ControlModule;
import cn.com.voltronic.solar.control.P16ComUSBControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.ModelPlanBean;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;

public class P17ComUSBControlModule
extends P16ComUSBControlModule
implements IP1516ControlModule,
IP16ControlModule {
    public P17ComUSBControlModule(Object handler, ConfigData config, Capability capability) {
        super(handler, config, capability);
    }

    @Override
    public boolean setPF() {
        boolean result = true;
        try {
            result = this.excuteSetCommand("PF", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setCapability(String x, boolean isEnable) {
        boolean result = true;
        try {
            result = this.excuteSetCommand(isEnable ? "PE" : "PD", x);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPVIPLV(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("SILV", String.format("%04d", (int)value * 10));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPVIPHV(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("SIHV", String.format("%04d", (int)value * 10));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMPPTLV(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("MPPTLV", String.format("%04d", (int)value * 10));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMPPTHV(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("MPPTHV", String.format("%04d", (int)value * 10));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxChargingCurrent(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("MCHGC", String.format("%04d", (int)(value * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxAcChargingCurrent(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("MUCHGC", String.format("%04d", (int)(value * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setMCHGV(double floatChargeVol, double maxChargeVol) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("MCHGV", String.format("%04d,%04d", (int)(maxChargeVol * 10.0), (int)(floatChargeVol * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOLV(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("GOLV", String.format("%04d", (int)(value * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOHV(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("GOHV", String.format("%04d", (int)(value * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOLF(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("GOLF", String.format("%04d", (int)(value * 100.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOHF(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("GOHF", String.format("%04d", (int)(value * 100.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGridWaittime(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("FT", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGILTHV(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("GLTHV", String.format("%04d", (int)(value * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxPowerFeedingGrid(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("GPMP", String.format("%06d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setLCD(String value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("LST", this.getFomatStr(String.valueOf(value), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBTNUM(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("BTNUM", String.format("%02d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setBatDischargeVol(double batUnderVol, double underBackVol, double batWeakVol, double weakBackVol) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("BATDV", String.format("%04d,%04d,%04d,%04d", (int)(batUnderVol * 10.0), (int)(underBackVol * 10.0), (int)(batWeakVol * 10.0), (int)(weakBackVol * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setCurrentTime(String time) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("DAT", String.valueOf(time));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setLiBatterySetting(double mincurrent, double recovervoltage, double time) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("BCA", String.format("%04d,%03d,%04d", (int)(mincurrent * 10.0), (int)time, (int)(recovervoltage * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean loadsMachineSupplyPower(String isEnable) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("LON", isEnable);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setBatTptCompensate(double tptCompensate) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("BTS", String.format("%03d", (int)(tptCompensate * 10.0)));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setLBF(int value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("BT", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean activeLifeBattery() {
        boolean result = true;
        try {
            result = this.excuteSetCommand("BST", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGridPowerDeviation(double value) {
        boolean result = true;
        try {
            if (value < 0.0) {
                value = Math.abs(value);
                result = this.excuteSetCommand("FPADJ", "0," + String.format("%04d", (int)value));
            } else {
                result = this.excuteSetCommand("FPADJ", "1," + String.format("%04d", (int)value));
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setFeedingGridCalibrationPowerR(double value) {
        boolean result = true;
        try {
            if (value < 0.0) {
                value = Math.abs(value);
                result = this.excuteSetCommand("FPRADJ", "0," + String.format("%04d", (int)value));
            } else {
                result = this.excuteSetCommand("FPRADJ", "1," + String.format("%04d", (int)value));
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setFeedingGridCalibrationPowerS(double value) {
        boolean result = true;
        try {
            if (value < 0.0) {
                value = Math.abs(value);
                result = this.excuteSetCommand("FPSADJ", "0," + String.format("%04d", (int)value));
            } else {
                result = this.excuteSetCommand("FPSADJ", "1," + String.format("%04d", (int)value));
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setFeedingGridCalibrationPowerT(double value) {
        boolean result = true;
        try {
            if (value < 0.0) {
                value = Math.abs(value);
                result = this.excuteSetCommand("FPTADJ", "0," + String.format("%04d", (int)value));
            } else {
                result = this.excuteSetCommand("FPTADJ", "1," + String.format("%04d", (int)value));
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBatDischargeMaxCurrentInHybridMode(double value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("BDCM", String.format("%04d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setFeedinPowerFactor(double value) {
        boolean result = true;
        try {
            value *= 100.0;
            if (value < 0.0) {
                value = Math.abs(value) + 100.0;
            }
            result = this.excuteSetCommand("FPPF", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setPALE(int value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("PALE", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setAAPF(int isEnabled, double valueA, double valueB) {
        boolean result = true;
        try {
            int vA = (int)valueA;
            String value1 = String.format("%03d", vA);
            valueB = Math.abs(valueB) * 100.0 + 100.0;
            int value2 = (int)valueB;
            result = this.excuteSetCommand("AAPF", String.valueOf(isEnabled) + "," + value1 + "," + value2);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setEPS(int isEnabled, double valueA, double valueB) {
        boolean result = true;
        try {
            int vA = (int)(valueA * 10.0);
            String value1 = String.format("%04d", vA);
            int vB = (int)(valueB * 10.0);
            String value2 = String.format("%04d", vB);
            result = this.excuteSetCommand("EPS", String.valueOf(isEnabled) + "," + value1 + "," + value2);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setPLE(int value) {
        boolean result = true;
        try {
            result = this.excuteSetCommand("PLE", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setModelChange(ModelPlanBean bean, ConfigData configData, IProtocol protocol) {
        AbstractProcessor processor;
        String planid;
        boolean goStandby = false;
        boolean nextStep = true;
        boolean bchangePvPlan = false;
        boolean needToRefresh = false;
        if (!bean.getP17ModelID().equals(configData.getModelID())) {
            goStandby = true;
        } else if ((int)bean.getP17NominalVoltage() != (int)configData.getNominalVoltage() || (int)bean.getNominalFreq() != (int)configData.getNominalFreq()) {
            goStandby = true;
        } else if ((bean.getModeltype().equalsIgnoreCase("10") || bean.getModeltype().equalsIgnoreCase("01")) && !bean.getP17PlanID().equalsIgnoreCase(configData.getPlanID())) {
            goStandby = true;
            bchangePvPlan = true;
        }
        if (goStandby) {
            try {
                if (!bean.getP17ModelID().equals(configData.getModelID())) {
                    nextStep = false;
                    if (this.excuteSetCommand("DM", bean.getP17ModelID())) {
                        configData.setModelID(bean.getP17ModelID());
                        protocol.setDeviceModel(bean.getP17ModelID());
                        protocol.setModelType(bean.getModeltype());
                        needToRefresh = true;
                        nextStep = true;
                        if (bean.getModeltype().equals("10")) {
                            nextStep = false;
                            if (this.excuteSetCommand("SEP", bean.getP17PlanID())) {
                                configData.setPlanID(bean.getP17PlanID());
                                nextStep = true;
                            }
                        } else if (bean.getModeltype().equals("01")) {
                            nextStep = false;
                            planid = bean.getP17PlanID();
                            if (planid.equals("02")) {
                                if (this.excuteSetCommand("SEP", "00")) {
                                    configData.setPlanID(bean.getP17PlanID());
                                    nextStep = true;
                                }
                            } else if (planid.equals("00")) {
                                if (this.excuteSetCommand("SEP", "01")) {
                                    configData.setPlanID(bean.getP17PlanID());
                                    nextStep = true;
                                }
                            } else if (planid.equals("01") && this.excuteSetCommand("SEP", "00")) {
                                configData.setPlanID(bean.getP17PlanID());
                                nextStep = true;
                            }
                        }
                    }
                } else if (bean.getModeltype().equals("10")) {
                    if (!bean.getP17PlanID().equalsIgnoreCase(configData.getPlanID())) {
                        nextStep = false;
                        if (this.excuteSetCommand("SEP", bean.getP17PlanID())) {
                            configData.setPlanID(bean.getP17PlanID());
                            nextStep = true;
                        }
                    }
                } else if (bean.getModeltype().equals("01") && !bean.getP17PlanID().equalsIgnoreCase(configData.getPlanID())) {
                    nextStep = false;
                    planid = bean.getP17PlanID();
                    if (planid.equals("02")) {
                        if (this.excuteSetCommand("SEP", "00")) {
                            configData.setPlanID(bean.getP17PlanID());
                            nextStep = true;
                        }
                    } else if (planid.equals("00")) {
                        if (this.excuteSetCommand("SEP", "01")) {
                            configData.setPlanID(bean.getP17PlanID());
                            nextStep = true;
                        }
                    } else if (planid.equals("01") && this.excuteSetCommand("SEP", "00")) {
                        configData.setPlanID(bean.getP17PlanID());
                        nextStep = true;
                    }
                }
                if (nextStep && (int)bean.getP17NominalVoltage() != (int)configData.getNominalVoltage()) {
                    nextStep = false;
                    if (this.excuteSetCommand("V", String.valueOf(String.format("%03d", (int)bean.getP17NominalVoltage())) + "0")) {
                        configData.setNominalVoltage(bean.getP17NominalVoltage());
                        nextStep = true;
                    }
                }
                if (nextStep && (int)bean.getNominalFreq() != (int)configData.getNominalFreq()) {
                    nextStep = false;
                    if (this.excuteSetCommand("F", String.format("%02d", (int)bean.getNominalFreq()))) {
                        configData.setNominalFreq(bean.getNominalFreq());
                        nextStep = true;
                    }
                }
                if (bean.getModeltype().equals("01")) {
                    this.setFeedinPowerFactor(100.0);
                }
                if ((processor = GlobalProcessors.getCurrentProcessor()) != null) {
                    processor.getProtocol().setModelType(bean.getModeltype());
                }
            }
            catch (Exception processor2) {
                // empty catch block
            }
        }
        try {
            if (nextStep) {
                planid = bean.getP17PlanID();
                if (!bean.getModeltype().equals("00")) {
                    if (nextStep && bean.getCheck_charge() != configData.getCheck_charge() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteSetCommand("EDA", String.valueOf(bean.getCheck_charge()))) {
                            configData.setCheck_charge(bean.getCheck_charge());
                            nextStep = true;
                        }
                    }
                    if (nextStep && bean.getCheck_accharge() != configData.getCheck_accharge() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteSetCommand("EDB", String.valueOf(bean.getCheck_accharge()))) {
                            configData.setCheck_accharge(bean.getCheck_accharge());
                            nextStep = true;
                        }
                    }
                }
                if (bean.getModeltype().equals("10") && nextStep && (bean.getCheck_pvfeedgrid() != configData.getCheck_pvfeedgrid() || bchangePvPlan)) {
                    nextStep = false;
                    if (this.excuteSetCommand("EDC", String.valueOf(bean.getCheck_pvfeedgrid()))) {
                        configData.setCheck_pvfeedgrid(bean.getCheck_pvfeedgrid());
                        nextStep = true;
                    }
                }
                if (bean.getModeltype().equals("10") && !planid.equals("03") || bean.getModeltype().equals("01")) {
                    if (nextStep && bean.getCheck_batdispvon() != configData.getCheck_batdispvon() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteSetCommand("EDD", String.valueOf(bean.getCheck_batdispvon()))) {
                            configData.setCheck_batdispvon(bean.getCheck_batdispvon());
                            nextStep = true;
                        }
                    }
                    if (nextStep && bean.getCheck_batdispvloss() != configData.getCheck_batdispvloss() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteSetCommand("EDE", String.valueOf(bean.getCheck_batdispvloss()))) {
                            configData.setCheck_batdispvloss(bean.getCheck_batdispvloss());
                            nextStep = true;
                        }
                    }
                }
                if (bean.getModeltype().equals("10") && !planid.equals("03")) {
                    if (nextStep && bean.getCheck_batfeedpvon() != configData.getCheck_batfeedpvon() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteSetCommand("EDF", String.valueOf(bean.getCheck_batfeedpvon()))) {
                            configData.setCheck_batfeedpvon(bean.getCheck_batfeedpvon());
                            nextStep = true;
                        }
                    }
                    if (nextStep && bean.getCheck_batfeedpvloss() != configData.getCheck_batfeedpvloss() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteSetCommand("EDG", String.valueOf(bean.getCheck_batfeedpvloss()))) {
                            configData.setCheck_batfeedpvloss(bean.getCheck_batfeedpvloss());
                            nextStep = true;
                        }
                    }
                }
                if (bean.getCheck_accharge() == 1) {
                    if (!(!nextStep || bean.getAcChargingStarttime().equals(configData.getAcChargeStarttime()) && bean.getAcChargingEndtime().equals(configData.getAcChargeEndtime()) && bean.getAcChargingStarttime2().equals(configData.getAcChargeStarttime2()) && bean.getAcChargingEndtime2().equals(configData.getAcChargeEndtime2()))) {
                        nextStep = false;
                        if (configData.getAcctParams() == 4) {
                            if (this.excuteSetCommand("ACCT", String.valueOf(bean.getAcChargingStarttime()) + "," + bean.getAcChargingEndtime() + "," + bean.getAcChargingStarttime2() + "," + bean.getAcChargingEndtime2())) {
                                nextStep = true;
                                configData.setAcChargeStarttime(bean.getAcChargingStarttime());
                                configData.setAcChargeEndtime(bean.getAcChargingEndtime());
                                configData.setAcChargeStarttime2(bean.getAcChargingStarttime2());
                                configData.setAcChargeEndtime2(bean.getAcChargingEndtime2());
                            }
                        } else if (this.excuteSetCommand("ACCT", String.valueOf(bean.getAcChargingStarttime()) + "," + bean.getAcChargingEndtime())) {
                            nextStep = true;
                            configData.setAcChargeStarttime(bean.getAcChargingStarttime());
                            configData.setAcChargeEndtime(bean.getAcChargingEndtime());
                        }
                    }
                    if (nextStep) {
                        if (bean.getCheck_gridChargingLowestBatVol() != configData.getCheck_gridChargingLowestBatVol()) {
                            nextStep = false;
                            if (this.excuteSetCommand("ACCB", String.valueOf(bean.getCheck_gridChargingLowestBatVol()) + "," + String.format("%04d", (int)(bean.getGridChargingLowestBatVol() * 10.0)))) {
                                nextStep = true;
                                configData.setCheck_gridChargingLowestBatVol(bean.getCheck_gridChargingLowestBatVol());
                                configData.setGridChargingLowestBatVol(bean.getGridChargingLowestBatVol());
                            }
                        } else if (bean.getGridChargingLowestBatVol() != configData.getGridChargingLowestBatVol()) {
                            nextStep = false;
                            if (this.excuteSetCommand("ACCB", String.valueOf(bean.getCheck_gridChargingLowestBatVol()) + "," + String.format("%04d", (int)(bean.getGridChargingLowestBatVol() * 10.0)))) {
                                nextStep = true;
                                configData.setCheck_gridChargingLowestBatVol(bean.getCheck_gridChargingLowestBatVol());
                                configData.setGridChargingLowestBatVol(bean.getGridChargingLowestBatVol());
                            }
                        }
                    }
                    if (bean.getP17ModelID().equals("01") && nextStep) {
                        bean.getAcchargelimit();
                        configData.getAcChargingLimit();
                    }
                }
                if (!bean.getModeltype().equals("00") && (nextStep && !bean.getAcoutputStarttime().equals(configData.getAcoutputStarttime()) || !bean.getAcoutputEndtime().equals(configData.getAcoutputEndtime()))) {
                    nextStep = false;
                    if (this.excuteSetCommand("ACLT", String.valueOf(bean.getAcoutputStarttime()) + "," + bean.getAcoutputEndtime())) {
                        nextStep = true;
                        configData.setAcoutputStarttime(bean.getAcoutputStarttime());
                        configData.setAcoutputEndtime(bean.getAcoutputEndtime());
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (nextStep && needToRefresh && (processor = GlobalProcessors.getCurrentProcessor()) != null) {
            WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workinfo");
            workInfo.setNeedToReresh(true);
            IComUSBHandler _handler = (IComUSBHandler)((Object)processor.getHandler());
            String modelType = _handler.getModeType();
            if (modelType.equals("01")) {
                this.setFeedinPowerFactor(1.0);
            }
        }
        return nextStep;
    }

    @Override
    public boolean setFeefInReactivePower(double value) {
        boolean result = true;
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        ConfigData configdata = (ConfigData)processor.getBeanBag().getBean("configdata");
        try {
            result = value >= 0.0 ? this.excuteSetCommand("FPRA", String.format("%+05d", (int)value)) : this.excuteSetCommand("FPRA", String.format("%05d", (int)value));
            Constants.finalNum = value;
            configdata.setFeefInReactivePower(Constants.finalNum);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean excuteSetCommand(String command, String parmeter) throws Exception {
        IComUSBHandler _handler = this.getHandler();
        boolean result = false;
        String re = "(NAK";
        if (_handler != null) {
            if (parmeter == null || "".equals(parmeter)) {
                re = _handler.excuteSetCommand(command, true);
                System.out.println(String.valueOf(command) + " = " + re);
            } else {
                re = _handler.excuteSetCommand(String.valueOf(command) + parmeter, true);
                System.out.println(String.valueOf(command) + parmeter + " = " + re);
            }
        }
        result = re.equals("(ACK");
        return result;
    }
}

