/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class BaseSpinnerUI
extends BasicSpinnerUI {
    private static final Dimension zeroSize = new Dimension(0, 0);
    private MyLayoutManager myLayoutManager = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseSpinnerUI();
    }

    protected LayoutManager createLayout() {
        if (this.myLayoutManager == null) {
            this.myLayoutManager = new MyLayoutManager();
        }
        return this.myLayoutManager;
    }

    protected Component createNextButton() {
        SpinButton spinButton = new SpinButton(1);
        if (JTattooUtilities.isLeftToRight(this.spinner)) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 1, 0, AbstractLookAndFeel.getFrameColor());
            spinButton.setBorder(matteBorder);
        } else {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 1, AbstractLookAndFeel.getFrameColor());
            spinButton.setBorder(matteBorder);
        }
        this.installNextButtonListeners(spinButton);
        return spinButton;
    }

    protected Component createPreviousButton() {
        SpinButton spinButton = new SpinButton(5);
        if (JTattooUtilities.isLeftToRight(this.spinner)) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 1, 0, 0, AbstractLookAndFeel.getFrameColor());
            spinButton.setBorder(matteBorder);
        } else {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, AbstractLookAndFeel.getFrameColor());
            spinButton.setBorder(matteBorder);
        }
        this.installPreviousButtonListeners(spinButton);
        return spinButton;
    }

    private static class MyLayoutManager
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private MyLayoutManager() {
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? zeroSize : component.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom + 4;
            return dimension4;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (component != null) {
                component.setBounds(n, n2, n3, n4);
            }
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            int n4 = container.getWidth();
            int n5 = container.getHeight();
            Insets insets = container.getInsets();
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            int n6 = Math.max(dimension.width, dimension2.width);
            int n7 = n5 - (insets.top + insets.bottom);
            Insets insets2 = UIManager.getInsets("Spinner.arrowButtonInsets");
            if (insets2 == null) {
                insets2 = insets;
            }
            if (container.getComponentOrientation().isLeftToRight()) {
                n3 = insets.left;
                n2 = n4 - insets.left - n6 - insets2.right;
                n = n4 - n6 - insets2.right;
            } else {
                n = insets2.left;
                n3 = n + n6;
                n2 = n4 - insets2.left - n6 - insets.right;
            }
            int n8 = insets2.top;
            int n9 = n5 / 2 + n5 % 2 - n8;
            int n10 = insets2.top + n9;
            int n11 = n5 - n10 - insets2.bottom;
            this.setBounds(this.editor, n3, insets.top, n2, n7);
            this.setBounds(this.nextButton, n, n8, n6, n9);
            this.setBounds(this.previousButton, n, n10, n6, n11);
        }
    }

    public static class SpinButton
    extends NoFocusButton {
        private static Dimension minSize = new Dimension(14, 12);
        private int direction = 1;

        public SpinButton(int n) {
            this.setInheritsPopupMenu(true);
            this.direction = n;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.max(dimension.width, SpinButton.minSize.width);
            dimension.height = Math.max(dimension.height, SpinButton.minSize.height);
            return dimension;
        }

        public void paint(Graphics graphics) {
            Color[] colorArray = null;
            ButtonModel buttonModel = this.getModel();
            colorArray = this.isEnabled() ? (buttonModel.isPressed() && buttonModel.isArmed() ? AbstractLookAndFeel.getTheme().getPressedColors() : (buttonModel.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (JTattooUtilities.isFrameActive(this) ? AbstractLookAndFeel.getTheme().getButtonColors() : AbstractLookAndFeel.getTheme().getInActiveColors()))) : AbstractLookAndFeel.getTheme().getDisabledColors();
            JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, this.getWidth(), this.getHeight());
            this.paintBorder(graphics);
            graphics.setColor(this.getForeground());
            int n = 4;
            int n2 = 3;
            int n3 = (this.getWidth() - n) / 2;
            int n4 = (this.getHeight() - n2) / 2;
            if (this.direction == 1) {
                for (int i = 0; i < n2; ++i) {
                    graphics.drawLine(n3 + (n2 - i) - 1, n4 + i, n3 + n - (n2 - i) + 1, n4 + i);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    graphics.drawLine(n3 + i, n4 + i, n3 + n - i, n4 + i);
                }
            }
        }
    }
}

