/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class MethodParameter {
    private Method method;
    private Constructor constructor;
    private final int parameterIndex;
    private int nestingLevel;
    private Map typeIndexesPerLevel;

    public MethodParameter(Method method, int n) {
        this(method, n, 1);
    }

    public MethodParameter(Method method, int n, int n2) {
        Assert.notNull(method, "Method must not be null");
        this.method = method;
        this.parameterIndex = n;
        this.nestingLevel = n2;
    }

    public MethodParameter(Constructor constructor, int n) {
        this(constructor, n, 1);
    }

    public MethodParameter(Constructor constructor, int n, int n2) {
        Assert.notNull(constructor, "Constructor must not be null");
        this.constructor = constructor;
        this.parameterIndex = n;
        this.nestingLevel = n2;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public void increaseNestingLevel() {
        ++this.nestingLevel;
    }

    public void decreaseNestingLevel() {
        this.getTypeIndexesPerLevel().remove(new Integer(this.nestingLevel));
        --this.nestingLevel;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public void setTypeIndexForCurrentLevel(int n) {
        this.getTypeIndexesPerLevel().put(new Integer(this.nestingLevel), new Integer(n));
    }

    public Integer getTypeIndexForCurrentLevel() {
        return this.getTypeIndexForLevel(this.nestingLevel);
    }

    public Integer getTypeIndexForLevel(int n) {
        return (Integer)this.getTypeIndexesPerLevel().get(new Integer(n));
    }

    private Map getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap(4);
        }
        return this.typeIndexesPerLevel;
    }

    public static MethodParameter forMethodOrConstructor(Object object, int n) {
        if (object instanceof Method) {
            return new MethodParameter((Method)object, n);
        }
        if (object instanceof Constructor) {
            return new MethodParameter((Constructor)object, n);
        }
        throw new IllegalArgumentException("Given object [" + object + "] is neither a Method nor a Constructor");
    }
}

