/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private Class<? extends Annotation> requiredAnnotationType = Required.class;

    public void setRequiredAnnotationType(Class<? extends Annotation> clazz) {
        Assert.notNull(clazz, (String)"'requiredAnnotationType' must not be null");
        this.requiredAnnotationType = clazz;
    }

    protected Class<? extends Annotation> getRequiredAnnotationType() {
        return this.requiredAnnotationType;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues propertyValues, PropertyDescriptor[] propertyDescriptorArray, Object object, String string) throws BeansException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            if (!this.isRequiredProperty(propertyDescriptor) || propertyValues.contains(propertyDescriptor.getName())) continue;
            arrayList.add(propertyDescriptor.getName());
        }
        if (!arrayList.isEmpty()) {
            throw new BeanInitializationException(this.buildExceptionMessage(arrayList, string));
        }
        return propertyValues;
    }

    protected boolean isRequiredProperty(PropertyDescriptor propertyDescriptor) {
        Method method = propertyDescriptor.getWriteMethod();
        return method != null && AnnotationUtils.getAnnotation((Method)method, this.getRequiredAnnotationType()) != null;
    }

    private String buildExceptionMessage(List<String> list, String string) {
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n == 1 ? "Property" : "Properties");
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i);
            if (i > 0) {
                if (i == n - 1) {
                    stringBuilder.append(" and");
                } else {
                    stringBuilder.append(",");
                }
            }
            stringBuilder.append(" '").append(string2).append("'");
        }
        stringBuilder.append(n == 1 ? " is" : " are");
        stringBuilder.append(" required for bean '").append(string).append("'");
        return stringBuilder.toString();
    }
}

