/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodParameter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

abstract class ConstructorResolver {
    private final AbstractBeanFactory beanFactory;
    private final InstantiationStrategy instantiationStrategy;

    public ConstructorResolver(AbstractBeanFactory abstractBeanFactory, InstantiationStrategy instantiationStrategy) {
        this.beanFactory = abstractBeanFactory;
        this.instantiationStrategy = instantiationStrategy;
    }

    protected BeanWrapper autowireConstructor(String string, RootBeanDefinition rootBeanDefinition, Constructor constructor) {
        Object object;
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl();
        this.beanFactory.initBeanWrapper(beanWrapperImpl);
        Constructor constructor2 = (Constructor)rootBeanDefinition.resolvedConstructorOrFactoryMethod;
        Object[] objectArray = null;
        if (constructor2 != null) {
            objectArray = rootBeanDefinition.resolvedConstructorArguments;
            if (objectArray == null) {
                object = constructor2.getParameterTypes();
                Object[] objectArray2 = rootBeanDefinition.preparedConstructorArguments;
                BeanDefinitionValueResolver beanDefinitionValueResolver = new BeanDefinitionValueResolver(this.beanFactory, string, rootBeanDefinition, beanWrapperImpl);
                objectArray = new Object[objectArray2.length];
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object object2 = objectArray2[i];
                    if (object2 instanceof BeanMetadataElement) {
                        String string2 = "constructor argument with index " + i;
                        object2 = beanDefinitionValueResolver.resolveValueIfNecessary(string2, object2);
                    }
                    objectArray[i] = beanWrapperImpl.convertIfNecessary(object2, object[i], new MethodParameter(constructor2, i));
                }
            }
        } else {
            boolean bl = constructor != null || rootBeanDefinition.getResolvedAutowireMode() == 3;
            ConstructorArgumentValues constructorArgumentValues = rootBeanDefinition.getConstructorArgumentValues();
            ConstructorArgumentValues constructorArgumentValues2 = new ConstructorArgumentValues();
            int n = this.resolveConstructorArguments(string, rootBeanDefinition, beanWrapperImpl, constructorArgumentValues, constructorArgumentValues2);
            if (constructor != null) {
                Class[] classArray = constructor.getParameterTypes();
                objectArray = this.createArgumentArray((String)string, (RootBeanDefinition)rootBeanDefinition, (ConstructorArgumentValues)constructorArgumentValues2, (BeanWrapper)beanWrapperImpl, (Class[])classArray, (Object)constructor, (boolean)bl).arguments;
                constructor2 = constructor;
            } else {
                Constructor[] constructorArray = rootBeanDefinition.getBeanClass().getDeclaredConstructors();
                AutowireUtils.sortConstructors(constructorArray);
                int n2 = Integer.MAX_VALUE;
                for (int i = 0; i < constructorArray.length; ++i) {
                    Constructor constructor3 = constructorArray[i];
                    Class[] classArray = constructor3.getParameterTypes();
                    if (constructor2 != null && objectArray.length > classArray.length) break;
                    if (classArray.length < n) {
                        throw new BeanCreationException(rootBeanDefinition.getResourceDescription(), string, n + " constructor arguments specified but no matching constructor found in bean '" + string + "' " + "(hint: specify index and/or type arguments for simple parameters to avoid type ambiguities)");
                    }
                    try {
                        ArgumentsHolder argumentsHolder = this.createArgumentArray(string, rootBeanDefinition, constructorArgumentValues2, beanWrapperImpl, classArray, constructor3, bl);
                        int n3 = argumentsHolder.getTypeDifferenceWeight(classArray);
                        if (n3 >= n2) continue;
                        constructor2 = constructor3;
                        objectArray = argumentsHolder.arguments;
                        n2 = n3;
                        continue;
                    }
                    catch (UnsatisfiedDependencyException unsatisfiedDependencyException) {
                        if (this.beanFactory.logger.isTraceEnabled()) {
                            this.beanFactory.logger.trace((Object)("Ignoring constructor [" + constructor3 + "] of bean '" + string + "': " + (Object)((Object)unsatisfiedDependencyException)));
                        }
                        if (i != constructorArray.length - 1 || constructor2 != null) continue;
                        throw unsatisfiedDependencyException;
                    }
                }
                if (constructor2 == null) {
                    throw new BeanCreationException(rootBeanDefinition.getResourceDescription(), string, "Could not resolve matching constructor");
                }
            }
            rootBeanDefinition.resolvedConstructorOrFactoryMethod = constructor2;
        }
        object = this.instantiationStrategy.instantiate(rootBeanDefinition, string, this.beanFactory, constructor2, objectArray);
        beanWrapperImpl.setWrappedInstance(object);
        return beanWrapperImpl;
    }

    public BeanWrapper instantiateUsingFactoryMethod(String string, RootBeanDefinition rootBeanDefinition, Object[] objectArray) {
        Object object;
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl();
        this.beanFactory.initBeanWrapper(beanWrapperImpl);
        Class<?> clazz = null;
        Object object2 = null;
        boolean bl = true;
        if (rootBeanDefinition.getFactoryBeanName() != null) {
            object2 = this.beanFactory.getBean(rootBeanDefinition.getFactoryBeanName());
            clazz = object2.getClass();
            bl = false;
        } else {
            clazz = rootBeanDefinition.getBeanClass();
        }
        GenericDeclaration genericDeclaration = (Method)rootBeanDefinition.resolvedConstructorOrFactoryMethod;
        Object[] objectArray2 = null;
        if (genericDeclaration != null) {
            if (objectArray != null) {
                objectArray2 = objectArray;
            } else {
                objectArray2 = rootBeanDefinition.resolvedConstructorArguments;
                if (objectArray2 == null) {
                    object = genericDeclaration.getParameterTypes();
                    Object[] objectArray3 = rootBeanDefinition.preparedConstructorArguments;
                    BeanDefinitionValueResolver beanDefinitionValueResolver = new BeanDefinitionValueResolver(this.beanFactory, string, rootBeanDefinition, beanWrapperImpl);
                    objectArray2 = new Object[objectArray3.length];
                    for (int i = 0; i < objectArray3.length; ++i) {
                        Object object3 = objectArray3[i];
                        if (object3 instanceof BeanMetadataElement) {
                            String string2 = "factory method argument with index " + i;
                            object3 = beanDefinitionValueResolver.resolveValueIfNecessary(string2, object3);
                        }
                        objectArray2[i] = beanWrapperImpl.convertIfNecessary(object3, (Class)object[i], new MethodParameter(genericDeclaration, i));
                    }
                }
            }
        } else {
            object = ReflectionUtils.getAllDeclaredMethods(clazz);
            boolean bl2 = rootBeanDefinition.getResolvedAutowireMode() == 3;
            int n = Integer.MAX_VALUE;
            ConstructorArgumentValues constructorArgumentValues = null;
            int n2 = 0;
            if (objectArray != null) {
                n2 = objectArray.length;
            } else {
                ConstructorArgumentValues constructorArgumentValues2 = rootBeanDefinition.getConstructorArgumentValues();
                constructorArgumentValues = new ConstructorArgumentValues();
                n2 = this.resolveConstructorArguments(string, rootBeanDefinition, beanWrapperImpl, constructorArgumentValues2, constructorArgumentValues);
            }
            for (int i = 0; i < ((GenericDeclaration[])object).length; ++i) {
                GenericDeclaration genericDeclaration2 = object[i];
                Class[] classArray = ((Method)genericDeclaration2).getParameterTypes();
                if (Modifier.isStatic(((Method)genericDeclaration2).getModifiers()) != bl || !((Method)genericDeclaration2).getName().equals(rootBeanDefinition.getFactoryMethodName()) || classArray.length < n2) continue;
                ArgumentsHolder argumentsHolder = null;
                if (constructorArgumentValues != null) {
                    try {
                        argumentsHolder = this.createArgumentArray(string, rootBeanDefinition, constructorArgumentValues, beanWrapperImpl, classArray, genericDeclaration2, bl2);
                    }
                    catch (UnsatisfiedDependencyException unsatisfiedDependencyException) {
                        if (this.beanFactory.logger.isTraceEnabled()) {
                            this.beanFactory.logger.trace((Object)("Ignoring factory method [" + genericDeclaration2 + "] of bean '" + string + "': " + (Object)((Object)unsatisfiedDependencyException)));
                        }
                        if (i != ((GenericDeclaration[])object).length - 1 || genericDeclaration != null) continue;
                        throw unsatisfiedDependencyException;
                    }
                } else {
                    if (classArray.length != objectArray.length) continue;
                    argumentsHolder = new ArgumentsHolder(objectArray);
                }
                int n3 = argumentsHolder.getTypeDifferenceWeight(classArray);
                if (n3 >= n) continue;
                genericDeclaration = genericDeclaration2;
                objectArray2 = argumentsHolder.arguments;
                n = n3;
            }
            if (genericDeclaration == null) {
                throw new BeanDefinitionStoreException("No matching factory method found: " + (rootBeanDefinition.getFactoryBeanName() != null ? "factory bean '" + rootBeanDefinition.getFactoryBeanName() + "'; " : "") + "factory method '" + rootBeanDefinition.getFactoryMethodName() + "'");
            }
            rootBeanDefinition.resolvedConstructorOrFactoryMethod = genericDeclaration;
        }
        object = this.instantiationStrategy.instantiate(rootBeanDefinition, string, this.beanFactory, object2, (Method)genericDeclaration, objectArray2);
        if (object == null) {
            return null;
        }
        beanWrapperImpl.setWrappedInstance(object);
        return beanWrapperImpl;
    }

    private int resolveConstructorArguments(String string, RootBeanDefinition rootBeanDefinition, BeanWrapper beanWrapper, ConstructorArgumentValues constructorArgumentValues, ConstructorArgumentValues constructorArgumentValues2) {
        Object object;
        Object object2;
        Object object3;
        BeanDefinitionValueResolver beanDefinitionValueResolver = new BeanDefinitionValueResolver(this.beanFactory, string, rootBeanDefinition, beanWrapper);
        int n = constructorArgumentValues.getArgumentCount();
        Iterator iterator = constructorArgumentValues.getIndexedArgumentValues().entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            int n2 = (Integer)object3.getKey();
            if (n2 < 0) {
                throw new BeanCreationException(rootBeanDefinition.getResourceDescription(), string, "Invalid constructor argument index: " + n2);
            }
            if (n2 > n) {
                n = n2 + 1;
            }
            if (((ConstructorArgumentValues.ValueHolder)(object2 = (ConstructorArgumentValues.ValueHolder)object3.getValue())).isConverted()) {
                constructorArgumentValues2.addIndexedArgumentValue(n2, (ConstructorArgumentValues.ValueHolder)object2);
                continue;
            }
            object = "constructor argument with index " + n2;
            Object object4 = beanDefinitionValueResolver.resolveValueIfNecessary((String)object, ((ConstructorArgumentValues.ValueHolder)object2).getValue());
            ConstructorArgumentValues.ValueHolder valueHolder = new ConstructorArgumentValues.ValueHolder(object4, ((ConstructorArgumentValues.ValueHolder)object2).getType());
            valueHolder.setSource(object2);
            constructorArgumentValues2.addIndexedArgumentValue(n2, valueHolder);
        }
        iterator = constructorArgumentValues.getGenericArgumentValues().iterator();
        while (iterator.hasNext()) {
            object3 = (ConstructorArgumentValues.ValueHolder)((Object)iterator.next());
            if (((ConstructorArgumentValues.ValueHolder)object3).isConverted()) {
                constructorArgumentValues2.addGenericArgumentValue((ConstructorArgumentValues.ValueHolder)object3);
                continue;
            }
            String string2 = "constructor argument";
            object2 = beanDefinitionValueResolver.resolveValueIfNecessary(string2, ((ConstructorArgumentValues.ValueHolder)object3).getValue());
            object = new ConstructorArgumentValues.ValueHolder(object2, ((ConstructorArgumentValues.ValueHolder)object3).getType());
            ((ConstructorArgumentValues.ValueHolder)object).setSource(object3);
            constructorArgumentValues2.addGenericArgumentValue((ConstructorArgumentValues.ValueHolder)object);
        }
        return n;
    }

    private ArgumentsHolder createArgumentArray(String string, RootBeanDefinition rootBeanDefinition, ConstructorArgumentValues constructorArgumentValues, BeanWrapper beanWrapper, Class[] classArray, Object object, boolean bl) throws UnsatisfiedDependencyException {
        String string2 = object instanceof Constructor ? "constructor" : "factory method";
        ArgumentsHolder argumentsHolder = new ArgumentsHolder(classArray.length);
        HashSet<ConstructorArgumentValues.ValueHolder> hashSet = new HashSet<ConstructorArgumentValues.ValueHolder>(classArray.length);
        boolean bl2 = false;
        for (int i = 0; i < classArray.length; ++i) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ConstructorArgumentValues.ValueHolder valueHolder = constructorArgumentValues.getArgumentValue(i, classArray[i], hashSet);
            if (valueHolder == null && !bl) {
                valueHolder = constructorArgumentValues.getGenericArgumentValue(null, hashSet);
            }
            if (valueHolder != null) {
                hashSet.add(valueHolder);
                argumentsHolder.rawArguments[i] = valueHolder.getValue();
                if (valueHolder.isConverted()) {
                    argumentsHolder.arguments[i] = object5 = valueHolder.getConvertedValue();
                    argumentsHolder.preparedArguments[i] = object5;
                    continue;
                }
                try {
                    object5 = valueHolder.getValue();
                    argumentsHolder.arguments[i] = object4 = beanWrapper.convertIfNecessary(object5, classArray[i], MethodParameter.forMethodOrConstructor((Object)object, (int)i));
                    object3 = (ConstructorArgumentValues.ValueHolder)valueHolder.getSource();
                    object2 = ((ConstructorArgumentValues.ValueHolder)object3).getValue();
                    if (object5 == object2 || object2 instanceof TypedStringValue) {
                        ((ConstructorArgumentValues.ValueHolder)object3).setConvertedValue(object4);
                        argumentsHolder.preparedArguments[i] = object4;
                        continue;
                    }
                    bl2 = true;
                    argumentsHolder.preparedArguments[i] = object2;
                    continue;
                }
                catch (TypeMismatchException typeMismatchException) {
                    throw new UnsatisfiedDependencyException(rootBeanDefinition.getResourceDescription(), string, i, classArray[i], "Could not convert " + string2 + " argument value of type [" + ObjectUtils.nullSafeClassName((Object)valueHolder.getValue()) + "] to required type [" + classArray[i].getName() + "]: " + typeMismatchException.getMessage());
                }
            }
            if (!bl) {
                throw new UnsatisfiedDependencyException(rootBeanDefinition.getResourceDescription(), string, i, classArray[i], "Ambiguous " + string2 + " argument types - " + "did you specify the correct bean references as " + string2 + " arguments?");
            }
            object5 = this.findAutowireCandidates(string, classArray[i]);
            if (object5.size() != 1) {
                throw new UnsatisfiedDependencyException(rootBeanDefinition.getResourceDescription(), string, i, classArray[i], "There are " + object5.size() + " beans of type [" + classArray[i].getName() + "] available for autowiring: " + object5.keySet() + ". There should have been exactly 1 to be able to autowire " + string2 + " of bean '" + string + "'.");
            }
            object4 = object5.entrySet().iterator().next();
            object3 = (String)object4.getKey();
            object2 = object4.getValue();
            argumentsHolder.rawArguments[i] = object2;
            argumentsHolder.arguments[i] = object2;
            if (rootBeanDefinition.isSingleton()) {
                this.beanFactory.registerDependentBean((String)object3, string);
            }
            if (!this.beanFactory.logger.isDebugEnabled()) continue;
            this.beanFactory.logger.debug((Object)("Autowiring by type from bean name '" + string + "' via " + string2 + " to bean named '" + (String)object3 + "'"));
        }
        if (bl2) {
            rootBeanDefinition.preparedConstructorArguments = argumentsHolder.preparedArguments;
        } else {
            rootBeanDefinition.resolvedConstructorArguments = argumentsHolder.arguments;
        }
        return argumentsHolder;
    }

    protected abstract Map findAutowireCandidates(String var1, Class var2) throws BeansException;

    private static class ArgumentsHolder {
        public Object[] rawArguments;
        public Object[] arguments;
        public Object[] preparedArguments;

        public ArgumentsHolder(int n) {
            this.rawArguments = new Object[n];
            this.arguments = new Object[n];
            this.preparedArguments = new Object[n];
        }

        public ArgumentsHolder(Object[] objectArray) {
            this.rawArguments = objectArray;
            this.arguments = objectArray;
            this.preparedArguments = objectArray;
        }

        public int getTypeDifferenceWeight(Class[] classArray) {
            int n = AutowireUtils.getTypeDifferenceWeight(classArray, this.arguments);
            int n2 = AutowireUtils.getTypeDifferenceWeight(classArray, this.rawArguments) - 1024;
            return n2 < n ? n2 : n;
        }
    }
}

