/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.softeutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ReadTempDatFile {
    protected static Logger logger = Logger.getLogger(ReadTempDatFile.class);
    private static final String FILE_NAME = "config/temp.dat";
    private static Properties _properties;
    private static InputStream in;

    static {
        in = null;
        try {
            try {
                String strfile = String.valueOf(System.getProperty("user.dir")) + "/" + FILE_NAME;
                File dir = new File(strfile.substring(0, strfile.lastIndexOf("/")));
                File file = new File(strfile);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                in = new FileInputStream(file);
                _properties = new Properties();
                _properties.load(in);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getString(String key) throws Exception {
        if (_properties != null) {
            return _properties.getProperty(key);
        }
        return "";
    }

    public static int getInteger(String key) throws Exception {
        int value = Integer.parseInt(_properties.getProperty(key));
        return value;
    }

    public static float getFloat(String key) throws Exception {
        Float value = new Float(_properties.getProperty(key));
        return value.floatValue();
    }

    public static void updateProperty(String key, String value) throws Exception {
        _properties.setProperty(key, value);
        String strfile = String.valueOf(System.getProperty("user.dir")) + "/" + FILE_NAME;
        FileOutputStream fileOut = new FileOutputStream(strfile);
        try {
            _properties.store(fileOut, "last update time" + new Date().toString());
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
            }
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(ReadTempDatFile.getString("version"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

