/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xdg;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.DesktopEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.xdg.Associations;
import com.sun.deploy.xdg.BaseDir;
import com.sun.javaws.UnixInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.javaws.xdg.Menu;
import com.sun.javaws.xdg.MenuDatabase;
import com.sun.javaws.xdg.UserDirs;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class XDGInstallHandler
extends UnixInstallHandler {
    private static final String ACTION_COMMAND = "command";

    public boolean isLocalInstallSupported() {
        return true;
    }

    public boolean isAssociationSupported() {
        return true;
    }

    protected boolean desktopEntryExists(String string) {
        File file = this.getDesktopEntryFile(string);
        return file != null ? file.exists() : false;
    }

    protected String writeDesktopEntry(DesktopEntry desktopEntry, String string, Association association, int n) {
        String string2;
        File file = null;
        if (association != null) {
            file = Associations.getDesktopEntryFile((Association)association, (int)n);
        } else {
            UserDirs userDirs = UserDirs.getInstance();
            string2 = userDirs.getDesktopDir();
            file = new File(string2, string);
        }
        boolean bl = this.writeDesktopFile(desktopEntry, file, true);
        string2 = bl ? file.getAbsolutePath() : null;
        return "desktop:" + string;
    }

    private boolean writeDesktopFile(DesktopEntry desktopEntry, File file, boolean bl) {
        boolean bl2;
        Trace.println((String)("Writing desktop file to: " + file), (TraceLevel)TraceLevel.UI);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(desktopEntry.toString());
            bufferedWriter.close();
            if (bl && Config.isJavaVersionAtLeast16()) {
                file.setExecutable(true);
            }
            bl2 = true;
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            bl2 = false;
        }
        return bl2;
    }

    protected String writeMenuEntry(DesktopEntry desktopEntry, String string, String string2) {
        String string3;
        String string4 = this.getAppsDir();
        new File(string4).mkdirs();
        File file = new File(string4, string2);
        boolean bl = this.writeDesktopFile(desktopEntry, file, false);
        if (bl) {
            MenuDatabase menuDatabase = MenuDatabase.getInstance();
            Menu menu = menuDatabase.addMenu(string);
            if (string == null) {
                string = "";
            }
            menu.addEntry(string2);
            try {
                menuDatabase.save();
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
                string3 = null;
            }
            string3 = "menu:" + string + ":" + string2;
        } else {
            string3 = null;
        }
        return string3;
    }

    protected File getDesktopEntryFile(String string) {
        File file = null;
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if (string2.equals("desktop")) {
            String string3 = string.substring(n + 1, string.length());
            UserDirs userDirs = UserDirs.getInstance();
            file = new File(userDirs.getDesktopDir(), string3);
        } else if (string2.equals("menu")) {
            String string4 = string.substring(n + 1, string.length());
            if ((n = string4.indexOf(58)) == -1) {
                return null;
            }
            String string5 = string4.substring(n + 1, string4.length());
            file = new File(this.getAppsDir(), string5);
        }
        return file;
    }

    protected boolean removeDesktopPath(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(0, n);
        boolean bl = false;
        if (string2.equals("desktop")) {
            File file = this.getDesktopEntryFile(string);
            if (file != null && file.delete()) {
                bl = true;
            }
        } else if (string2.equals("menu")) {
            String string3 = string.substring(n + 1, string.length());
            if ((n = string3.indexOf(58)) == -1) {
                return false;
            }
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1, string3.length());
            String string6 = this.getAppsDir();
            File file = new File(string6, string5);
            file.delete();
            MenuDatabase menuDatabase = MenuDatabase.getInstance();
            Menu menu = menuDatabase.getMenu(string4);
            if (menu != null) {
                menu.removeEntry(string5);
            }
            try {
                menuDatabase.save();
                bl = true;
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected boolean removeDirectory(String string) {
        return true;
    }

    private String getAppsDir() {
        BaseDir baseDir = BaseDir.getInstance();
        String string = baseDir.getUserDataDir() + File.separatorChar + "applications";
        return string;
    }

    protected String getMenuEntryDirPath(LaunchDesc launchDesc, boolean bl) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String string = null;
        if (shortcutDesc != null) {
            string = this.dirFilter(shortcutDesc.getSubmenu());
        }
        return string;
    }

    public String getAssociationPrintCommand(String string) {
        return ACTION_COMMAND;
    }

    public String getAssociationOpenCommand(String string) {
        return ACTION_COMMAND;
    }

    public void registerAssociationInternal(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        int n;
        AssociationService associationService = new AssociationService(localApplicationProperties);
        int n2 = n = Environment.isSystemCacheMode() ? 2 : 1;
        if (!this.createShortcuts(launchDesc, localApplicationProperties, new boolean[]{false, false}, association, n)) {
            throw new RegisterFailedException();
        }
        super.registerAssociationInternal(launchDesc, localApplicationProperties, association);
    }

    public void unregisterAssociationInternal(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        int n = Environment.isSystemCacheMode() ? 2 : 1;
        File file = Associations.getDesktopEntryFile((Association)association, (int)n);
        if (!file.exists()) {
            Trace.print((String)("desktop entry file doesn't exist, path == " + file.getAbsolutePath()), (TraceLevel)TraceLevel.TEMP);
        } else {
            file.delete();
        }
        super.unregisterAssociationInternal(launchDesc, localApplicationProperties, association);
    }
}

