/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public abstract class AbstractBeanDefinitionReader
implements BeanDefinitionReader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final BeanDefinitionRegistry beanFactory;
    private BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();
    private ResourceLoader resourceLoader;
    private ClassLoader beanClassLoader;

    protected AbstractBeanDefinitionReader(BeanDefinitionRegistry beanDefinitionRegistry) {
        Assert.notNull((Object)beanDefinitionRegistry, (String)"Bean factory must not be null");
        this.beanFactory = beanDefinitionRegistry;
        this.resourceLoader = this.beanFactory instanceof ResourceLoader ? (ResourceLoader)this.beanFactory : new PathMatchingResourcePatternResolver();
    }

    public BeanDefinitionRegistry getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator != null ? beanNameGenerator : new DefaultBeanNameGenerator();
    }

    public BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public int loadBeanDefinitions(Resource[] resourceArray) throws BeanDefinitionStoreException {
        Assert.notNull((Object)resourceArray, (String)"Resource array must not be null");
        int n = 0;
        for (int i = 0; i < resourceArray.length; ++i) {
            n += this.loadBeanDefinitions(resourceArray[i]);
        }
        return n;
    }

    public int loadBeanDefinitions(String string) throws BeanDefinitionStoreException {
        ResourceLoader resourceLoader = this.getResourceLoader();
        if (resourceLoader == null) {
            throw new BeanDefinitionStoreException("Cannot import bean definitions from location [" + string + "]: no ResourceLoader available");
        }
        if (resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resourceArray = ((ResourcePatternResolver)resourceLoader).getResources(string);
                int n = this.loadBeanDefinitions(resourceArray);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loaded " + n + " bean definitions from location pattern [" + string + "]"));
                }
                return n;
            }
            catch (IOException iOException) {
                throw new BeanDefinitionStoreException("Could not resolve bean definition resource pattern [" + string + "]", iOException);
            }
        }
        Resource resource = resourceLoader.getResource(string);
        int n = this.loadBeanDefinitions(resource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded " + n + " bean definitions from location [" + string + "]"));
        }
        return n;
    }

    public int loadBeanDefinitions(String[] stringArray) throws BeanDefinitionStoreException {
        Assert.notNull((Object)stringArray, (String)"Location array must not be null");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += this.loadBeanDefinitions(stringArray[i]);
        }
        return n;
    }
}

