/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.EnergyBean;
import cn.com.voltronic.solar.dbtools.DBManager;
import cn.com.voltronic.solar.util.DateUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class EnergyDao
extends BaseDao {
    private static final String QUERY_YEAR = " SELECT * FROM yenergy WHERE serialno=? and iyear BETWEEN ? AND ? order by iyear";
    private static final String QUERY_MONTH = " SELECT * FROM menergy WHERE serialno=? and yearmonth BETWEEN ? and ? order by yearmonth ";
    private static final String QUERY_DAY = " SELECT * FROM denergy WHERE serialno=? and trandate BETWEEN ? and ? order by trandate ";
    private static final String QUERY_HOUR = " SELECT * FROM henergy WHERE serialno=? and trandate BETWEEN ? and ? order by trandate,ihour ";
    private static final String QUERY_HOUR_SUM = " SELECT sum(energy) as energy FROM henergy WHERE serialno=? and trandate =? ";
    private static final String INSERT_YEAR = " INSERT INTO yenergy(prodid,serialno,iyear,energy,isComplete) VALUES(?,?,?,?,?) ";
    private static final String INSERT_MONTH = " INSERT INTO menergy(prodid,serialno,yearmonth,energy,isComplete) VALUES(?,?,?,?,?) ";
    private static final String INSERT_DAY = " INSERT INTO denergy(prodid,serialno,trandate,energy,isComplete) VALUES(?,?,?,?,?) ";
    private static final String INSERT_HOUR = " INSERT INTO henergy(prodid,serialno,trandate,ihour, energy,isComplete) VALUES(?,?,?,?,?,?) ";
    private static final String DELETE_HOUR = " delete from henergy where serialno=? and trandate=? and ihour=? ";
    private static final String DELETE_DAY = " DELETE FROM denergy where serialno=? and trandate=? ";
    private static final String DELETE_MONTH = " DELETE FROM menergy where serialno=? and yearmonth=? ";
    private static final String DELETE_YEAR = " DELETE FROM yenergy where serialno=? and iyear=? ";
    private static final String DELETE_YEAR_ALL = "delete from yenergy";
    private static final String DELETE_MONTH_ALL = "delete from menergy";
    private static final String DELETE_DAY_ALL = "delete from denergy";
    private static final String DELETE_HOUR_ALL = "delete from henergy";
    public static final String QUERY_PRODID_Y = " SELECT distinct prodid FROM yenergy";
    public static final String QUERY_PRODID_M = " SELECT distinct prodid FROM menergy";
    public static final String QUERY_PRODID_D = " SELECT distinct prodid FROM denergy";
    public static final String QUERY_PRODID_H = " SELECT distinct prodid FROM henergy";
    public static final String QUERY_SERIALNO_Y = " SELECT distinct serialno FROM yenergy";
    public static final String QUERY_SERIALNO_M = " SELECT distinct serialno FROM menergy";
    public static final String QUERY_SERIALNO_D = " SELECT distinct serialno FROM denergy";
    public static final String QUERY_SERIALNO_H = " SELECT distinct serialno FROM henergy";
    public static final String INSERT_ENERGYBEGINDATE = " INSERT INTO energybegindate(prodid,serialno,begindate) VALUES(?,?,?) ";
    public static final String QUERY_ENERGYBEGINDATE = " SELECT * FROM energybegindate where serialno=? ";
    public static final String UPDATE_ENERGYBEGINDATE = " UPDATE energybegindate SET begindate=? WHERE serialno=? ";
    private static final String DELETE_MONTHS = " DELETE FROM menergy where serialno=? and yearmonth between ? and ? ";
    private static final String QUERY_MONTH_ENERGY = "select sum(energy) as energy from denergy where serialno=? and trandate  between ? and ?";
    private static final String QUERY_YEAR_ENERGY = " select sum(energy) as energy from menergy where serialno=? and yearmonth between ? and ? ";

    public double querySummaryHour(String serial, Calendar curdate) {
        double quantity;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            quantity = 0.0;
            try {
                try {
                    ps = conn.prepareStatement(QUERY_HOUR_SUM);
                    ps.setString(1, serial);
                    ps.setDate(2, this.calendartoSqlDate(curdate));
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        quantity = rs.getDouble(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return quantity;
    }

    public void transactEnergyFromChangetime(String serialno, Calendar newtime) {
        block5: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            try {
                try {
                    Calendar trandate = DateUtils.getShortdate(newtime);
                    ps = conn.prepareStatement(" update henergy set isComplete=0 where serialno=? and (trandate > ? or (trandate = ? and ihour >= ?))");
                    ps.setString(1, serialno);
                    ps.setDate(2, this.calendartoSqlDate(trandate));
                    ps.setDate(3, this.calendartoSqlDate(trandate));
                    ps.setInt(4, newtime.get(11));
                    ps.executeUpdate();
                    ps = conn.prepareStatement(" update denergy set isComplete=0 where serialno=? and trandate >= ? ");
                    ps.setString(1, serialno);
                    ps.setDate(2, this.calendartoSqlDate(trandate));
                    ps.executeUpdate();
                    ps = conn.prepareStatement(" update menergy set isComplete=0 where serialno=? and yearmonth >= ?");
                    ps.setString(1, serialno);
                    ps.setString(2, DateUtils.getFormatDate(trandate.getTime(), "yyyyMM"));
                    ps.executeUpdate();
                    ps = conn.prepareStatement(" update yenergy set isComplete=0 where serialno=? and iyear >= ?");
                    ps.setString(1, serialno);
                    ps.setInt(2, trandate.get(1));
                    ps.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(ps);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
            this.close(ps);
        }
    }

    public List<String> querySerialno(String mark) {
        ArrayList<String> list;
        block7: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            list = new ArrayList<String>();
            try {
                try {
                    if (mark == null) {
                        mark = "";
                    }
                    ps = mark.equals("year") ? conn.prepareStatement(QUERY_SERIALNO_Y) : (mark.equals("month") ? conn.prepareStatement(QUERY_SERIALNO_M) : (mark.equals("day") ? conn.prepareStatement(QUERY_SERIALNO_D) : (mark.equals("hour") ? conn.prepareStatement(QUERY_SERIALNO_H) : conn.prepareStatement(QUERY_SERIALNO_Y))));
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        list.add(rs.getString("serialno"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    public List<String> queryProdid(String mark) {
        ArrayList<String> list;
        block7: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            list = new ArrayList<String>();
            try {
                try {
                    if (mark == null) {
                        mark = "";
                    }
                    ps = mark.equals("year") ? conn.prepareStatement(QUERY_PRODID_Y) : (mark.equals("month") ? conn.prepareStatement(QUERY_PRODID_M) : (mark.equals("day") ? conn.prepareStatement(QUERY_PRODID_D) : (mark.equals("hour") ? conn.prepareStatement(QUERY_PRODID_H) : conn.prepareStatement(QUERY_PRODID_Y))));
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        list.add(rs.getString("prodid"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    private Date calendartoSqlDate(Calendar date) {
        Date sqlDate = new Date(date.getTime().getTime());
        return sqlDate;
    }

    private Calendar sqlDatetoCalendar(Date jdate) {
        Calendar cdate = Calendar.getInstance();
        cdate.setTime(new Date(jdate.getTime()));
        return cdate;
    }

    public List<EnergyBean> queryYear(String serial, int startyear, int endyear) {
        ArrayList<EnergyBean> list;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            list = new ArrayList<EnergyBean>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_YEAR);
                    ps.setString(1, serial);
                    ps.setInt(2, startyear);
                    ps.setInt(3, endyear);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        EnergyBean bean = new EnergyBean();
                        bean.setQueryperiod(0);
                        bean.setYear(rs.getInt("iyear"));
                        bean.setQuantity(rs.getDouble("energy"));
                        bean.setComplete(rs.getBoolean("isComplete"));
                        list.add(bean);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    public List<EnergyBean> queryMonth(String serial, String startyearmonth, String endyearmonth) {
        ArrayList<EnergyBean> list;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            list = new ArrayList<EnergyBean>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_MONTH);
                    ps.setString(1, serial);
                    ps.setString(2, startyearmonth);
                    ps.setString(3, endyearmonth);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        EnergyBean bean = new EnergyBean();
                        bean.setQueryperiod(1);
                        bean.setYearmonth(rs.getString("yearmonth"));
                        bean.setQuantity(rs.getDouble("energy"));
                        bean.setComplete(rs.getBoolean("isComplete"));
                        list.add(bean);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    public List<EnergyBean> queryDay(String serial, Calendar startdate, Calendar enddate) {
        ArrayList<EnergyBean> list;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            list = new ArrayList<EnergyBean>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_DAY);
                    ps.setString(1, serial);
                    ps.setDate(2, this.calendartoSqlDate(startdate));
                    ps.setDate(3, this.calendartoSqlDate(enddate));
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        EnergyBean bean = new EnergyBean();
                        bean.setQueryperiod(2);
                        bean.setTrandate(this.sqlDatetoCalendar(rs.getDate("trandate")));
                        bean.setQuantity(rs.getDouble("energy"));
                        bean.setComplete(rs.getBoolean("isComplete"));
                        list.add(bean);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    public List<EnergyBean> queryHour(String serial, Calendar startdate, int starthour, Calendar enddate, int endhour) {
        ArrayList<EnergyBean> list;
        block9: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            list = new ArrayList<EnergyBean>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_HOUR);
                    ps.setString(1, serial);
                    ps.setDate(2, this.calendartoSqlDate(startdate));
                    ps.setDate(3, this.calendartoSqlDate(enddate));
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        Calendar cal = this.sqlDatetoCalendar(rs.getDate("trandate"));
                        boolean append = true;
                        if (cal.compareTo(startdate) == 0 && rs.getInt("ihour") < starthour) {
                            append = false;
                        } else if (cal.compareTo(enddate) == 0 && rs.getInt("ihour") > endhour) {
                            append = false;
                        }
                        if (!append) continue;
                        EnergyBean bean = new EnergyBean();
                        bean.setQueryperiod(3);
                        bean.setTrandate(cal);
                        bean.setHour(rs.getInt("ihour"));
                        bean.setQuantity(rs.getDouble("energy"));
                        bean.setComplete(rs.getBoolean("isComplete"));
                        list.add(bean);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    public boolean insertYear(String prodid, String serial, EnergyBean bean) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                if (this.deleteYear(prodid, serial, bean.getYear()) && bean.getQuantity() > 0.0) {
                    ps = conn.prepareStatement(INSERT_YEAR);
                    ps.setString(1, prodid);
                    ps.setString(2, serial);
                    ps.setInt(3, bean.getYear());
                    ps.setDouble(4, bean.getQuantity());
                    ps.setBoolean(5, bean.isComplete());
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteYear(String prodid, String serial, int year) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE_YEAR);
                ps.setString(1, serial);
                ps.setInt(2, year);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteAll() {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE_YEAR_ALL);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
                if ((ps = conn.prepareStatement(DELETE_MONTH_ALL)).executeUpdate() < 0) {
                    result = false;
                }
                if ((ps = conn.prepareStatement(DELETE_DAY_ALL)).executeUpdate() < 0) {
                    result = false;
                }
                if ((ps = conn.prepareStatement(DELETE_HOUR_ALL)).executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteYearPriod(String serial, int startyear, int endyear) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM yenergy where serialno=? and iyear BETWEEN ? and ? ");
                ps.setString(1, serial);
                ps.setInt(2, startyear);
                ps.setInt(3, endyear);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean insertMonth(String prodid, String serial, EnergyBean bean) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                if (this.deleteMonth(prodid, serial, bean.getYearmonth()) && bean.getQuantity() > 0.0) {
                    ps = conn.prepareStatement(INSERT_MONTH);
                    ps.setString(1, prodid);
                    ps.setString(2, serial);
                    ps.setString(3, bean.getYearmonth());
                    ps.setDouble(4, bean.getQuantity());
                    ps.setBoolean(5, bean.isComplete());
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteMonth(String prodid, String serial, String yearmonth) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE_MONTH);
                ps.setString(1, serial);
                ps.setString(2, yearmonth);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteMonthPriod(String serial, String startyearmonth, String endyearmonth) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM menergy where serialno=? and yearmonth BETWEEN ? and ?");
                ps.setString(1, serial);
                ps.setString(2, startyearmonth);
                ps.setString(3, endyearmonth);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean insertDay(String prodid, String serial, EnergyBean bean) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                if (this.deleteDay(prodid, serial, bean)) {
                    ps = conn.prepareStatement(INSERT_DAY);
                    ps.setString(1, prodid);
                    ps.setString(2, serial);
                    ps.setDate(3, this.calendartoSqlDate(bean.getTrandate()));
                    ps.setDouble(4, bean.getQuantity());
                    ps.setBoolean(5, bean.isComplete());
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteDay(String prodid, String serial, EnergyBean bean) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE_DAY);
                ps.setString(1, serial);
                ps.setDate(2, this.calendartoSqlDate(bean.getTrandate()));
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteDayPriod(String serial, Calendar startDate, Calendar endDate) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM denergy where serialno=? and trandate BETWEEN ? and ?");
                ps.setString(1, serial);
                ps.setDate(2, this.calendartoSqlDate(startDate));
                ps.setDate(3, this.calendartoSqlDate(endDate));
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean insertHour(String prodid, String serial, EnergyBean bean) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                if (this.deleteHour(prodid, serial, bean)) {
                    ps = conn.prepareStatement(INSERT_HOUR);
                    ps.setString(1, prodid);
                    ps.setString(2, serial);
                    ps.setDate(3, this.calendartoSqlDate(bean.getTrandate()));
                    ps.setInt(4, bean.getHour());
                    ps.setDouble(5, bean.getQuantity());
                    ps.setBoolean(6, bean.isComplete());
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteHour(String prodid, String serial, EnergyBean bean) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        if (conn == null) return false;
        try {
            try {
                ps = conn.prepareStatement(DELETE_HOUR);
                ps.setString(1, serial);
                ps.setDate(2, this.calendartoSqlDate(bean.getTrandate()));
                ps.setInt(3, bean.getHour());
                if (ps.executeUpdate() >= 0) return result;
                result = false;
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                this.close(ps);
            }
            return result;
        }
        finally {
            this.close(ps);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteHourPriod(String serial, Calendar date, int starthour, int endhour) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        if (conn == null) return false;
        try {
            try {
                ps = conn.prepareStatement("delete from henergy where serialno=? and trandate=? and ihour BETWEEN ? and ? ");
                ps.setString(1, serial);
                ps.setDate(2, this.calendartoSqlDate(date));
                ps.setInt(3, starthour);
                ps.setInt(4, endhour);
                if (ps.executeUpdate() >= 0) return result;
                result = false;
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                this.close(ps);
            }
            return result;
        }
        finally {
            this.close(ps);
        }
    }

    public boolean deleteDayMergeHour(String serial, Calendar trandate) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM henergy where serialno=? and trandate=? ");
                ps.setString(1, serial);
                ps.setDate(2, this.calendartoSqlDate(trandate));
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteMonthMergeHour(String serial, Calendar trandate) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM henergy where serialno=? and year(trandate)=? and month(trandate)=?");
                ps.setString(1, serial);
                ps.setInt(2, trandate.get(1));
                ps.setInt(3, trandate.get(2) + 1);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteMonthMergeDay(String serial, Calendar trandate) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM denergy where serialno=? and year(trandate)=? and month(trandate)=?");
                ps.setString(1, serial);
                ps.setInt(2, trandate.get(1));
                ps.setInt(3, trandate.get(2) + 1);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean updateDay(String serialno, Calendar trandate) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" update denergy set isComplete=0 where serialno=? and trandate = ? ");
                ps.setString(1, serialno);
                ps.setDate(2, this.calendartoSqlDate(DateUtils.getShortdate(trandate)));
                if (ps.executeUpdate() >= 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean updateMonth(String serialno, Calendar trandate) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" update menergy set isComplete=0 where serialno=? and yearmonth = ? ");
                ps.setString(1, serialno);
                ps.setString(2, DateUtils.getFormatDate(trandate.getTime(), "yyyyMM"));
                if (ps.executeUpdate() >= 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean updateYear(String serialno, Calendar trandate) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" update yenergy set isComplete=0 where serialno=? and iyear = ? ");
                ps.setString(1, serialno);
                ps.setInt(2, trandate.get(1));
                if (ps.executeUpdate() >= 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean insertEnergyBeginDate(String prodid, String serial, Calendar date) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_ENERGYBEGINDATE);
                ps.setString(1, prodid);
                ps.setString(2, serial);
                ps.setDate(3, this.calendartoSqlDate(date));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public Calendar queryEnergyBeginDate(String serialno) {
        Calendar result;
        block6: {
            result = null;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(QUERY_ENERGYBEGINDATE);
                    ps.setString(1, serialno);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = this.sqlDatetoCalendar(rs.getDate("begindate"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean updateEnergyBeginDate(String prodid, String serialno, Calendar date) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(UPDATE_ENERGYBEGINDATE);
                ps.setString(1, serialno);
                ps.setDate(2, this.calendartoSqlDate(date));
                ps.executeUpdate();
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public static void main(String[] args) {
        EnergyDao dao = new EnergyDao();
        boolean re = dao.deleteAll();
        System.out.println("result:" + re);
    }

    public boolean deleteMonths(String serial, String startyearmonth, String endyearmonth) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE_MONTHS);
                ps.setString(1, serial);
                ps.setString(2, startyearmonth);
                ps.setString(3, endyearmonth);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public double queryMonthEnergy(String serial, Calendar startdate, Calendar enddate) {
        double quantity;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            quantity = 0.0;
            try {
                try {
                    ps = conn.prepareStatement(QUERY_MONTH_ENERGY);
                    ps.setString(1, serial);
                    ps.setDate(2, this.calendartoSqlDate(startdate));
                    ps.setDate(3, this.calendartoSqlDate(enddate));
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        quantity = rs.getDouble(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return quantity;
    }

    public boolean deleteYears(String serial, int startyear) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE_YEAR);
                ps.setString(1, serial);
                ps.setInt(2, startyear);
                if (ps.executeUpdate() < 0) {
                    result = false;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public double queryYearEnergy(String serial, String startyearmonth, String endyearmonth) {
        double quantity;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            quantity = 0.0;
            try {
                try {
                    ps = conn.prepareStatement(QUERY_YEAR_ENERGY);
                    ps.setString(1, serial);
                    ps.setString(2, startyearmonth);
                    ps.setString(3, endyearmonth);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        quantity = rs.getDouble(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return quantity;
    }
}

