/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.txw2.TXW;
import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.txw2.output.StaxSerializer;
import com.sun.xml.internal.ws.policy.PolicyConstants;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyModelMarshaller;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.XmlToken;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;

public final class XmlPolicyModelMarshaller
extends PolicyModelMarshaller {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(XmlPolicyModelMarshaller.class);
    private final boolean marshallInvisible;

    XmlPolicyModelMarshaller(boolean bl) {
        this.marshallInvisible = bl;
    }

    @Override
    public void marshal(PolicySourceModel policySourceModel, Object object) throws PolicyException {
        if (object instanceof StaxSerializer) {
            this.marshal(policySourceModel, (StaxSerializer)object);
        } else if (object instanceof TypedXmlWriter) {
            this.marshal(policySourceModel, (TypedXmlWriter)object);
        } else if (object instanceof XMLStreamWriter) {
            this.marshal(policySourceModel, (XMLStreamWriter)object);
        } else {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0022_STORAGE_TYPE_NOT_SUPPORTED(object.getClass().getName())));
        }
    }

    @Override
    public void marshal(Collection<PolicySourceModel> collection, Object object) throws PolicyException {
        for (PolicySourceModel policySourceModel : collection) {
            this.marshal(policySourceModel, object);
        }
    }

    private void marshal(PolicySourceModel policySourceModel, StaxSerializer staxSerializer) throws PolicyException {
        TypedXmlWriter typedXmlWriter = TXW.create(policySourceModel.getNamespaceVersion().asQName(XmlToken.Policy), TypedXmlWriter.class, staxSerializer);
        this.marshalDefaultPrefixes(policySourceModel, typedXmlWriter);
        XmlPolicyModelMarshaller.marshalPolicyAttributes(policySourceModel, typedXmlWriter);
        this.marshal(policySourceModel.getNamespaceVersion(), policySourceModel.getRootNode(), typedXmlWriter);
        typedXmlWriter.commit();
    }

    private void marshal(PolicySourceModel policySourceModel, TypedXmlWriter typedXmlWriter) throws PolicyException {
        TypedXmlWriter typedXmlWriter2 = typedXmlWriter._element(policySourceModel.getNamespaceVersion().asQName(XmlToken.Policy), TypedXmlWriter.class);
        this.marshalDefaultPrefixes(policySourceModel, typedXmlWriter2);
        XmlPolicyModelMarshaller.marshalPolicyAttributes(policySourceModel, typedXmlWriter2);
        this.marshal(policySourceModel.getNamespaceVersion(), policySourceModel.getRootNode(), typedXmlWriter2);
    }

    private void marshal(PolicySourceModel policySourceModel, XMLStreamWriter xMLStreamWriter) throws PolicyException {
        StaxSerializer staxSerializer = new StaxSerializer(xMLStreamWriter);
        TypedXmlWriter typedXmlWriter = TXW.create(policySourceModel.getNamespaceVersion().asQName(XmlToken.Policy), TypedXmlWriter.class, staxSerializer);
        this.marshalDefaultPrefixes(policySourceModel, typedXmlWriter);
        XmlPolicyModelMarshaller.marshalPolicyAttributes(policySourceModel, typedXmlWriter);
        this.marshal(policySourceModel.getNamespaceVersion(), policySourceModel.getRootNode(), typedXmlWriter);
        typedXmlWriter.commit();
        staxSerializer.flush();
    }

    private static void marshalPolicyAttributes(PolicySourceModel policySourceModel, TypedXmlWriter typedXmlWriter) {
        String string;
        String string2 = policySourceModel.getPolicyId();
        if (string2 != null) {
            typedXmlWriter._attribute(PolicyConstants.WSU_ID, (Object)string2);
        }
        if ((string = policySourceModel.getPolicyName()) != null) {
            typedXmlWriter._attribute(policySourceModel.getNamespaceVersion().asQName(XmlToken.Name), (Object)string);
        }
    }

    private void marshal(NamespaceVersion namespaceVersion, ModelNode modelNode, TypedXmlWriter typedXmlWriter) {
        for (ModelNode modelNode2 : modelNode) {
            AssertionData assertionData = modelNode2.getNodeData();
            if (!this.marshallInvisible && assertionData != null && assertionData.isPrivateAttributeSet()) continue;
            TypedXmlWriter typedXmlWriter2 = null;
            if (assertionData == null) {
                typedXmlWriter2 = typedXmlWriter._element(namespaceVersion.asQName(modelNode2.getType().getXmlToken()), TypedXmlWriter.class);
            } else {
                typedXmlWriter2 = typedXmlWriter._element(assertionData.getName(), TypedXmlWriter.class);
                String string = assertionData.getValue();
                if (string != null) {
                    typedXmlWriter2._pcdata(string);
                }
                if (assertionData.isOptionalAttributeSet()) {
                    typedXmlWriter2._attribute(namespaceVersion.asQName(XmlToken.Optional), (Object)Boolean.TRUE);
                }
                if (assertionData.isIgnorableAttributeSet()) {
                    typedXmlWriter2._attribute(namespaceVersion.asQName(XmlToken.Ignorable), (Object)Boolean.TRUE);
                }
                for (Map.Entry<QName, String> entry : assertionData.getAttributesSet()) {
                    typedXmlWriter2._attribute(entry.getKey(), (Object)entry.getValue());
                }
            }
            this.marshal(namespaceVersion, modelNode2, typedXmlWriter2);
        }
    }

    private void marshalDefaultPrefixes(PolicySourceModel policySourceModel, TypedXmlWriter typedXmlWriter) throws PolicyException {
        Map<String, String> map = policySourceModel.getNamespaceToPrefixMapping();
        if (!this.marshallInvisible && map.containsKey("http://java.sun.com/xml/ns/wsit/policy")) {
            map.remove("http://java.sun.com/xml/ns/wsit/policy");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            typedXmlWriter._namespace(entry.getKey(), entry.getValue());
        }
    }
}

