/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.tool.communicate;

import cn.com.voltronic.tool.communicate.CommunicateHandler;
import cn.com.voltronic.tool.exception.CommunicateException;
import cn.com.voltronic.tool.util.StringUtils;
import java.io.IOException;
import usb.IUSBComm;

public class USBHandler
extends CommunicateHandler {
    private String usbId;
    private IUSBComm usbComm;

    public USBHandler(IUSBComm usbComm, String usbId) {
        this.usbComm = usbComm;
        this.usbId = usbId;
    }

    @Override
    public String excuteSimpleCommand(String command, boolean isCRC) throws IOException {
        if (isCRC) {
            this.usbComm.setUseCRC(1);
        } else {
            this.usbComm.setUseCRC(0);
        }
        String returnValue = "";
        int time = 0;
        while (StringUtils.isEmpty(returnValue) && time < 3) {
            returnValue = this.sendCommand(this.usbId, String.valueOf(command) + "\r");
            ++time;
        }
        if (StringUtils.isEmpty(returnValue)) {
            throw new IOException();
        }
        return returnValue;
    }

    @Override
    public synchronized String excuteCommand(String command, boolean isResponse, boolean isCRC) throws CommunicateException {
        if (isCRC) {
            this.usbComm.setUseCRC(1);
        } else {
            this.usbComm.setUseCRC(0);
        }
        String returnValue = this.sendCommand(this.usbId, String.valueOf(command) + "\r");
        if (isResponse) {
            int time = 0;
            while (StringUtils.isEmpty(returnValue) && time < 2) {
                returnValue = this.sendCommand(this.usbId, String.valueOf(command) + "\r");
                ++time;
            }
            if (StringUtils.isEmpty(returnValue)) {
                throw new CommunicateException("Communication exception");
            }
        }
        return returnValue;
    }

    public String sendCommand(String usbID, String command) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = this.usbComm.sendCommand(usbID, command);
        int i = 0;
        while (i < bytes.length - 1) {
            byte ch = bytes[i];
            sb.append((char)ch);
            ++i;
        }
        String xx = sb.toString();
        return xx;
    }

    @Override
    public void close() {
        if (this.usbComm != null) {
            try {
                this.usbComm.closeUSBPort(this.usbId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDeviceName() {
        return "USB" + this.usbId;
    }
}

