/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.txw2.output;

import com.sun.xml.internal.txw2.output.DelegatingXMLStreamWriter;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IndentingXMLStreamWriter
extends DelegatingXMLStreamWriter {
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack<Object> stateStack = new Stack();
    private String indentStep = "  ";
    private int depth = 0;

    public IndentingXMLStreamWriter(XMLStreamWriter xMLStreamWriter) {
        super(xMLStreamWriter);
    }

    public int getIndentStep() {
        return this.indentStep.length();
    }

    public void setIndentStep(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            stringBuilder.append(' ');
            --n;
        }
        this.setIndentStep(stringBuilder.toString());
    }

    public void setIndentStep(String string) {
        this.indentStep = string;
    }

    private void onStartElement() throws XMLStreamException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            super.writeCharacters("\n");
        }
        this.doIndent();
        ++this.depth;
    }

    private void onEndElement() throws XMLStreamException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            super.writeCharacters("\n");
            this.doIndent();
        }
        this.state = this.stateStack.pop();
    }

    private void onEmptyElement() throws XMLStreamException {
        this.state = SEEN_ELEMENT;
        if (this.depth > 0) {
            super.writeCharacters("\n");
        }
        this.doIndent();
    }

    private void doIndent() throws XMLStreamException {
        if (this.depth > 0) {
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters(this.indentStep);
            }
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        super.writeStartDocument();
        super.writeCharacters("\n");
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        super.writeStartDocument(string);
        super.writeCharacters("\n");
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        super.writeStartDocument(string, string2);
        super.writeCharacters("\n");
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(string);
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(string, string2);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(string, string2, string3);
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(string, string2);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(string, string2, string3);
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(string);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        super.writeEndElement();
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.state = SEEN_DATA;
        super.writeCharacters(string);
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.state = SEEN_DATA;
        super.writeCharacters(cArray, n, n2);
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.state = SEEN_DATA;
        super.writeCData(string);
    }
}

