/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.config.management.policy;

import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapKey;
import com.sun.xml.internal.ws.policy.SimpleAssertion;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.spi.AssertionCreationException;
import com.sun.xml.internal.ws.resources.ManagementMessages;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public abstract class ManagementAssertion
extends SimpleAssertion {
    protected static final QName MANAGEMENT_ATTRIBUTE_QNAME = new QName("management");
    protected static final QName MONITORING_ATTRIBUTE_QNAME = new QName("monitoring");
    private static final QName ID_ATTRIBUTE_QNAME = new QName("id");
    private static final QName START_ATTRIBUTE_QNAME = new QName("start");
    private static final Logger LOGGER = Logger.getLogger(ManagementAssertion.class);

    protected static <T extends ManagementAssertion> T getAssertion(QName qName, PolicyMap policyMap, QName qName2, QName qName3, Class<T> clazz) throws WebServiceException {
        try {
            AssertionSet assertionSet;
            Iterator<PolicyAssertion> iterator;
            Iterator<AssertionSet> iterator2;
            PolicyMapKey policyMapKey;
            Policy policy;
            PolicyAssertion policyAssertion = null;
            if (policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(policyMapKey = PolicyMap.createWsdlEndpointScopeKey(qName2, qName3))) != null && (iterator2 = policy.iterator()).hasNext() && (iterator = (assertionSet = iterator2.next()).get(qName).iterator()).hasNext()) {
                policyAssertion = iterator.next();
            }
            return (T)(policyAssertion == null ? null : (ManagementAssertion)policyAssertion.getImplementation(clazz));
        }
        catch (PolicyException policyException) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_1001_FAILED_ASSERTION(qName), policyException));
        }
    }

    protected ManagementAssertion(QName qName, AssertionData assertionData, Collection<PolicyAssertion> collection) throws AssertionCreationException {
        super(assertionData, collection);
        if (!qName.equals(assertionData.getName())) {
            throw LOGGER.logSevereException(new AssertionCreationException(assertionData, ManagementMessages.WSM_1002_EXPECTED_MANAGEMENT_ASSERTION(qName)));
        }
        if (this.isManagementEnabled() && !assertionData.containsAttribute(ID_ATTRIBUTE_QNAME)) {
            throw LOGGER.logSevereException(new AssertionCreationException(assertionData, ManagementMessages.WSM_1003_MANAGEMENT_ASSERTION_MISSING_ID(qName)));
        }
    }

    public String getId() {
        return this.getAttributeValue(ID_ATTRIBUTE_QNAME);
    }

    public String getStart() {
        return this.getAttributeValue(START_ATTRIBUTE_QNAME);
    }

    public abstract boolean isManagementEnabled();

    public Setting monitoringAttribute() {
        String string = this.getAttributeValue(MONITORING_ATTRIBUTE_QNAME);
        Setting setting = Setting.NOT_SET;
        if (string != null) {
            setting = string.trim().toLowerCase().equals("on") || Boolean.parseBoolean(string) ? Setting.ON : Setting.OFF;
        }
        return setting;
    }

    public static enum Setting {
        NOT_SET,
        OFF,
        ON;

    }
}

