/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class VBox
extends Pane {
    private static final String MARGIN_CONSTRAINT = "vbox-margin";
    private static final String VGROW_CONSTRAINT = "vbox-vgrow";
    private DoubleProperty spacing;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty fillWidth;
    private double[] actualAreaHeights;

    public static void setVgrow(Node node, Priority priority) {
        VBox.setConstraint(node, VGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getVgrow(Node node) {
        return (Priority)((Object)VBox.getConstraint(node, VGROW_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        VBox.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)VBox.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        VBox.setVgrow(node, null);
        VBox.setMargin(node, null);
    }

    public VBox() {
    }

    public VBox(double d) {
        this();
        this.setSpacing(d);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    VBox.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return VBox.this;
                }

                @Override
                public String getName() {
                    return "spacing";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SPACING;
                }
            };
        }
        return this.spacing;
    }

    public final void setSpacing(double d) {
        this.spacingProperty().set(d);
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    VBox.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return VBox.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ALIGNMENT;
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final BooleanProperty fillWidthProperty() {
        if (this.fillWidth == null) {
            this.fillWidth = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    VBox.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return VBox.this;
                }

                @Override
                public String getName() {
                    return "fillWidth";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.FILL_WIDTH;
                }
            };
        }
        return this.fillWidth;
    }

    public final void setFillWidth(boolean bl) {
        this.fillWidthProperty().set(bl);
    }

    public final boolean isFillWidth() {
        return this.fillWidth == null ? true : this.fillWidth.get();
    }

    @Override
    public Orientation getContentBias() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged() || node.getContentBias() == null) continue;
            return node.getContentBias();
        }
        return null;
    }

    @Override
    protected double computeMinWidth(double d) {
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        double d2 = 0.0;
        if (this.getContentBias() == Orientation.VERTICAL) {
            double[] dArray = this.getAreaHeights(list, -1.0, true);
            this.adjustAreaHeights(list, dArray, d, -1.0);
            d2 = this.computeMaxMinAreaWidth(list, this.getMargins(list), dArray, this.getAlignment().getHpos());
        } else {
            d2 = this.computeMaxMinAreaWidth(list, this.getMargins(list), this.getAlignment().getHpos());
        }
        return this.snapSpace(insets.getLeft()) + d2 + this.snapSpace(insets.getRight());
    }

    @Override
    protected double computeMinHeight(double d) {
        Insets insets = this.getInsets();
        return this.snapSpace(insets.getTop()) + this.computeContentHeight(this.getAreaHeights(this.getManagedChildren(), d, true)) + this.snapSpace(insets.getBottom());
    }

    @Override
    protected double computePrefWidth(double d) {
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        double d2 = 0.0;
        if (this.getContentBias() == Orientation.VERTICAL) {
            double[] dArray = this.getAreaHeights(list, -1.0, false);
            this.adjustAreaHeights(list, dArray, d, -1.0);
            d2 = this.computeMaxPrefAreaWidth(list, this.getMargins(list), dArray, this.getAlignment().getHpos());
        } else {
            d2 = this.computeMaxPrefAreaWidth(list, this.getMargins(list), this.getAlignment().getHpos());
        }
        return this.snapSpace(insets.getLeft()) + d2 + this.snapSpace(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        Insets insets = this.getInsets();
        double d2 = this.snapSpace(insets.getTop()) + this.computeContentHeight(this.getAreaHeights(this.getManagedChildren(), d, false)) + this.snapSpace(insets.getBottom());
        return d2;
    }

    private Insets[] getMargins(List<Node> list) {
        Insets[] insetsArray = new Insets[list.size()];
        for (int i = 0; i < insetsArray.length; ++i) {
            insetsArray[i] = VBox.getMargin(list.get(i));
        }
        return insetsArray;
    }

    private double[] getAreaHeights(List<Node> list, double d, boolean bl) {
        double[] dArray = new double[list.size()];
        double d2 = d == -1.0 ? -1.0 : d - this.snapSpace(this.getInsets().getLeft()) - this.snapSpace(this.getInsets().getRight());
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            Insets insets = VBox.getMargin(node);
            dArray[i] = bl ? this.computeChildMinAreaHeight(node, insets, this.isFillWidth() ? d2 : node.minWidth(-1.0)) : this.computeChildPrefAreaHeight(node, insets, this.isFillWidth() ? d2 : node.prefWidth(-1.0));
        }
        return dArray;
    }

    private double adjustAreaHeights(List<Node> list, double[] dArray, double d, double d2) {
        Insets insets = this.getInsets();
        double d3 = this.snapSpace(insets.getLeft());
        double d4 = this.snapSpace(insets.getRight());
        double d5 = this.computeContentHeight(dArray);
        double d6 = (d == -1.0 ? this.prefHeight(-1.0) : d) - this.snapSpace(insets.getTop()) - this.snapSpace(insets.getBottom()) - d5;
        if (d6 != 0.0) {
            double d7 = this.growOrShrinkAreaHeights(list, dArray, Priority.ALWAYS, d6, this.isFillWidth() && d2 != -1.0 ? d2 - d3 - d4 : -1.0);
            d7 = this.growOrShrinkAreaHeights(list, dArray, Priority.SOMETIMES, d7, this.isFillWidth() && d2 != -1.0 ? d2 - d3 - d4 : -1.0);
            d5 += d6 - d7;
        }
        return d5;
    }

    private double growOrShrinkAreaHeights(List<Node> list, double[] dArray, Priority priority, double d, double d2) {
        Node[] nodeArray;
        boolean bl = d < 0.0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            if (!bl && VBox.getVgrow(node) != priority) continue;
            arrayList.add(node);
            arrayList2.add(node);
        }
        double[] dArray2 = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node = (Node)arrayList.get(i);
            nodeArray = VBox.getMargin(node);
            dArray2[i] = bl ? this.computeChildMinAreaHeight(node, (Insets)nodeArray, d2) : this.computeChildMaxAreaHeight(node, (Insets)nodeArray, d2);
        }
        double d3 = d;
        while (Math.abs(d3) > 1.0 && arrayList2.size() > 0) {
            nodeArray = new Node[arrayList.size()];
            double d4 = d3 / (double)arrayList2.size();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Node node = (Node)arrayList2.get(i);
                int n = list.indexOf(node);
                double d5 = dArray2[arrayList.indexOf(node)] - dArray[n];
                double d6 = Math.abs(d5) <= Math.abs(d4) ? d5 : d4;
                int n2 = n;
                dArray[n2] = dArray[n2] + d6;
                d3 -= d6;
                if (!(Math.abs(d6) < Math.abs(d4))) continue;
                nodeArray[i] = node;
            }
            for (Node node : nodeArray) {
                if (node == null) continue;
                arrayList2.remove(node);
            }
        }
        return d3;
    }

    private double computeContentHeight(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d + (double)(dArray.length - 1) * this.snapSpace(this.getSpacing());
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        Insets insets = this.getInsets();
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.snapSpace(insets.getTop());
        double d4 = this.snapSpace(insets.getLeft());
        double d5 = this.snapSpace(insets.getBottom());
        double d6 = this.snapSpace(insets.getRight());
        double d7 = this.snapSpace(this.getSpacing());
        this.actualAreaHeights = this.getAreaHeights(list, d, false);
        double d8 = d - d4 - d6;
        double d9 = this.adjustAreaHeights(list, this.actualAreaHeights, d2, d);
        double d10 = d4;
        double d11 = d3 + VBox.computeYOffset(d2 - d3 - d5, d9, this.getAlignment().getVpos());
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            this.layoutInArea(node, d10, d11, d8, this.actualAreaHeights[i], this.actualAreaHeights[i], VBox.getMargin(node), this.isFillWidth(), true, this.getAlignment().getHpos(), this.getAlignment().getVpos());
            d11 += this.actualAreaHeights[i] + d7;
        }
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return VBox.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<VBox, Pos> ALIGNMENT = new StyleableProperty<VBox, Pos>("-fx-alignment", new EnumConverter(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(VBox vBox) {
                return vBox.alignment == null || !vBox.alignment.isBound();
            }

            @Override
            public WritableValue<Pos> getWritableValue(VBox vBox) {
                return vBox.alignmentProperty();
            }
        };
        private static final StyleableProperty<VBox, Boolean> FILL_WIDTH = new StyleableProperty<VBox, Boolean>("-fx-fill-width", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(VBox vBox) {
                return vBox.fillWidth == null || !vBox.fillWidth.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(VBox vBox) {
                return vBox.fillWidthProperty();
            }
        };
        private static final StyleableProperty<VBox, Number> SPACING = new StyleableProperty<VBox, Number>("-fx-spacing", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(VBox vBox) {
                return vBox.spacing == null || !vBox.spacing.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(VBox vBox) {
                return vBox.spacingProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ALIGNMENT, FILL_WIDTH, SPACING);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

