/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.BuyInfo;
import cn.com.voltronic.solar.dbtools.DBManager;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class BuyInfoDao
extends BaseDao {
    public static final String INSERT_BUYINFO = " INSERT INTO BUYINFO(prodid,serialno,purchasedate,batpurchasedate,warranty,batwarranty,pncode,useprompt,batuseperiod) VALUES(?,?,?,?,?,?,?,?,?)";
    public static final String UPDATA_BUYINFO = " UPDATE BUYINFO SET purchasedate=?,batpurchasedate=?,warranty=?,batwarranty=?,pncode=?,useprompt=?,batuseperiod=? WHERE serialno=? ";
    public static final String QUERY_BUYINFO = " SELECT * FROM BUYINFO WHERE serialno=? ";

    public boolean addBuyinfo(BuyInfo buyinfo) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        if (conn != null) {
            try {
                try {
                    ps = conn.prepareStatement(INSERT_BUYINFO);
                    ps.setString(1, buyinfo.getProdid());
                    ps.setString(2, buyinfo.getSerialno());
                    ps.setDate(3, new Date(buyinfo.getPurchasedate().getTime()));
                    if (buyinfo.getBatpurchasedate().equals("")) {
                        ps.setDate(4, null);
                    } else {
                        ps.setDate(4, new Date(buyinfo.getBatpurchasedate().getTime()));
                    }
                    ps.setInt(5, buyinfo.getWarranty());
                    ps.setInt(6, buyinfo.getBatwarranty());
                    ps.setString(7, buyinfo.getPncode());
                    ps.setBoolean(8, buyinfo.isUseprompt());
                    ps.setInt(9, buyinfo.getBatuseperiod());
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(ps);
                }
            }
            finally {
                this.close(ps);
            }
        }
        return result;
    }

    public boolean updataBuyinfo(BuyInfo buyinfo) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        if (conn != null) {
            try {
                try {
                    ps = conn.prepareStatement(UPDATA_BUYINFO);
                    ps.setDate(1, new Date(buyinfo.getPurchasedate().getTime()));
                    if (buyinfo.getBatpurchasedate().equals("")) {
                        ps.setDate(2, null);
                    } else {
                        ps.setDate(2, new Date(buyinfo.getBatpurchasedate().getTime()));
                    }
                    ps.setInt(3, buyinfo.getWarranty());
                    ps.setInt(4, buyinfo.getBatwarranty());
                    ps.setString(5, buyinfo.getPncode());
                    ps.setBoolean(6, buyinfo.isUseprompt());
                    ps.setInt(7, buyinfo.getBatuseperiod());
                    ps.setString(8, buyinfo.getSerialno());
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(ps);
                }
            }
            finally {
                this.close(ps);
            }
        }
        return result;
    }

    public boolean isExistBuyinfo(String serialno) {
        boolean result;
        block7: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(QUERY_BUYINFO);
                        ps.setString(1, serialno);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            result = true;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }

    public BuyInfo queryBuyinfo(String serialno) {
        BuyInfo result;
        block7: {
            result = null;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(QUERY_BUYINFO);
                        ps.setString(1, serialno);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            result = new BuyInfo();
                            result.setSerialno(serialno);
                            result.setPurchasedate(rs.getDate("purchasedate"));
                            result.setBatpurchasedate(rs.getDate("batpurchasedate"));
                            result.setWarranty(rs.getInt("warranty"));
                            result.setBatwarranty(rs.getInt("batwarranty"));
                            result.setUseprompt(rs.getBoolean("useprompt"));
                            result.setBatuseperiod(rs.getInt("batuseperiod"));
                            result.setPncode(rs.getString("pncode"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }
}

