/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.configure.CustomerConfig;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.CommandParameterMap;
import cn.com.voltronic.solar.data.bean.ControlRelation;
import cn.com.voltronic.solar.data.bean.EnableSpinnerParameter;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.MoreInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.PurchaseInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.CRCUtil;
import java.util.ArrayList;
import java.util.List;

public class P15
implements IProtocol {
    protected int mpptTrackNumber = 2;
    protected String modelName = "";
    protected String modelType = "00";
    protected String deviceModel = "100";
    protected String serialNo = "";
    private CommandParameterMap map = new CommandParameterMap();
    private List<ControlRelation> relalist = new ArrayList<ControlRelation>();

    @Override
    public String getProtocolID() {
        return "P15";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            IComUSBHandler _handler = (IComUSBHandler)handler;
            String dataStr = "(NAK";
            int i = 0;
            while (i < 5) {
                if (!dataStr.equals("(NAK")) break;
                try {
                    dataStr = _handler.excuteSimpleCommand("QPI");
                    if (dataStr.length() > 5) {
                        if (CRCUtil.checkCRC(dataStr)) {
                            dataStr = dataStr.substring(0, dataStr.length() - 2);
                            _handler.setCrcCheck(true);
                        } else {
                            dataStr = "(NAK";
                            _handler.setCrcCheck(false);
                        }
                    }
                }
                catch (Exception e) {
                    return false;
                }
                ++i;
            }
            if (dataStr.startsWith("(PI") && dataStr.endsWith("15") && this instanceof P15) {
                block12: {
                    try {
                        this.mpptTrackNumber = _handler.getMpptTrackNumber();
                        this.modelType = _handler.getModeType();
                        this.deviceModel = _handler.getDeviceModel();
                        String serialNoStr = _handler.getSerialNo();
                        if (serialNoStr != null && !"".equals(serialNoStr)) {
                            this.serialNo = serialNoStr;
                            break block12;
                        }
                        return false;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (!(handler instanceof ModbusHandler)) {
            boolean cfr_ignored_0 = handler instanceof SNMPHandler;
        }
        return false;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.gridVoltageR[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.gridFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.gridCurrentR[:]", "{workInfo.getGridCurrentR}", "A"));
        if (this.mpptTrackNumber == 1) {
            item.add(new AutoLabelItem("message.pvInputVoltage[:]", "{workInfo.getPvInputVoltage1}", "V"));
        } else {
            item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
        }
        if (this.mpptTrackNumber >= 2) {
            item.add(new AutoLabelItem("message.pvInputVoltage2[:]", "{workInfo.getPvInputVoltage2}", "V"));
        }
        if (this.mpptTrackNumber == 3) {
            item.add(new AutoLabelItem("message.pvInputVoltage3[:]", "{workInfo.getPvInputVoltage3}", "V"));
        }
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public MoreInfo getMoreInfo() {
        return null;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.topology[:]", "{machineInfo.getTopology}", ""));
        infos.add(new AutoLabelItem("message.mainfirewareversion[:]", "{machineInfo.getMainFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.slavefirewareversion[:]", "{machineInfo.getSlaveFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.iophase[:]", "{machineInfo.getIoPhase}", ""));
        infos.add(new AutoLabelItem("message.nominalInputVoltage[:]", "{machineInfo.getNominalInputVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominalOutputVoltage[:]", "{machineInfo.getNominalOutputVoltage}", "V"));
        productInfo.setInfos(infos);
        return productInfo;
    }

    @Override
    public PurchaseInfo getPurchaseInfo() {
        return null;
    }

    @Override
    public RatingInfo getRatingInfo() {
        RatingInfo ratingInfo = new RatingInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.outputRateVA[:]", "{machineInfo.getOutputRateVA}", "W"));
        infos.add(new AutoLabelItem("message.gridRatingVoltage[:]", "{machineInfo.getGridRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.gridRatingFrequency[:]", "{machineInfo.getGridRatingFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.gridRatingCurrent[:]", "{machineInfo.getGridRatingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.perMPPTRatingCurrent[:]", "{machineInfo.getPerMPPTRatingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.mpptTrackNumber[:]", "{machineInfo.getMpptTrackNumber}", ""));
        ratingInfo.setInfos(infos);
        return ratingInfo;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.setGOLV[:]", "{defaultData.getLowGridV}", "V"));
        infos.add(new AutoLabelItem("message.setGOHV[:]", "{defaultData.getHighGridV}", "V"));
        infos.add(new AutoLabelItem("message.setGOLF[:]", "{defaultData.getLowGridF}", "Hz"));
        infos.add(new AutoLabelItem("message.setGOHF[:]", "{defaultData.getHighGridF}", "Hz"));
        infos.add(new AutoLabelItem("message.setPVIPLV[:]", "{defaultData.getPvInputLowV}", "V"));
        infos.add(new AutoLabelItem("message.setPVIPHV[:]", "{defaultData.getPvInputHighV}", "V"));
        infos.add(new AutoLabelItem("message.setMPPTLV[:]", "{defaultData.getMppLowV}", "V"));
        infos.add(new AutoLabelItem("message.setMPPTHV[:]", "{defaultData.getMppHighV}", "V"));
        infos.add(new AutoLabelItem("message.setOPMP[:]", "{defaultData.getMaxoutputPower}", "W"));
        infos.add(new AutoLabelItem("message.setGridwaittime[:]", "{defaultData.getGridwaittime}", "message.seconds"));
        infos.add(new AutoLabelItem("message.setLCD[:]", "{defaultData.getLcdSleepTime}", "message.seconds"));
        if (this.deviceModel.equals("000") || this.deviceModel.equals("008")) {
            infos.add(new AutoLabelItem("message.setGILTHV[:]", "{defaultData.getGridAvgHighV}", "V"));
        }
        if (this.getProtocolID().equals("P20") && (this.deviceModel.equals("100") || this.deviceModel.equals("108"))) {
            infos.add(new AutoLabelItem("message.setGILTHV[:]", "{defaultData.getGridAvgHighV}", "V"));
        }
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.pepdP[:]", "message.enable", "message.disable", "{cappbility.isCapableP}", "CapableP", false));
        list.add(new AutoRadioItem("message.powerFactorLine[:]", "message.enable", "message.disable", "{cappbility.isCapabelePDG}", "CapabelePDG", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.setPVIPLV[:]", "{configData.getMinPvInputLowV}", "{configData.getMaxPvInputLowV}", "1", "{configData.getPvInputLowV}", "V", "setPVIPLV", 0, false));
        list.add(new AutoSpinnerItem("message.setPVIPHV[:]", "{configData.getMinPvInputHighV}", "{configData.getMaxPvInputHighV}", "1", "{configData.getPvInputHighV}", "V", "setPVIPHV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTLV[:]", "{configData.getMinMpptLowV}", "{configData.getMaxMpptLowV}", "1", "{configData.getMpptLowV}", "V", "setMPPTLV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTHV[:]", "{configData.getMinMpptHighV}", "{configData.getMaxMpptHighV}", "1", "{configData.getMpptHighV}", "V", "setMPPTHV", 0, false));
        if (!this.deviceModel.equals("012")) {
            list.add(new AutoSpinnerItem("message.setPVN[:]", "1", "99", "1", "{configData.getPvnNumber}", "", "setPVN", 0, false));
        }
        if (this.deviceModel.equals("008")) {
            list.add(new AutoSpinnerItem("message.powerFactorSet[:]", "{configData.getMinPowerFactor}", "{configData.getMaxPowerFactor}", "1", "{configData.getPowerFactor}", "%", "setPowerPercent", 0, false));
            list.add(new AutoSpinnerItem("message.powerPercentSet[:]", "{configData.getMinPowerPercent}", "{configData.getMaxPowerPercent}", "1", "{configData.getPowerPercent}", "%", "setPowerPFPercent", 0, false));
            list.add(new AutoSpinnerItem("message.minPFCurveV[:]", "{configData.getMinPowerPFcurve}", "{configData.getMaxPowerPFcurve}", "1", "{configData.getPowerPFcurve}", "%", "setPowerPFCurve", 0, false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.gridVoltageR", "{workInfo.getGridVoltageR}", true, false));
        list.add(new HistoryData("message.gridPowerR", "{workInfo.getGridPowerR}", true, false));
        list.add(new HistoryData("message.gridCurrentR", "{workInfo.getGridCurrentR}", true, false));
        list.add(new HistoryData("message.gridFrequency", "{workInfo.getGridFrequency}", true, true));
        if (this.mpptTrackNumber == 1) {
            list.add(new HistoryData("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", true, true));
        } else {
            list.add(new HistoryData("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", true, true));
        }
        if (this.mpptTrackNumber >= 2) {
            list.add(new HistoryData("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", true, true));
        }
        if (this.mpptTrackNumber == 3) {
            list.add(new HistoryData("message.pvInputVoltage3", "{workInfo.getPvInputVoltage3}", true, true));
        }
        list.add(new HistoryData("message.temperature", "{workInfo.getMaxTemperature}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{faultData.getGridVoltage}", true, true));
        list.add(new HistoryData("message.gridCurrentR", "{faultData.getGridCurrent}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{faultData.getGridFrequency}", true, true));
        if (this.mpptTrackNumber == 1) {
            list.add(new HistoryData("message.pvInputVoltage", "{faultData.getPvinputvoltage1}", true, true));
            list.add(new HistoryData("message.pvInputCurrent", "{faultData.getPvinputcurrent1}", true, true));
        } else {
            list.add(new HistoryData("message.pvInputVoltage1", "{faultData.getPvinputvoltage1}", true, true));
            list.add(new HistoryData("message.pvInputCurrent1", "{faultData.getPvinputcurrent1}", true, true));
        }
        if (this.mpptTrackNumber >= 2) {
            list.add(new HistoryData("message.pvInputVoltage2", "{faultData.getPvinputvoltage2}", true, true));
            list.add(new HistoryData("message.pvInputCurrent2", "{faultData.getPvinputcurrent2}", true, true));
        }
        if (this.mpptTrackNumber == 3) {
            list.add(new HistoryData("message.pvInputVoltage3", "{faultData.getPvinputvoltage3}", true, true));
            list.add(new HistoryData("message.pvInputCurrent3", "{faultData.getPvinputcurrent3}", true, true));
        }
        list.add(new HistoryData("message.temperature", "{faultData.getMaxTemperature}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.gridVoltageR", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.gridPowerR", "{workInfo.getGridPowerR}", 3000.0, "W", true));
        list.add(new HistoryChart("message.gridCurrentR", "{workInfo.getGridCurrentR}", 100.0, "A", true));
        list.add(new HistoryChart("message.gridFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        if (this.mpptTrackNumber == 1) {
            list.add(new HistoryChart("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", 500.0, "V", true));
        } else {
            list.add(new HistoryChart("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", 500.0, "V", true));
        }
        if (this.mpptTrackNumber >= 2) {
            list.add(new HistoryChart("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", 500.0, "V", true));
        }
        if (this.mpptTrackNumber == 3) {
            list.add(new HistoryChart("message.pvInputVoltage3", "{workInfo.getPvInputVoltage3}", 500.0, "V", true));
        }
        list.add(new HistoryChart("message.temperature", "{workInfo.getMaxTemperature}", 180.0, "Degree", true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public int getMpptTrackNumber() {
        return this.mpptTrackNumber;
    }

    @Override
    public void setMpptTrackNumber(int mpptTrackNumber) {
        this.mpptTrackNumber = mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        return this.serialNo;
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electrovalenceSet", 103, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.synchroEnergyData", 203, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.realTimeCtrl", 204, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryPower", 301, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryFaultData", 303, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.monitorPointInfo", 305, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.powerNumber", 306, ""), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Italian", 404, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", 406, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Russian", 407, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", 409, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Turkish", 410, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Japanese", 413, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        ArrayList<AutoMenuItem> items = new ArrayList<AutoMenuItem>();
        CustomerConfig custormerConfig = GlobalVariables.customerConfig;
        if (custormerConfig.isEnglish()) {
            items.add(new AutoMenuItem("English", 5021, ""));
        }
        if (custormerConfig.isTurkish()) {
            items.add(new AutoMenuItem("Turkish", 5022, ""));
        }
        if (custormerConfig.isRussian()) {
            items.add(new AutoMenuItem("Russian", 5023, ""));
        }
        if (items.size() < 2) {
            items = null;
        }
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), items));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }

    @Override
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    @Override
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public CommandParameterMap getCommandMap() {
        return this.map;
    }

    @Override
    public void initCommandMap() {
        this.map.clear();
        this.map.AddCommand("setGOLV", 1);
        this.map.AddCommand("setGOHV", 1);
        this.map.AddCommand("setGOLF", 1);
        this.map.AddCommand("setGOHF", 1);
        this.map.AddCommand("setOPMP", 1);
        this.map.AddCommand("setPVN", 1);
        this.map.AddCommand("setGridWaittime", 1);
        this.map.AddCommand("setPVIPLV", 1);
        this.map.AddCommand("setPVIPHV", 1);
        this.map.AddCommand("setMPPTLV", 1);
        this.map.AddCommand("setMPPTHV", 1);
        this.map.AddCommand("setGILTHV", 1);
        this.map.AddCommand("setGOLV", 1);
        this.map.AddCommand("setGOHV", 1);
        this.map.AddCommand("setGOLF", 1);
        this.map.AddCommand("setGOHF", 1);
        this.map.AddCommand("setMaxChargingCurrent", 1);
        this.map.AddCommand("setFloatingVoltage", 1);
        this.map.AddCommand("setMaxChargingVoltage", 1);
        this.map.AddCommand("setCutoffVoltage", 2);
        this.map.AddCommand("setPowerFactor", 1);
        this.map.AddCommand("setPowerPercent", 1);
        this.map.AddCommand("setPowerPFPercent", 1);
        this.map.AddCommand("setPowerPFCurve", 1);
        this.map.AddCommand("setRecoverVoltage", 2);
        this.map.AddCommand("setLiBatterySetting", 3);
        this.relalist.clear();
    }

    @Override
    public List<ControlRelation> getRelationList() {
        return this.relalist;
    }

    @Override
    public boolean isSupportModelSetting() {
        return false;
    }

    @Override
    public String getDSPVersion() {
        return null;
    }

    @Override
    public String getMCUVersion() {
        return null;
    }

    @Override
    public SpinnerParameter getFactoryParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.setGOLV[:]", "{configData.getMinGridoutputlowV}", "{configData.getMaxGridoutputlowV}", "0.1", "{configData.getGridoutputlowV}", "V", "setGOLV", 0, false));
        list.add(new AutoSpinnerItem("message.setGOHV[:]", "{configData.getMinGridoutputhighV}", "{configData.getMaxGridoutputhighV}", "0.1", "{configData.getGridoutputhighV}", "V", "setGOHV", 0, false));
        list.add(new AutoSpinnerItem("message.setGOLF[:]", "{configData.getMinGridoutputlowF}", "{configData.getMaxGridoutputlowF}", "0.1", "{configData.getGridoutputlowF}", "Hz", "setGOLF", 0, false));
        list.add(new AutoSpinnerItem("message.setGOHF[:]", "{configData.getMinGridoutputhighF}", "{configData.getMaxGridoutputhighF}", "0.1", "{configData.getGridoutputhighF}", "Hz", "setGOHF", 0, false));
        list.add(new AutoSpinnerItem("message.setOPMP[:]", "{configData.getMinMaxoutputPower}", "{configData.getMaxMaxoutputPower}", "10", "{configData.getMaxoutputPower}", "W", "setOPMP", 0, false));
        list.add(new AutoSpinnerItem("message.setGridwaittime[:]", "{configData.getMinGridWaittime}", "{configData.getMaxGridWaittime}", "1", "{configData.getGridwaittime}", "message.seconds", "setGridWaittime", 0, false));
        if (this.deviceModel.equals("000") || this.deviceModel.equals("008")) {
            list.add(new AutoSpinnerItem("message.setGILTHV[:]", "{configData.getMinGridAvgHighV}", "{configData.getMaxGridAvgHighV}", "1", "{configData.getGridAvgHighV}", "V", "setGILTHV", 0, false));
        }
        if (this.getProtocolID().equals("P20") && (this.deviceModel.equals("100") || this.deviceModel.equals("108"))) {
            list.add(new AutoSpinnerItem("message.setGILTHV[:]", "{configData.getMinGridAvgHighV}", "{configData.getMaxGridAvgHighV}", "1", "{configData.getGridAvgHighV}", "V", "setGILTHV", 0, false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public List<String> spinnerValueRelate() {
        return null;
    }

    @Override
    public EnableSpinnerParameter getEnableSpinnerParameter() {
        return null;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        return null;
    }

    @Override
    public int getOutputMode() {
        return 0;
    }

    @Override
    public void setOutputMode(int outputmode) {
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
}

