/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.internal.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.RootOnlyCodec;
import com.sun.xml.internal.ws.encoding.StreamSOAP11Codec;
import com.sun.xml.internal.ws.encoding.StreamSOAP12Codec;
import com.sun.xml.internal.ws.encoding.TagInfoset;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import com.sun.xml.internal.ws.message.stream.StreamHeader;
import com.sun.xml.internal.ws.message.stream.StreamMessage;
import com.sun.xml.internal.ws.protocol.soap.VersionMismatchException;
import com.sun.xml.internal.ws.server.UnsupportedMediaException;
import com.sun.xml.internal.ws.streaming.TidyXMLStreamReader;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

public abstract class StreamSOAPCodec
implements com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec,
RootOnlyCodec {
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private final String SOAP_NAMESPACE_URI;
    private final SOAPVersion soapVersion;

    StreamSOAPCodec(SOAPVersion sOAPVersion) {
        this.SOAP_NAMESPACE_URI = sOAPVersion.nsUri;
        this.soapVersion = sOAPVersion;
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet.soapAction);
    }

    @Override
    public ContentType encode(Packet packet, OutputStream outputStream) {
        if (packet.getMessage() != null) {
            XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create(outputStream);
            try {
                packet.getMessage().writeTo(xMLStreamWriter);
                xMLStreamWriter.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
            XMLStreamWriterFactory.recycle(xMLStreamWriter);
        }
        return this.getContentType(packet.soapAction);
    }

    protected abstract ContentType getContentType(String var1);

    @Override
    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    protected abstract List<String> getExpectedContentTypes();

    @Override
    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        this.decode(inputStream, string, packet, (AttachmentSet)new AttachmentSetImpl());
    }

    private static boolean isContentTypeSupported(String string, List<String> list) {
        for (String string2 : list) {
            if (string.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public final Message decode(@NotNull XMLStreamReader xMLStreamReader) {
        return this.decode(xMLStreamReader, new AttachmentSetImpl());
    }

    @Override
    public final Message decode(XMLStreamReader xMLStreamReader, @NotNull AttachmentSet attachmentSet) {
        if (xMLStreamReader.getEventType() != 1) {
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        if (SOAP_ENVELOPE.equals(xMLStreamReader.getLocalName()) && !this.SOAP_NAMESPACE_URI.equals(xMLStreamReader.getNamespaceURI())) {
            throw new VersionMismatchException(this.soapVersion, this.SOAP_NAMESPACE_URI, xMLStreamReader.getNamespaceURI());
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.SOAP_NAMESPACE_URI, SOAP_ENVELOPE);
        TagInfoset tagInfoset = new TagInfoset(xMLStreamReader);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
            hashMap.put(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
        }
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        HeaderList headerList = null;
        TagInfoset tagInfoset2 = null;
        if (xMLStreamReader.getLocalName().equals(SOAP_HEADER) && xMLStreamReader.getNamespaceURI().equals(this.SOAP_NAMESPACE_URI)) {
            tagInfoset2 = new TagInfoset(xMLStreamReader);
            for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
                hashMap.put(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
            }
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            if (xMLStreamReader.getEventType() == 1) {
                headerList = new HeaderList();
                try {
                    this.cacheHeaders(xMLStreamReader, hashMap, headerList);
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(xMLStreamException);
                }
            }
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.SOAP_NAMESPACE_URI, SOAP_BODY);
        TagInfoset tagInfoset3 = new TagInfoset(xMLStreamReader);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        return new StreamMessage(tagInfoset, tagInfoset2, attachmentSet, headerList, tagInfoset3, xMLStreamReader, this.soapVersion);
    }

    @Override
    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final StreamSOAPCodec copy() {
        return this;
    }

    private XMLStreamBuffer cacheHeaders(XMLStreamReader xMLStreamReader, Map<String, String> map, HeaderList headerList) throws XMLStreamException {
        MutableXMLStreamBuffer mutableXMLStreamBuffer = this.createXMLStreamBuffer();
        StreamReaderBufferCreator streamReaderBufferCreator = new StreamReaderBufferCreator();
        streamReaderBufferCreator.setXMLStreamBuffer(mutableXMLStreamBuffer);
        while (xMLStreamReader.getEventType() == 1) {
            Map<String, String> map2 = map;
            if (xMLStreamReader.getNamespaceCount() > 0) {
                map2 = new HashMap<String, String>(map);
                for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
                    map2.put(xMLStreamReader.getNamespacePrefix(i), xMLStreamReader.getNamespaceURI(i));
                }
            }
            XMLStreamBufferMark xMLStreamBufferMark = new XMLStreamBufferMark(map2, streamReaderBufferCreator);
            headerList.add(this.createHeader(xMLStreamReader, xMLStreamBufferMark));
            streamReaderBufferCreator.createElementFragment(xMLStreamReader, false);
            if (xMLStreamReader.getEventType() == 1 || xMLStreamReader.getEventType() == 2) continue;
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        return mutableXMLStreamBuffer;
    }

    protected abstract StreamHeader createHeader(XMLStreamReader var1, XMLStreamBuffer var2);

    private MutableXMLStreamBuffer createXMLStreamBuffer() {
        return new MutableXMLStreamBuffer();
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet, AttachmentSet attachmentSet) throws IOException {
        List<String> list = this.getExpectedContentTypes();
        if (string != null && !StreamSOAPCodec.isContentTypeSupported(string, list)) {
            throw new UnsupportedMediaException(string, list);
        }
        String string2 = new ContentTypeImpl(string).getCharSet();
        if (string2 != null && !Charset.isSupported(string2)) {
            throw new UnsupportedMediaException(string2);
        }
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, inputStream, string2, true);
        xMLStreamReader = new TidyXMLStreamReader(xMLStreamReader, inputStream);
        packet.setMessage(this.decode(xMLStreamReader, attachmentSet));
    }

    @Override
    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet, AttachmentSet attachmentSet) {
        throw new UnsupportedOperationException();
    }

    public static StreamSOAPCodec create(SOAPVersion sOAPVersion) {
        if (sOAPVersion == null) {
            throw new IllegalArgumentException();
        }
        switch (sOAPVersion) {
            case SOAP_11: {
                return new StreamSOAP11Codec();
            }
            case SOAP_12: {
                return new StreamSOAP12Codec();
            }
        }
        throw new AssertionError();
    }
}

