/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanEntry;
import org.springframework.beans.factory.parsing.ConstructorArgumentEntry;
import org.springframework.beans.factory.parsing.ParseState;
import org.springframework.beans.factory.parsing.PropertyEntry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.xml.DocumentDefaultsDefinition;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanDefinitionParserDelegate {
    public static final String BEANS_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    public static final String BEAN_NAME_DELIMITERS = ",; ";
    public static final String TRUE_VALUE = "true";
    public static final String DEFAULT_VALUE = "default";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String AUTOWIRE_BY_NAME_VALUE = "byName";
    public static final String AUTOWIRE_BY_TYPE_VALUE = "byType";
    public static final String AUTOWIRE_CONSTRUCTOR_VALUE = "constructor";
    public static final String AUTOWIRE_AUTODETECT_VALUE = "autodetect";
    public static final String DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE = "all";
    public static final String DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE = "simple";
    public static final String DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE = "objects";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String BEAN_ELEMENT = "bean";
    public static final String META_ELEMENT = "meta";
    public static final String ID_ATTRIBUTE = "id";
    public static final String PARENT_ATTRIBUTE = "parent";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ABSTRACT_ATTRIBUTE = "abstract";
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static final String SINGLETON_ATTRIBUTE = "singleton";
    public static final String LAZY_INIT_ATTRIBUTE = "lazy-init";
    public static final String AUTOWIRE_ATTRIBUTE = "autowire";
    public static final String AUTOWIRE_CANDIDATE_ATTRIBUTE = "autowire-candidate";
    public static final String DEPENDENCY_CHECK_ATTRIBUTE = "dependency-check";
    public static final String DEPENDS_ON_ATTRIBUTE = "depends-on";
    public static final String INIT_METHOD_ATTRIBUTE = "init-method";
    public static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";
    public static final String FACTORY_METHOD_ATTRIBUTE = "factory-method";
    public static final String FACTORY_BEAN_ATTRIBUTE = "factory-bean";
    public static final String CONSTRUCTOR_ARG_ELEMENT = "constructor-arg";
    public static final String INDEX_ATTRIBUTE = "index";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String VALUE_TYPE_ATTRIBUTE = "value-type";
    public static final String KEY_TYPE_ATTRIBUTE = "key-type";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String LOOKUP_METHOD_ELEMENT = "lookup-method";
    public static final String REPLACED_METHOD_ELEMENT = "replaced-method";
    public static final String REPLACER_ATTRIBUTE = "replacer";
    public static final String ARG_TYPE_ELEMENT = "arg-type";
    public static final String ARG_TYPE_MATCH_ATTRIBUTE = "match";
    public static final String REF_ELEMENT = "ref";
    public static final String IDREF_ELEMENT = "idref";
    public static final String BEAN_REF_ATTRIBUTE = "bean";
    public static final String LOCAL_REF_ATTRIBUTE = "local";
    public static final String PARENT_REF_ATTRIBUTE = "parent";
    public static final String VALUE_ELEMENT = "value";
    public static final String NULL_ELEMENT = "null";
    public static final String LIST_ELEMENT = "list";
    public static final String SET_ELEMENT = "set";
    public static final String MAP_ELEMENT = "map";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ELEMENT = "key";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String KEY_REF_ATTRIBUTE = "key-ref";
    public static final String VALUE_REF_ATTRIBUTE = "value-ref";
    public static final String PROPS_ELEMENT = "props";
    public static final String PROP_ELEMENT = "prop";
    public static final String MERGE_ATTRIBUTE = "merge";
    public static final String DEFAULT_LAZY_INIT_ATTRIBUTE = "default-lazy-init";
    public static final String DEFAULT_AUTOWIRE_ATTRIBUTE = "default-autowire";
    public static final String DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE = "default-dependency-check";
    public static final String DEFAULT_INIT_METHOD_ATTRIBUTE = "default-init-method";
    public static final String DEFAULT_DESTROY_METHOD_ATTRIBUTE = "default-destroy-method";
    public static final String DEFAULT_MERGE_ATTRIBUTE = "default-merge";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final XmlReaderContext readerContext;
    private DocumentDefaultsDefinition defaults;
    private ParseState parseState = new ParseState();
    private final Set usedNames = new HashSet();

    public BeanDefinitionParserDelegate(XmlReaderContext xmlReaderContext) {
        Assert.notNull((Object)xmlReaderContext, (String)"XmlReaderContext must not be null");
        this.readerContext = xmlReaderContext;
    }

    public final XmlReaderContext getReaderContext() {
        return this.readerContext;
    }

    protected Object extractSource(Element element) {
        return this.readerContext.extractSource(element);
    }

    protected void error(String string, Element element) {
        this.readerContext.error(string, (Object)element, this.parseState.snapshot());
    }

    protected void error(String string, Element element, Throwable throwable) {
        this.readerContext.error(string, element, this.parseState.snapshot(), throwable);
    }

    public void initDefaults(Element element) {
        DocumentDefaultsDefinition documentDefaultsDefinition = new DocumentDefaultsDefinition();
        documentDefaultsDefinition.setLazyInit(element.getAttribute(DEFAULT_LAZY_INIT_ATTRIBUTE));
        documentDefaultsDefinition.setAutowire(element.getAttribute(DEFAULT_AUTOWIRE_ATTRIBUTE));
        documentDefaultsDefinition.setDependencyCheck(element.getAttribute(DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE));
        if (element.hasAttribute(DEFAULT_INIT_METHOD_ATTRIBUTE)) {
            documentDefaultsDefinition.setInitMethod(element.getAttribute(DEFAULT_INIT_METHOD_ATTRIBUTE));
        }
        if (element.hasAttribute(DEFAULT_DESTROY_METHOD_ATTRIBUTE)) {
            documentDefaultsDefinition.setDestroyMethod(element.getAttribute(DEFAULT_DESTROY_METHOD_ATTRIBUTE));
        }
        documentDefaultsDefinition.setMerge(element.getAttribute(DEFAULT_MERGE_ATTRIBUTE));
        documentDefaultsDefinition.setSource(this.readerContext.extractSource(element));
        this.defaults = documentDefaultsDefinition;
        this.readerContext.fireDefaultsRegistered(documentDefaultsDefinition);
    }

    public DocumentDefaultsDefinition getDefaults() {
        return this.defaults;
    }

    public BeanDefinitionHolder parseBeanDefinitionElement(Element element) {
        return this.parseBeanDefinitionElement(element, null);
    }

    public BeanDefinitionHolder parseBeanDefinitionElement(Element element, BeanDefinition beanDefinition) {
        AbstractBeanDefinition abstractBeanDefinition;
        Object object;
        String[] stringArray = element.getAttribute(ID_ATTRIBUTE);
        String string = element.getAttribute(NAME_ATTRIBUTE);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.hasLength((String)string)) {
            object = StringUtils.tokenizeToStringArray((String)string, (String)BEAN_NAME_DELIMITERS);
            arrayList.addAll(Arrays.asList(object));
        }
        if (!StringUtils.hasText((String)(object = stringArray)) && !arrayList.isEmpty()) {
            object = (String)arrayList.remove(0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No XML 'id' specified - using '" + (String)object + "' as bean name and " + arrayList + " as aliases"));
            }
        }
        if (beanDefinition == null) {
            this.checkNameUniqueness((String)object, arrayList, element);
        }
        if ((abstractBeanDefinition = this.parseBeanDefinitionElement(element, (String)object, beanDefinition)) != null) {
            if (!StringUtils.hasText((String)object)) {
                try {
                    object = beanDefinition != null ? BeanDefinitionReaderUtils.generateBeanName(abstractBeanDefinition, this.readerContext.getRegistry(), true) : this.readerContext.generateBeanName(abstractBeanDefinition);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Neither XML 'id' nor 'name' specified - using generated bean name [" + (String)object + "]"));
                    }
                }
                catch (BeanDefinitionStoreException beanDefinitionStoreException) {
                    this.error(beanDefinitionStoreException.getMessage(), element);
                    return null;
                }
            }
            String[] stringArray2 = StringUtils.toStringArray(arrayList);
            return new BeanDefinitionHolder(abstractBeanDefinition, (String)object, stringArray2);
        }
        return null;
    }

    private void checkNameUniqueness(String string, List list, Element element) {
        String string2 = null;
        if (StringUtils.hasText((String)string) && this.usedNames.contains(string)) {
            string2 = string;
        }
        if (string2 == null) {
            string2 = (String)CollectionUtils.findFirstMatch((Collection)this.usedNames, (Collection)list);
        }
        if (string2 != null) {
            this.error("Bean name '" + string2 + "' is already used in this file.", element);
        }
        this.usedNames.add(string);
        this.usedNames.addAll(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBeanDefinition parseBeanDefinitionElement(Element element, String string, BeanDefinition beanDefinition) {
        String string2 = null;
        if (element.hasAttribute(CLASS_ATTRIBUTE)) {
            string2 = element.getAttribute(CLASS_ATTRIBUTE).trim();
        }
        String string3 = null;
        if (element.hasAttribute("parent")) {
            string3 = element.getAttribute("parent");
        }
        try {
            Object object;
            String string4;
            String string5;
            this.parseState.push(new BeanEntry(string));
            AbstractBeanDefinition abstractBeanDefinition = BeanDefinitionReaderUtils.createBeanDefinition(string3, string2, this.readerContext.getReader().getBeanClassLoader());
            if (element.hasAttribute(SCOPE_ATTRIBUTE)) {
                abstractBeanDefinition.setScope(element.getAttribute(SCOPE_ATTRIBUTE));
                if (element.hasAttribute(SINGLETON_ATTRIBUTE)) {
                    this.error("Specify either 'scope' or 'singleton', not both", element);
                }
            } else if (element.hasAttribute(SINGLETON_ATTRIBUTE)) {
                abstractBeanDefinition.setSingleton(TRUE_VALUE.equals(element.getAttribute(SINGLETON_ATTRIBUTE)));
            } else if (beanDefinition != null) {
                abstractBeanDefinition.setSingleton(beanDefinition.isSingleton());
            }
            if (element.hasAttribute(ABSTRACT_ATTRIBUTE)) {
                abstractBeanDefinition.setAbstract(TRUE_VALUE.equals(element.getAttribute(ABSTRACT_ATTRIBUTE)));
            }
            if (DEFAULT_VALUE.equals(string5 = element.getAttribute(LAZY_INIT_ATTRIBUTE)) && abstractBeanDefinition.isSingleton()) {
                string5 = this.defaults.getLazyInit();
            }
            abstractBeanDefinition.setLazyInit(TRUE_VALUE.equals(string5));
            if (element.hasAttribute(AUTOWIRE_CANDIDATE_ATTRIBUTE)) {
                abstractBeanDefinition.setAutowireCandidate(TRUE_VALUE.equals(element.getAttribute(AUTOWIRE_CANDIDATE_ATTRIBUTE)));
            }
            if (DEFAULT_VALUE.equals(string4 = element.getAttribute(AUTOWIRE_ATTRIBUTE))) {
                string4 = this.defaults.getAutowire();
            }
            abstractBeanDefinition.setAutowireMode(this.getAutowireMode(string4));
            String string6 = element.getAttribute(DEPENDENCY_CHECK_ATTRIBUTE);
            if (DEFAULT_VALUE.equals(string6)) {
                string6 = this.defaults.getDependencyCheck();
            }
            abstractBeanDefinition.setDependencyCheck(this.getDependencyCheck(string6));
            if (element.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
                object = element.getAttribute(DEPENDS_ON_ATTRIBUTE);
                abstractBeanDefinition.setDependsOn(StringUtils.tokenizeToStringArray((String)object, (String)BEAN_NAME_DELIMITERS));
            }
            if (element.hasAttribute(FACTORY_METHOD_ATTRIBUTE)) {
                abstractBeanDefinition.setFactoryMethodName(element.getAttribute(FACTORY_METHOD_ATTRIBUTE));
            }
            if (element.hasAttribute(FACTORY_BEAN_ATTRIBUTE)) {
                abstractBeanDefinition.setFactoryBeanName(element.getAttribute(FACTORY_BEAN_ATTRIBUTE));
            }
            if (element.hasAttribute(INIT_METHOD_ATTRIBUTE)) {
                object = element.getAttribute(INIT_METHOD_ATTRIBUTE);
                if (!"".equals(object)) {
                    abstractBeanDefinition.setInitMethodName((String)object);
                }
            } else if (this.defaults.getInitMethod() != null) {
                abstractBeanDefinition.setInitMethodName(this.defaults.getInitMethod());
                abstractBeanDefinition.setEnforceInitMethod(false);
            }
            if (element.hasAttribute(DESTROY_METHOD_ATTRIBUTE)) {
                object = element.getAttribute(DESTROY_METHOD_ATTRIBUTE);
                if (!"".equals(object)) {
                    abstractBeanDefinition.setDestroyMethodName((String)object);
                }
            } else if (this.defaults.getDestroyMethod() != null) {
                abstractBeanDefinition.setDestroyMethodName(this.defaults.getDestroyMethod());
                abstractBeanDefinition.setEnforceDestroyMethod(false);
            }
            this.parseMetaElements(element, abstractBeanDefinition);
            this.parseLookupOverrideSubElements(element, abstractBeanDefinition.getMethodOverrides());
            this.parseReplacedMethodSubElements(element, abstractBeanDefinition.getMethodOverrides());
            this.parseConstructorArgElements(element, abstractBeanDefinition);
            this.parsePropertyElements(element, abstractBeanDefinition);
            abstractBeanDefinition.setResourceDescription(this.readerContext.getResource().getDescription());
            abstractBeanDefinition.setSource(this.extractSource(element));
            object = abstractBeanDefinition;
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.error("Bean class [" + string2 + "] not found", element, classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.error("Class that bean class [" + string2 + "] depends on not found", element, noClassDefFoundError);
        }
        catch (Throwable throwable) {
            this.error("Unexpected failure during bean definition parsing", element, throwable);
        }
        finally {
            this.parseState.pop();
        }
        return null;
    }

    public void parseMetaElements(Element element, AttributeAccessor attributeAccessor) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals((Node)node, (String)META_ELEMENT)) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute("key");
            String string2 = element2.getAttribute("value");
            attributeAccessor.setAttribute(string, (Object)string2);
        }
    }

    public int getDependencyCheck(String string) {
        int n = 0;
        if (DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE.equals(string)) {
            n = 3;
        } else if (DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE.equals(string)) {
            n = 2;
        } else if (DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE.equals(string)) {
            n = 1;
        }
        return n;
    }

    public int getAutowireMode(String string) {
        int n = 0;
        if (AUTOWIRE_BY_NAME_VALUE.equals(string)) {
            n = 1;
        } else if (AUTOWIRE_BY_TYPE_VALUE.equals(string)) {
            n = 2;
        } else if (AUTOWIRE_CONSTRUCTOR_VALUE.equals(string)) {
            n = 3;
        } else if (AUTOWIRE_AUTODETECT_VALUE.equals(string)) {
            n = 4;
        }
        return n;
    }

    public void parseConstructorArgElements(Element element, BeanDefinition beanDefinition) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals((Node)node, (String)CONSTRUCTOR_ARG_ELEMENT)) continue;
            this.parseConstructorArgElement((Element)node, beanDefinition);
        }
    }

    public void parsePropertyElements(Element element, BeanDefinition beanDefinition) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals((Node)node, (String)PROPERTY_ELEMENT)) continue;
            this.parsePropertyElement((Element)node, beanDefinition);
        }
    }

    public void parseLookupOverrideSubElements(Element element, MethodOverrides methodOverrides) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals((Node)node, (String)LOOKUP_METHOD_ELEMENT)) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute(NAME_ATTRIBUTE);
            String string2 = element2.getAttribute("bean");
            LookupOverride lookupOverride = new LookupOverride(string, string2);
            lookupOverride.setSource(this.extractSource(element2));
            methodOverrides.addOverride(lookupOverride);
        }
    }

    public void parseReplacedMethodSubElements(Element element, MethodOverrides methodOverrides) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals((Node)node, (String)REPLACED_METHOD_ELEMENT)) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute(NAME_ATTRIBUTE);
            String string2 = element2.getAttribute(REPLACER_ATTRIBUTE);
            ReplaceOverride replaceOverride = new ReplaceOverride(string, string2);
            List list = DomUtils.getChildElementsByTagName((Element)element2, (String)ARG_TYPE_ELEMENT);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                replaceOverride.addTypeIdentifier(element3.getAttribute(ARG_TYPE_MATCH_ATTRIBUTE));
            }
            replaceOverride.setSource(this.extractSource(element2));
            methodOverrides.addOverride(replaceOverride);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseConstructorArgElement(Element element, BeanDefinition beanDefinition) {
        block13: {
            String string = element.getAttribute(INDEX_ATTRIBUTE);
            String string2 = element.getAttribute(TYPE_ATTRIBUTE);
            if (StringUtils.hasLength((String)string)) {
                try {
                    int n = Integer.parseInt(string);
                    if (n < 0) {
                        this.error("'index' cannot be lower than 0", element);
                        break block13;
                    }
                    try {
                        this.parseState.push(new ConstructorArgumentEntry(n));
                        Object object = this.parsePropertyValue(element, beanDefinition, null);
                        ConstructorArgumentValues.ValueHolder valueHolder = new ConstructorArgumentValues.ValueHolder(object);
                        if (StringUtils.hasLength((String)string2)) {
                            valueHolder.setType(string2);
                        }
                        valueHolder.setSource(this.extractSource(element));
                        beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(n, valueHolder);
                    }
                    finally {
                        this.parseState.pop();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Attribute 'index' of tag 'constructor-arg' must be an integer", element);
                }
            } else {
                try {
                    this.parseState.push(new ConstructorArgumentEntry());
                    Object object = this.parsePropertyValue(element, beanDefinition, null);
                    ConstructorArgumentValues.ValueHolder valueHolder = new ConstructorArgumentValues.ValueHolder(object);
                    if (StringUtils.hasLength((String)string2)) {
                        valueHolder.setType(string2);
                    }
                    valueHolder.setSource(this.extractSource(element));
                    beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(valueHolder);
                }
                finally {
                    this.parseState.pop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsePropertyElement(Element element, BeanDefinition beanDefinition) {
        String string = element.getAttribute(NAME_ATTRIBUTE);
        if (!StringUtils.hasLength((String)string)) {
            this.error("Tag 'property' must have a 'name' attribute", element);
            return;
        }
        this.parseState.push(new PropertyEntry(string));
        try {
            if (beanDefinition.getPropertyValues().contains(string)) {
                this.error("Multiple 'property' definitions for property '" + string + "'", element);
                return;
            }
            Object object = this.parsePropertyValue(element, beanDefinition, string);
            PropertyValue propertyValue = new PropertyValue(string, object);
            this.parseMetaElements(element, (AttributeAccessor)propertyValue);
            propertyValue.setSource(this.extractSource(element));
            beanDefinition.getPropertyValues().addPropertyValue(propertyValue);
        }
        finally {
            this.parseState.pop();
        }
    }

    public Object parsePropertyValue(Element element, BeanDefinition beanDefinition, String string) {
        int n;
        String string2 = string != null ? "<property> element for property '" + string + "'" : "<constructor-arg> element";
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        for (n = 0; n < nodeList.getLength(); ++n) {
            Element element3;
            if (!(nodeList.item(n) instanceof Element) || DESCRIPTION_ELEMENT.equals((element3 = (Element)nodeList.item(n)).getTagName())) continue;
            if (element2 != null && !META_ELEMENT.equals(element2.getTagName())) {
                this.error(string2 + " must not contain more than one sub-element", element);
                continue;
            }
            element2 = element3;
        }
        n = element.hasAttribute("ref") ? 1 : 0;
        boolean bl = element.hasAttribute("value");
        if (n != 0 && bl || (n != 0 || bl) && element2 != null) {
            this.error(string2 + " is only allowed to contain either 'ref' attribute OR 'value' attribute OR sub-element", element);
        }
        if (n != 0) {
            String string3 = element.getAttribute("ref");
            if (!StringUtils.hasText((String)string3)) {
                this.error(string2 + " contains empty 'ref' attribute", element);
            }
            RuntimeBeanReference runtimeBeanReference = new RuntimeBeanReference(string3);
            runtimeBeanReference.setSource(this.extractSource(element));
            return runtimeBeanReference;
        }
        if (bl) {
            TypedStringValue typedStringValue = new TypedStringValue(element.getAttribute("value"));
            typedStringValue.setSource(this.extractSource(element));
            return typedStringValue;
        }
        if (element2 != null) {
            return this.parsePropertySubElement(element2, beanDefinition);
        }
        this.error(string2 + " must specify a ref or value", element);
        return null;
    }

    public Object parsePropertySubElement(Element element, BeanDefinition beanDefinition) {
        return this.parsePropertySubElement(element, beanDefinition, null);
    }

    public Object parsePropertySubElement(Element element, BeanDefinition beanDefinition, String string) {
        if (!this.isDefaultNamespace(element.getNamespaceURI())) {
            return this.parseNestedCustomElement(element, beanDefinition);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"bean")) {
            BeanDefinitionHolder beanDefinitionHolder = this.parseBeanDefinitionElement(element, beanDefinition);
            if (beanDefinitionHolder != null) {
                beanDefinitionHolder = this.decorateBeanDefinitionIfRequired(element, beanDefinitionHolder);
            }
            return beanDefinitionHolder;
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"ref")) {
            String string2 = element.getAttribute("bean");
            boolean bl = false;
            if (!StringUtils.hasLength((String)string2) && !StringUtils.hasLength((String)(string2 = element.getAttribute(LOCAL_REF_ATTRIBUTE)))) {
                string2 = element.getAttribute("parent");
                bl = true;
                if (!StringUtils.hasLength((String)string2)) {
                    this.error("'bean', 'local' or 'parent' is required for <ref> element", element);
                    return null;
                }
            }
            if (!StringUtils.hasText((String)string2)) {
                this.error("<ref> element contains empty target attribute", element);
                return null;
            }
            RuntimeBeanReference runtimeBeanReference = new RuntimeBeanReference(string2, bl);
            runtimeBeanReference.setSource(this.extractSource(element));
            return runtimeBeanReference;
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)IDREF_ELEMENT)) {
            String string3 = element.getAttribute("bean");
            if (!StringUtils.hasLength((String)string3) && !StringUtils.hasLength((String)(string3 = element.getAttribute(LOCAL_REF_ATTRIBUTE)))) {
                this.error("Either 'bean' or 'local' is required for <idref> element", element);
                return null;
            }
            if (!StringUtils.hasText((String)string3)) {
                this.error("<idref> element contains empty target attribute", element);
                return null;
            }
            RuntimeBeanNameReference runtimeBeanNameReference = new RuntimeBeanNameReference(string3);
            runtimeBeanNameReference.setSource(this.extractSource(element));
            return runtimeBeanNameReference;
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"value")) {
            String string4 = DomUtils.getTextValue((Element)element);
            String string5 = element.getAttribute(TYPE_ATTRIBUTE);
            if (!StringUtils.hasText((String)string5)) {
                string5 = string;
            }
            try {
                return this.buildTypedStringValue(string4, string5, element);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.error("Type class [" + string5 + "] not found for <value> element", element, classNotFoundException);
                return string4;
            }
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)NULL_ELEMENT)) {
            TypedStringValue typedStringValue = new TypedStringValue(null);
            typedStringValue.setSource(this.extractSource(element));
            return typedStringValue;
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)LIST_ELEMENT)) {
            return this.parseListElement(element, beanDefinition);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)SET_ELEMENT)) {
            return this.parseSetElement(element, beanDefinition);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)MAP_ELEMENT)) {
            return this.parseMapElement(element, beanDefinition);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)PROPS_ELEMENT)) {
            return this.parsePropsElement(element);
        }
        this.error("Unknown property sub-element: [" + element.getTagName() + "]", element);
        return null;
    }

    private Object buildTypedStringValue(String string, String string2, Element element) throws ClassNotFoundException {
        ClassLoader classLoader = this.readerContext.getReader().getBeanClassLoader();
        TypedStringValue typedStringValue = null;
        if (!StringUtils.hasText((String)string2)) {
            typedStringValue = new TypedStringValue(string);
        } else if (classLoader != null) {
            Class clazz = ClassUtils.forName((String)string2, (ClassLoader)classLoader);
            typedStringValue = new TypedStringValue(string, clazz);
        } else {
            typedStringValue = new TypedStringValue(string, string2);
        }
        typedStringValue.setSource(this.extractSource(element));
        return typedStringValue;
    }

    public List parseListElement(Element element, BeanDefinition beanDefinition) {
        String string = element.getAttribute(VALUE_TYPE_ATTRIBUTE);
        NodeList nodeList = element.getChildNodes();
        ManagedList managedList = new ManagedList(nodeList.getLength());
        managedList.setSource(this.extractSource(element));
        managedList.setMergeEnabled(this.parseMergeAttribute(element));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            managedList.add(this.parsePropertySubElement(element2, beanDefinition, string));
        }
        return managedList;
    }

    public Set parseSetElement(Element element, BeanDefinition beanDefinition) {
        String string = element.getAttribute(VALUE_TYPE_ATTRIBUTE);
        NodeList nodeList = element.getChildNodes();
        ManagedSet managedSet = new ManagedSet(nodeList.getLength());
        managedSet.setSource(this.extractSource(element));
        managedSet.setMergeEnabled(this.parseMergeAttribute(element));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            managedSet.add(this.parsePropertySubElement(element2, beanDefinition, string));
        }
        return managedSet;
    }

    public Map parseMapElement(Element element, BeanDefinition beanDefinition) {
        String string = element.getAttribute(KEY_TYPE_ATTRIBUTE);
        String string2 = element.getAttribute(VALUE_TYPE_ATTRIBUTE);
        List list = DomUtils.getChildElementsByTagName((Element)element, (String)ENTRY_ELEMENT);
        ManagedMap managedMap = new ManagedMap(list.size());
        managedMap.setMergeEnabled(this.parseMergeAttribute(element));
        managedMap.setSource(this.extractSource(element));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Element element2 = (Element)iterator.next();
            NodeList nodeList = element2.getChildNodes();
            Element element3 = null;
            Element element4 = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element)) continue;
                Element element5 = (Element)nodeList.item(i);
                if (DomUtils.nodeNameEquals((Node)element5, (String)"key")) {
                    if (element3 != null) {
                        this.error("<entry> element is only allowed to contain one <key> sub-element", element2);
                        continue;
                    }
                    element3 = element5;
                    continue;
                }
                if (element4 != null) {
                    this.error("<entry> element must not contain more than one value sub-element", element2);
                    continue;
                }
                element4 = element5;
            }
            Object object2 = null;
            boolean bl = element2.hasAttribute("key");
            boolean bl2 = element2.hasAttribute(KEY_REF_ATTRIBUTE);
            if (bl && bl2 || (bl || bl2) && element3 != null) {
                this.error("<entry> element is only allowed to contain either a 'key' attribute OR a 'key-ref' attribute OR a <key> sub-element", element2);
            }
            if (bl) {
                object2 = this.buildTypedStringValueForMap(element2.getAttribute("key"), string, element2);
            } else if (bl2) {
                object = element2.getAttribute(KEY_REF_ATTRIBUTE);
                if (!StringUtils.hasText((String)object)) {
                    this.error("<entry> element contains empty 'key-ref' attribute", element2);
                }
                RuntimeBeanReference runtimeBeanReference = new RuntimeBeanReference((String)object);
                runtimeBeanReference.setSource(this.extractSource(element3));
                object2 = runtimeBeanReference;
            } else if (element3 != null) {
                object2 = this.parseKeyElement(element3, beanDefinition, string);
            } else {
                this.error("<entry> element must specify a key", element2);
            }
            object = null;
            boolean bl3 = element2.hasAttribute("value");
            boolean bl4 = element2.hasAttribute(VALUE_REF_ATTRIBUTE);
            if (bl3 && bl4 || (bl3 || bl4) && element4 != null) {
                this.error("<entry> element is only allowed to contain either 'value' attribute OR 'value-ref' attribute OR <value> sub-element", element2);
            }
            if (bl3) {
                object = this.buildTypedStringValueForMap(element2.getAttribute("value"), string2, element2);
            } else if (bl4) {
                String string3 = element2.getAttribute(VALUE_REF_ATTRIBUTE);
                if (!StringUtils.hasText((String)string3)) {
                    this.error("<entry> element contains empty 'value-ref' attribute", element2);
                }
                RuntimeBeanReference runtimeBeanReference = new RuntimeBeanReference(string3);
                runtimeBeanReference.setSource(this.extractSource(element4));
                object = runtimeBeanReference;
            } else if (element4 != null) {
                object = this.parsePropertySubElement(element4, beanDefinition, string2);
            } else {
                this.error("<entry> element must specify a value", element2);
            }
            managedMap.put(object2, object);
        }
        return managedMap;
    }

    private Object buildTypedStringValueForMap(String string, String string2, Element element) {
        try {
            return this.buildTypedStringValue(string, string2, element);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.error("Type class [" + string2 + "] not found for Map key/value type", element, classNotFoundException);
            return string;
        }
    }

    public Object parseKeyElement(Element element, BeanDefinition beanDefinition, String string) {
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element3 = (Element)nodeList.item(i);
            if (element2 != null) {
                this.error("<key> element must not contain more than one value sub-element", element);
                continue;
            }
            element2 = element3;
        }
        return this.parsePropertySubElement(element2, beanDefinition, string);
    }

    public Properties parsePropsElement(Element element) {
        ManagedProperties managedProperties = new ManagedProperties();
        managedProperties.setSource(this.extractSource(element));
        managedProperties.setMergeEnabled(this.parseMergeAttribute(element));
        List list = DomUtils.getChildElementsByTagName((Element)element, (String)PROP_ELEMENT);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getAttribute("key");
            String string2 = DomUtils.getTextValue((Element)element2).trim();
            TypedStringValue typedStringValue = new TypedStringValue(string);
            typedStringValue.setSource(this.extractSource(element2));
            TypedStringValue typedStringValue2 = new TypedStringValue(string2);
            typedStringValue2.setSource(this.extractSource(element2));
            managedProperties.put(typedStringValue, typedStringValue2);
        }
        return managedProperties;
    }

    public boolean parseMergeAttribute(Element element) {
        String string = element.getAttribute(MERGE_ATTRIBUTE);
        if (DEFAULT_VALUE.equals(string)) {
            string = this.defaults.getMerge();
        }
        return TRUE_VALUE.equals(string);
    }

    public BeanDefinition parseCustomElement(Element element) {
        return this.parseCustomElement(element, null);
    }

    public BeanDefinition parseCustomElement(Element element, BeanDefinition beanDefinition) {
        String string = element.getNamespaceURI();
        NamespaceHandler namespaceHandler = this.readerContext.getNamespaceHandlerResolver().resolve(string);
        if (namespaceHandler == null) {
            this.error("Unable to locate NamespaceHandler for namespace [" + string + "]", element);
            return null;
        }
        return namespaceHandler.parse(element, new ParserContext(this.readerContext, this, beanDefinition));
    }

    public BeanDefinitionHolder decorateBeanDefinitionIfRequired(Element element, BeanDefinitionHolder beanDefinitionHolder) {
        BeanDefinitionHolder beanDefinitionHolder2 = beanDefinitionHolder;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            beanDefinitionHolder2 = this.decorateIfRequired(node, beanDefinitionHolder2);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            beanDefinitionHolder2 = this.decorateIfRequired(node, beanDefinitionHolder2);
        }
        return beanDefinitionHolder2;
    }

    private BeanDefinitionHolder decorateIfRequired(Node node, BeanDefinitionHolder beanDefinitionHolder) {
        String string = node.getNamespaceURI();
        BeanDefinitionHolder beanDefinitionHolder2 = null;
        if (!this.isDefaultNamespace(string)) {
            NamespaceHandler namespaceHandler = this.readerContext.getNamespaceHandlerResolver().resolve(string);
            beanDefinitionHolder2 = namespaceHandler.decorate(node, beanDefinitionHolder, new ParserContext(this.readerContext, this));
        }
        return beanDefinitionHolder2 != null ? beanDefinitionHolder2 : beanDefinitionHolder;
    }

    public boolean isDefaultNamespace(String string) {
        return !StringUtils.hasLength((String)string) || BEANS_NAMESPACE_URI.equals(string);
    }

    private BeanDefinitionHolder parseNestedCustomElement(Element element, BeanDefinition beanDefinition) {
        BeanDefinition beanDefinition2 = this.parseCustomElement(element, beanDefinition);
        if (beanDefinition2 == null) {
            this.error("Incorrect usage of element '" + element.getNodeName() + "' in a nested manner. " + "This tag cannot be used nested inside <property>.", element);
            return null;
        }
        String string = element.getNodeName() + "#" + ObjectUtils.getIdentityHexString((Object)beanDefinition2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using generated bean name [" + string + "] for nested custom element '" + element.getNodeName() + "'"));
        }
        return new BeanDefinitionHolder(beanDefinition2, string);
    }
}

