/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.SystemPropertyUtils;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private final ResourcePatternResolver resourcePatternResolver;
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    public ResourceArrayPropertyEditor() {
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    public void setAsText(String string) {
        String string2 = this.resolvePath(string).trim();
        try {
            this.setValue(this.resourcePatternResolver.getResources(string2));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + string2 + "]: " + iOException.getMessage());
        }
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (object instanceof Collection || object instanceof Object[] && !(object instanceof Resource[])) {
            List<Object> list = object instanceof Collection ? (List<Object>)object : Arrays.asList((Object[])object);
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof String) {
                    String string = this.resolvePath((String)e).trim();
                    try {
                        Resource[] resourceArray = this.resourcePatternResolver.getResources(string);
                        for (int i = 0; i < resourceArray.length; ++i) {
                            Resource resource = resourceArray[i];
                            if (arrayList.contains(resource)) continue;
                            arrayList.add(resource);
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("Could not resolve resource location pattern [" + string + "]: " + iOException.getMessage());
                    }
                }
                if (e instanceof Resource) {
                    if (arrayList.contains(e)) continue;
                    arrayList.add((Resource)e);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + e + "] to [" + (class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = ResourceArrayPropertyEditor.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource).getName() + "]: only location String and Resource object supported");
            }
            super.setValue(arrayList.toArray(new Resource[arrayList.size()]));
        } else {
            super.setValue(object);
        }
    }

    protected String resolvePath(String string) {
        return SystemPropertyUtils.resolvePlaceholders(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

