/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task;

import java.io.Serializable;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrencyThrottleSupport;
import org.springframework.util.CustomizableThreadCreator;

public class SimpleAsyncTaskExecutor
extends CustomizableThreadCreator
implements AsyncTaskExecutor,
Serializable {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(class$org$springframework$core$task$SimpleAsyncTaskExecutor == null ? (class$org$springframework$core$task$SimpleAsyncTaskExecutor = SimpleAsyncTaskExecutor.class$("org.springframework.core.task.SimpleAsyncTaskExecutor")) : class$org$springframework$core$task$SimpleAsyncTaskExecutor) + "-";
    public static final int UNBOUNDED_CONCURRENCY = -1;
    public static final int NO_CONCURRENCY = 0;
    private final ConcurrencyThrottleAdapter concurrencyThrottle = new ConcurrencyThrottleAdapter();
    static /* synthetic */ Class class$org$springframework$core$task$SimpleAsyncTaskExecutor;

    public SimpleAsyncTaskExecutor() {
    }

    public SimpleAsyncTaskExecutor(String string) {
        super(string);
    }

    public void setConcurrencyLimit(int n) {
        this.concurrencyThrottle.setConcurrencyLimit(n);
    }

    public int getConcurrencyLimit() {
        return this.concurrencyThrottle.getConcurrencyLimit();
    }

    public boolean isThrottleActive() {
        return this.concurrencyThrottle.isThrottleActive();
    }

    public void execute(Runnable runnable) {
        this.execute(runnable, Long.MAX_VALUE);
    }

    public void execute(Runnable runnable, long l) {
        Assert.notNull(runnable, "Runnable must not be null");
        if (this.isThrottleActive() && l > 0L) {
            this.concurrencyThrottle.beforeAccess();
            this.doExecute(new ConcurrencyThrottlingRunnable(runnable));
        } else {
            this.doExecute(runnable);
        }
    }

    protected void doExecute(Runnable runnable) {
        this.createThread(runnable).start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ConcurrencyThrottleAdapter
    extends ConcurrencyThrottleSupport {
        private ConcurrencyThrottleAdapter() {
        }

        protected void beforeAccess() {
            super.beforeAccess();
        }

        protected void afterAccess() {
            super.afterAccess();
        }
    }

    private class ConcurrencyThrottlingRunnable
    implements Runnable {
        private final Runnable target;

        public ConcurrencyThrottlingRunnable(Runnable runnable) {
            this.target = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.target.run();
            }
            finally {
                SimpleAsyncTaskExecutor.this.concurrencyThrottle.afterAccess();
            }
        }
    }
}

