/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.tool.communicate;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class DatagramServer {
    private byte[] buffer = new byte[1024];
    private DatagramSocket ds = null;
    private DatagramPacket packet = null;
    private InetSocketAddress socketAddress = null;

    public DatagramServer(String host, int port) throws Exception {
        this.socketAddress = new InetSocketAddress(host, port);
        this.ds = new DatagramSocket(this.socketAddress);
        System.out.println("\u6258\u76d8\u542f\u52a8!");
    }

    public final void setSoTimeout(int timeout) throws Exception {
        this.ds.setSoTimeout(timeout);
    }

    public final void bind(String host, int port) throws SocketException {
        this.socketAddress = new InetSocketAddress(host, port);
        this.ds = new DatagramSocket(this.socketAddress);
    }

    public final String receive() throws IOException {
        this.packet = new DatagramPacket(this.buffer, this.buffer.length);
        this.ds.receive(this.packet);
        String info = new String(this.packet.getData(), 0, this.packet.getLength(), "UTF-8");
        return info;
    }

    public String getPacketIp() {
        return this.packet.getAddress().getHostAddress();
    }

    public final void response(String info) throws IOException {
        DatagramPacket dp = new DatagramPacket(this.buffer, this.buffer.length, this.packet.getAddress(), this.packet.getPort());
        dp.setData(info.getBytes());
        this.ds.send(dp);
    }

    public final void setLength(int bufsize) {
        this.packet.setLength(bufsize);
    }

    public final void close() {
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

