/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.configure;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class IniProperties {
    private Properties globalProperties = new Properties();
    private String propfile;
    private Map<String, Properties> properties = new HashMap<String, Properties>();

    public void setProperyfile(String filewithpath) {
        this.propfile = filewithpath;
    }

    public void load() throws Exception {
        this.globalProperties.clear();
        this.properties.clear();
        InputStream in = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.propfile);
            if (stream != null) {
                in = new BufferedInputStream(stream);
                this.load(in);
                stream.close();
            }
        }
        finally {
            if (in != null) {
                stream.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void load(InputStream in) throws IOException {
        int bufSize = 4096;
        byte[] buffer = new byte[bufSize];
        int n = in.read(buffer, 0, bufSize);
        ParseState state = ParseState.NORMAL;
        boolean section_open = false;
        String current_section = null;
        String key = null;
        String value = null;
        StringBuilder sb = new StringBuilder();
        while (n >= 0) {
            int i = 0;
            while (i < n) {
                block23: {
                    char c;
                    block22: {
                        c = (char)buffer[i];
                        if (state != ParseState.COMMENT) break block22;
                        if (c != '\r' && c != '\n') break block23;
                        state = ParseState.NORMAL;
                    }
                    if (state == ParseState.ESCAPE) {
                        sb.append(c);
                        state = c == '\r' ? ParseState.ESC_CRNL : ParseState.NORMAL;
                    } else {
                        switch (c) {
                            case '[': {
                                sb = new StringBuilder();
                                section_open = true;
                                break;
                            }
                            case ']': {
                                if (section_open) {
                                    current_section = sb.toString().trim();
                                    sb = new StringBuilder();
                                    this.properties.put(current_section, new Properties());
                                    section_open = false;
                                    break;
                                }
                                sb.append(c);
                                break;
                            }
                            case '\\': {
                                state = ParseState.ESCAPE;
                                break;
                            }
                            case '#': 
                            case ';': {
                                state = ParseState.COMMENT;
                                break;
                            }
                            case ':': 
                            case '=': {
                                if (key == null) {
                                    key = sb.toString().trim();
                                    sb = new StringBuilder();
                                    break;
                                }
                                sb.append(c);
                                break;
                            }
                            case '\n': 
                            case '\r': {
                                if (state == ParseState.ESC_CRNL && c == '\n') {
                                    sb.append(c);
                                    state = ParseState.NORMAL;
                                    break;
                                }
                                if (sb.length() > 0) {
                                    value = sb.toString().trim();
                                    sb = new StringBuilder();
                                    if (key != null) {
                                        if (current_section == null) {
                                            this.setProperty(key, value);
                                        } else {
                                            this.setProperty(current_section, key, value);
                                        }
                                    }
                                }
                                key = null;
                                value = null;
                                break;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                    }
                }
                ++i;
            }
            n = in.read(buffer, 0, bufSize);
        }
    }

    public String getProperty(String name) {
        return this.globalProperties.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.globalProperties.setProperty(name, value);
    }

    public Iterator<String> properties() {
        return new IteratorFromEnumeration(this.globalProperties.propertyNames());
    }

    public String getProperty(String section, String name) {
        Properties p = this.properties.get(section);
        return p == null ? null : p.getProperty(name);
    }

    public void setProperty(String section, String name, String value) {
        Properties p = this.properties.get(section);
        if (p == null) {
            p = new Properties();
            this.properties.put(section, p);
        }
        p.setProperty(name, value);
    }

    public Iterator<String> properties(String section) {
        Properties p = this.properties.get(section);
        if (p == null) {
            return null;
        }
        return new IteratorFromEnumeration(p.propertyNames());
    }

    public Iterator<String> sections() {
        return this.properties.keySet().iterator();
    }

    private static String dumpEscape(String s) {
        return s.replaceAll("\\\\", "\\\\\\\\").replaceAll(";", "\\\\;").replaceAll("#", "\\\\#").replaceAll("(\r?\n|\r)", "\\\\$1");
    }

    public void store() throws IOException {
        this.store(this.propfile);
    }

    public void store(String filewithpath) throws IOException {
        try (FileOutputStream fileOut = null;){
            fileOut = new FileOutputStream(filewithpath);
            this.store(fileOut);
        }
    }

    private void store(FileOutputStream out) throws IOException {
        Iterator<String> props = this.properties();
        while (props.hasNext()) {
            String name = props.next();
            String format = String.format("%s = %s\r\n", name, IniProperties.dumpEscape(this.getProperty(name)));
            out.write(format.getBytes());
        }
        Iterator<String> sections = this.sections();
        while (sections.hasNext()) {
            String section = sections.next();
            String format = String.format("\r\n[%s]\r\n", section);
            out.write(format.getBytes());
            props = this.properties(section);
            while (props.hasNext()) {
                String name = props.next();
                format = String.format("%s = %s\r\n", name, IniProperties.dumpEscape(this.getProperty(section, name)));
                out.write(format.getBytes());
            }
        }
    }

    private static class IteratorFromEnumeration<E>
    implements Iterator {
        private Enumeration<E> e;

        public IteratorFromEnumeration(Enumeration<E> e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public E next() {
            return this.e.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't change underlying enumeration");
        }
    }

    static enum ParseState {
        NORMAL,
        ESCAPE,
        ESC_CRNL,
        COMMENT;

    }
}

