/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.enums;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.enums.Enum;

public abstract class ValuedEnum
extends Enum {
    private static final long serialVersionUID = -7129650521543789085L;
    private final int iValue;

    protected ValuedEnum(String string, int n) {
        super(string);
        this.iValue = n;
    }

    protected static Enum getEnum(Class clazz, int n) {
        if (clazz == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = Enum.getEnumList(clazz);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValuedEnum valuedEnum = (ValuedEnum)iterator.next();
            if (valuedEnum.getValue() != n) continue;
            return valuedEnum;
        }
        return null;
    }

    public final int getValue() {
        return this.iValue;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object.getClass() != this.getClass()) {
            if (object.getClass().getName().equals(this.getClass().getName())) {
                return this.iValue - this.getValueInOtherClassLoader(object);
            }
            throw new ClassCastException("Different enum class '" + ClassUtils.getShortClassName(object.getClass()) + "'");
        }
        return this.iValue - ((ValuedEnum)object).iValue;
    }

    private int getValueInOtherClassLoader(Object object) {
        try {
            Method method = object.getClass().getMethod("getValue", null);
            Integer n = (Integer)method.invoke(object, null);
            return n;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new IllegalStateException("This should not happen");
    }

    public String toString() {
        if (this.iToString == null) {
            String string = ClassUtils.getShortClassName(this.getEnumClass());
            this.iToString = string + "[" + this.getName() + "=" + this.getValue() + "]";
        }
        return this.iToString;
    }
}

