/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Match;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.StyleManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.Scene;

public final class SimpleSelector
extends Selector {
    private static final Object MAX_CLASS_DEPTH = 255;
    private final String name;
    private final List<String> styleClasses;
    private final List<String> pseudoclasses;
    private final String id;
    private final long pclassMask;
    private final boolean matchOnName;
    private final boolean matchOnId;
    private final boolean matchOnStyleClass;
    private static final Set<String> strSet = new HashSet<String>();
    private int hash = -1;

    public String getName() {
        return this.name;
    }

    public List<String> getStyleClasses() {
        return this.styleClasses;
    }

    public List<String> getPseudoclasses() {
        return this.pseudoclasses;
    }

    public String getId() {
        return this.id;
    }

    public SimpleSelector(String string, List<String> list, List<String> list2, String string2) {
        this.name = string == null ? "*" : string;
        this.matchOnName = string != null && !"".equals(string) && !"*".equals(string);
        this.styleClasses = list != null ? Collections.unmodifiableList(list) : Collections.EMPTY_LIST;
        this.matchOnStyleClass = this.styleClasses.size() > 0;
        this.pseudoclasses = list2 != null ? Collections.unmodifiableList(list2) : Collections.EMPTY_LIST;
        this.pclassMask = StyleManager.getInstance().getPseudoclassMask(list2);
        this.id = string2 == null ? "" : string2;
        this.matchOnId = string2 != null && !"".equals(string2);
    }

    @Override
    Match matches(Node node) {
        if (this.applies(node)) {
            int n = this.matchOnId ? 1 : 0;
            return new Match(this, this.pseudoclasses, n, this.styleClasses.size());
        }
        return null;
    }

    @Override
    Match matches(Scene scene) {
        if (!this.matchOnStyleClass && !this.matchOnId && this.pseudoclasses.isEmpty()) {
            boolean bl;
            String string = scene.getClass().getName();
            boolean bl2 = bl = "".equals(this.name) || this.nameMatchesAtEnd(string);
            if (bl) {
                return new Match(this, this.pseudoclasses, 0, 0);
            }
        }
        return null;
    }

    @Override
    public boolean applies(Node node) {
        String string;
        boolean bl;
        boolean bl2;
        if (this.matchOnId && !(bl2 = this.id.equals(node.getId()))) {
            return false;
        }
        if (this.matchOnName && !(bl = this.nameMatchesAtEnd(string = node.getClass().getName()))) {
            return false;
        }
        return !this.matchOnStyleClass || (bl2 = this.matchStyleClasses(node.getStyleClass()));
    }

    @Override
    boolean mightApply(String string, String string2, List<String> list) {
        if (this.matchOnName && this.nameMatchesAtEnd(string)) {
            return true;
        }
        if (this.matchOnId && this.id.equals(string2)) {
            return true;
        }
        if (this.matchOnStyleClass) {
            return this.matchStyleClasses(list);
        }
        return false;
    }

    @Override
    boolean stateMatches(Node node, long l) {
        return (this.pclassMask & l) == this.pclassMask;
    }

    private boolean nameMatchesAtEnd(String string) {
        if (!this.matchOnName) {
            return false;
        }
        int n = this.name.length();
        int n2 = string.length() - n - 1;
        if (n2 == -1 || n2 > -1 && string.charAt(n2) == '.') {
            return string.regionMatches(n2 + 1, this.name, 0, n);
        }
        return false;
    }

    private boolean matchStyleClasses(List<String> list) {
        return this.isSubsetOf(this.styleClasses, list);
    }

    boolean isSubsetOf(List<String> list, List<String> list2) {
        int n;
        if (list == null || list2 == null) {
            return list == null && list2 == null;
        }
        if (list.isEmpty() && list2.isEmpty()) {
            return true;
        }
        if (list.size() > list2.size()) {
            return false;
        }
        if (list.size() == 1) {
            String string = list.get(0);
            if (string == null) {
                return false;
            }
            int n2 = list2.size();
            for (int i = 0; i < n2; ++i) {
                String string2 = list2.get(i);
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }
        strSet.clear();
        int n3 = list2.size();
        for (n = 0; n < n3; ++n) {
            strSet.add(list2.get(n));
        }
        n3 = list.size();
        for (n = 0; n < n3; ++n) {
            if (strSet.contains(list.get(n))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleSelector simpleSelector = (SimpleSelector)object;
        if (this.pclassMask != simpleSelector.pclassMask) {
            return false;
        }
        if (this.name == null ? simpleSelector.name != null : !this.name.equals(simpleSelector.name)) {
            return false;
        }
        if (this.id == null ? simpleSelector.id != null : !this.id.equals(simpleSelector.id)) {
            return false;
        }
        return this.styleClasses == simpleSelector.styleClasses || this.styleClasses != null && ((Object)this.styleClasses).equals(simpleSelector.styleClasses);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.name.hashCode();
            this.hash = 31 * (this.hash + ((Object)this.styleClasses).hashCode());
            this.hash = 31 * (this.hash + (this.id != null ? this.id.hashCode() : 1229));
            this.hash = 31 * (int)(this.pclassMask ^ this.pclassMask >>> 32);
        }
        return this.hash;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            stringBuilder.append(this.name);
        } else {
            stringBuilder.append("*");
        }
        for (n = 0; n < this.styleClasses.size(); ++n) {
            stringBuilder.append('.');
            stringBuilder.append(this.styleClasses.get(n));
        }
        if (this.id != null && !this.id.isEmpty()) {
            stringBuilder.append('#');
            stringBuilder.append(this.id);
        }
        for (n = 0; n < this.pseudoclasses.size(); ++n) {
            stringBuilder.append(':');
            stringBuilder.append(this.pseudoclasses.get(n));
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        super.writeBinary(dataOutputStream, stringStore);
        dataOutputStream.writeShort(stringStore.addString(this.name));
        dataOutputStream.writeShort(this.styleClasses.size());
        for (String string : this.styleClasses) {
            dataOutputStream.writeShort(stringStore.addString(string));
        }
        dataOutputStream.writeShort(stringStore.addString(this.id));
        dataOutputStream.writeShort(this.pseudoclasses.size());
        for (String string : this.pseudoclasses) {
            dataOutputStream.writeShort(stringStore.addString(string));
        }
    }

    static SimpleSelector readBinary(int n, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string = stringArray[dataInputStream.readShort()];
        int n2 = dataInputStream.readShort();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(stringArray[dataInputStream.readShort()]);
        }
        String string2 = stringArray[dataInputStream.readShort()];
        int n3 = dataInputStream.readShort();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n3; ++i) {
            arrayList2.add(stringArray[dataInputStream.readShort()]);
        }
        return new SimpleSelector(string, arrayList, arrayList2, string2);
    }
}

