/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.web.skin;

import com.sun.javafx.css.StyleManager;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;

public final class ColorPicker
extends VBox {
    private GridPane colorGridContent;
    private HBox webNameHBox;
    private static final int SQUARE_SIZE = 12;
    private static final int NUM_OF_COLUMNS = 8;
    private static final int COLOR_GRID_WIDTH = 96;
    private ObservableList<ColorSquare> squares;
    public static final ObservableList<String> colorNames;
    private boolean initialized = false;
    private boolean updateModel = true;
    private TextField webTextField;
    private Rectangle valuePreview;
    int[] rawValues = new int[]{0, 10105600, 0x333300, 13056, 13158, 128, 0x33339A, 0x333333, 0x800000, 0xFF6600, 0x808000, 32768, 32896, 255, 0x666699, 0x808080, 0xFF0000, 0xFF9900, 0x99CC00, 3184998, 0x30CCCC, 0x3366FF, 0x800080, 0x999999, 0xFF00FF, 0xFFCC00, 0xFFFF00, 65280, 65535, 52479, 10105702, 0xC0C0C0, 0xFF99CC, 0xFFCC99, 0xFFFF99, 0xCCFFCC, 0xCCFFFF, 0x99CCFF, 0xCC99FF, 0xFFFFFF};
    private ObjectProperty<Color> colorProperty = new SimpleObjectProperty<Color>(this, "color");
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty<EventHandler<ActionEvent>>(){

        @Override
        protected void invalidated() {
            ColorPicker.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return ColorPicker.this;
        }

        @Override
        public String getName() {
            return "onAction";
        }
    };

    ColorPicker() {
        this.getStyleClass().add("color-picker");
        this.squares = FXCollections.observableArrayList();
        int n = this.rawValues.length;
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = Color.rgb(this.rawValues[i] >> 16, this.rawValues[i] >> 8 & 0xFF, this.rawValues[i] & 0xFF, 1.0);
            ColorSquare colorSquare = new ColorSquare(colorArray[i]);
            this.squares.add(colorSquare);
        }
        this.valuePreview = new Rectangle(13.0, 13.0);
        this.valuePreview.getStyleClass().add("preview-square");
        this.valuePreview.setSmooth(false);
        ColorPicker colorPicker = this;
        if (this.colorGridContent == null) {
            this.colorGridContent = this.makeColorGridContent();
        }
        if (this.webNameHBox == null) {
            this.initialized = false;
            this.webNameHBox = new HBox(5.0);
            this.webNameHBox.setAlignment(Pos.CENTER);
            this.webTextField = new TextField();
            this.webTextField.setPrefColumnCount(8);
            this.webTextField.setText("");
            this.webTextField.setId("ColorChooserWebTextField");
            this.webTextField.textProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    String string;
                    if (ColorPicker.this.updateModel && (string = ColorPicker.this.webTextField.getText()).length() >= (string.startsWith("#") ? 7 : 1)) {
                        try {
                            ColorPicker.this.getValuePreview().setFill(Color.web(string));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.webTextField.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    String string;
                    if (ColorPicker.this.updateModel && (string = ColorPicker.this.webTextField.getText()).length() >= (string.startsWith("#") ? 7 : 1)) {
                        try {
                            ColorPicker.this.setColor(Color.web(string));
                            ColorPicker.this.fireEvent(new ActionEvent());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.webNameHBox.getChildren().addAll((Node[])new Node[]{this.getValuePreview(), this.webTextField});
            this.initialized = true;
            if (this.getColor() != null) {
                this.setValue(this.getColor());
            }
            this.webNameHBox.setPrefWidth(96.0);
        }
        colorPicker.getChildren().addAll((Node[])new Node[]{this.colorGridContent, this.webNameHBox});
    }

    private GridPane makeColorGridContent() {
        GridPane gridPane = new GridPane();
        int n = 0;
        int n2 = 0;
        for (ColorSquare colorSquare : this.squares) {
            gridPane.add(colorSquare, n, n2);
            if (++n != 8) continue;
            n = 0;
            ++n2;
        }
        return gridPane;
    }

    public boolean setValue(Object object) {
        boolean bl;
        if (this.squares != null) {
            for (ColorSquare object2 : this.squares) {
                object2.setSelected(object2.rect.getFill().equals(object));
            }
        }
        if (this.initialized) {
            Color color = (Color)object;
            this.getValuePreview().setFill(color);
            this.updateModel = false;
            this.webTextField.setText(ColorPicker.colorValueToWeb(color));
            this.updateModel = true;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    static String colorValueToWeb(Color color) {
        String string = null;
        if (colorNames != null) {
            for (String string2 : colorNames) {
                if (!Color.web(string2, color.getOpacity()).equals(color)) continue;
                string = string2;
                break;
            }
        }
        if (string == null) {
            string = ColorPicker.colorValueToHex(color);
        }
        return string;
    }

    static String colorValueToHex(Color color) {
        return String.format((Locale)null, "#%02x%02x%02x", Math.round(color.getRed() * 255.0), Math.round(color.getGreen() * 255.0), Math.round(color.getBlue() * 255.0));
    }

    public Color getColor() {
        return (Color)this.colorProperty.getValue();
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.colorProperty.setValue(color);
        this.setValue(this.getColor());
    }

    public ObjectProperty<Color> colorProperty() {
        return this.colorProperty;
    }

    public Rectangle getValuePreview() {
        return this.valuePreview;
    }

    private Color getValue() {
        String string = this.webTextField.getText();
        if (string != null && string.length() > 0) {
            try {
                return Color.web(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Color.BLACK;
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    static {
        Color.web("white", 1.0);
        colorNames = FXCollections.observableArrayList();
        for (Field field : Color.class.getDeclaredFields()) {
            int n = field.getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isPublic(n) || !field.getType().equals(Color.class)) continue;
            colorNames.add(field.getName().toLowerCase());
        }
        FXCollections.sort(colorNames);
    }

    class ColorSquare
    extends StackPane {
        Rectangle rect;
        private ReadOnlyBooleanWrapper selected;
        private final long SELECTED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("selected");

        ColorSquare(Color color) {
            this.getStyleClass().add("color-square");
            this.setFocusTraversable(true);
            this.rect = new Rectangle(12.0, 12.0);
            this.rect.setFill(color);
            this.rect.setSmooth(false);
            this.getChildren().add(this.rect);
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1 && !MouseEvent.impl_getPopupTrigger(mouseEvent)) {
                        ColorPicker.this.setColor(ColorPicker.this.getValue());
                        mouseEvent.consume();
                        ColorSquare.this.setHover(false);
                        ColorSquare.this.fireEvent(new ActionEvent());
                    }
                }
            });
            this.hoverProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    ColorPicker.this.updateModel = false;
                    Color color = ColorSquare.this.isHover() ? (Color)ColorSquare.this.rect.getFill() : ColorPicker.this.getColor();
                    ColorPicker.this.webTextField.setText(ColorPicker.colorValueToWeb(color));
                    ColorPicker.this.getValuePreview().setFill(color);
                    ColorSquare.this.requestFocus();
                    ColorPicker.this.updateModel = true;
                }
            });
        }

        protected final void setSelected(boolean bl) {
            this.selectedPropertyImpl().set(bl);
        }

        public final boolean isSelected() {
            return this.selected == null ? false : this.selected.get();
        }

        public ReadOnlyBooleanProperty selectedProperty() {
            return this.selectedPropertyImpl().getReadOnlyProperty();
        }

        private ReadOnlyBooleanWrapper selectedPropertyImpl() {
            if (this.selected == null) {
                this.selected = new ReadOnlyBooleanWrapper(){

                    @Override
                    protected void invalidated() {
                        ColorSquare.this.impl_pseudoClassStateChanged("selected");
                    }

                    @Override
                    public Object getBean() {
                        return ColorSquare.this;
                    }

                    @Override
                    public String getName() {
                        return "selected";
                    }
                };
            }
            return this.selected;
        }

        @Override
        protected double computePrefWidth(double d) {
            return 18.0;
        }

        @Override
        protected double computePrefHeight(double d) {
            return 18.0;
        }

        @Override
        public long impl_getPseudoClassState() {
            return super.impl_getPseudoClassState() | (this.isSelected() ? this.SELECTED_PSEUDOCLASS_STATE : 0L);
        }
    }
}

