/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.management.jdp.JdpException;
import sun.management.jdp.JdpGenericPacket;

public final class JdpPacketReader {
    private final DataInputStream pkt;
    private Map<String, String> pmap = null;

    public JdpPacketReader(byte[] byArray) throws JdpException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.pkt = new DataInputStream(byteArrayInputStream);
        try {
            int s = this.pkt.readInt();
            JdpGenericPacket.checkMagic(s);
        }
        catch (IOException iOException) {
            throw new JdpException("Invalid JDP packet received, bad magic");
        }
        try {
            short iOException = this.pkt.readShort();
            JdpGenericPacket.checkVersion(iOException);
        }
        catch (IOException iOException) {
            throw new JdpException("Invalid JDP packet received, bad protocol version");
        }
    }

    public String getEntry() throws EOFException, JdpException {
        try {
            short s = this.pkt.readShort();
            if (s < 1 && s > this.pkt.available()) {
                throw new JdpException("Broken JDP packet. Invalid entry length field.");
            }
            byte[] byArray = new byte[s];
            if (this.pkt.read(byArray) != s) {
                throw new JdpException("Broken JDP packet. Unable to read entry.");
            }
            return new String(byArray, "UTF-8");
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JdpException("Broken JDP packet. Unable to decode entry.");
        }
        catch (IOException iOException) {
            throw new JdpException("Broken JDP packet. Unable to read entry.");
        }
    }

    public Map<String, String> getDiscoveryDataAsMap() throws JdpException {
        if (this.pmap != null) {
            return this.pmap;
        }
        String string = null;
        String string2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            while (true) {
                string = this.getEntry();
                string2 = this.getEntry();
                hashMap.put(string, string2);
            }
        }
        catch (EOFException eOFException) {
            if (string2 == null) {
                throw new JdpException("Broken JDP packet. Key without value." + string);
            }
            this.pmap = Collections.unmodifiableMap(hashMap);
            return this.pmap;
        }
    }
}

