/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.NativeError;
import sun.org.mozilla.javascript.internal.RhinoException;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;

public class JavaScriptException
extends RhinoException {
    static final long serialVersionUID = -7666130513694669293L;
    private Object value;

    public JavaScriptException(Object object) {
        this(object, "", 0);
    }

    public JavaScriptException(Object object, String string, int n) {
        this.recordErrorOrigin(string, n, null, 0);
        this.value = object;
        if (object instanceof NativeError && Context.getContext().hasFeature(10)) {
            NativeError nativeError = (NativeError)object;
            if (!nativeError.has("fileName", (Scriptable)nativeError)) {
                nativeError.put("fileName", (Scriptable)nativeError, (Object)string);
            }
            if (!nativeError.has("lineNumber", (Scriptable)nativeError)) {
                nativeError.put("lineNumber", (Scriptable)nativeError, (Object)n);
            }
            nativeError.setStackProvider(this);
        }
    }

    @Override
    public String details() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof NativeError) {
            return this.value.toString();
        }
        try {
            return ScriptRuntime.toString(this.value);
        }
        catch (RuntimeException runtimeException) {
            if (this.value instanceof Scriptable) {
                return ScriptRuntime.defaultObjectToString((Scriptable)this.value);
            }
            return this.value.toString();
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String getSourceName() {
        return this.sourceName();
    }

    public int getLineNumber() {
        return this.lineNumber();
    }
}

