/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.AutoUpdater;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.PlatformFactory;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.IcoEncoder;
import com.sun.deploy.util.IconEncoder;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public abstract class Platform {
    private static final boolean DEBUG = Config.getDeployDebug() || Config.getPluginDebug();
    private static Platform _platform;
    private Collection fx_runtimes = null;
    protected static final String UPGRADE_FILENAME = "CacheUpgrade.properties";
    protected AutoUpdater auInstance;
    protected IconEncoder ieInstance;

    public static void setInstance(Platform platform) {
        _platform = platform;
    }

    public static Platform get() {
        if (_platform == null) {
            Platform.setInstance(PlatformFactory.newInstance());
        }
        return _platform;
    }

    public abstract void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public abstract void cacheSecurityBaseline(String var1, String var2);

    public abstract void addRemoveProgramsRemove(String var1, boolean var2);

    public abstract boolean canAutoDownloadJRE();

    public boolean canUseAlternateJREs() {
        return true;
    }

    public abstract String getBrowserPath();

    public abstract String getBrowserHomePath();

    public abstract String getDefaultSystemCache();

    public abstract String getFireFoxUserProfileDirectory();

    public abstract boolean canBecomeAdmin();

    public abstract boolean hasAdminPrivileges();

    public abstract Vector getInstalledJREList();

    public abstract String getLibrarySufix();

    public abstract String getLibraryPrefix();

    public abstract String getMozillaUserProfileDirectory();

    public abstract long getNativePID();

    public abstract String getSessionSpecificString();

    public abstract String getSystemJavawsPath();

    public abstract int[] getIconSizes();

    public abstract int getSystemShortcutIconSize(boolean var1);

    public abstract int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract String getShortcutJnlpName(String var1);

    public abstract boolean isBrowserFireFox();

    public abstract boolean isLocalInstallSupported();

    public abstract boolean isNativeModalDialogUp();

    public abstract boolean isPlatformIconType(String var1);

    public abstract boolean isPlatformWindowsVista();

    public abstract void loadDeployNativeLib();

    public abstract void sendJFXPing(String var1, String var2, String var3, String var4, String var5, int var6, String var7);

    public abstract void setUserHomeOverride(String var1);

    public abstract boolean showDocument(String var1);

    public abstract boolean getJqsSettings();

    public abstract void setJqsSettings(boolean var1);

    public abstract boolean getJavaPluginSettings();

    public abstract int setJavaPluginSettings(boolean var1);

    public boolean getSponsorOffersDisabledSettings() {
        return false;
    }

    public void enableSponsorOffering(boolean bl) {
    }

    public abstract void initBrowserSettings();

    public abstract int applyBrowserSettings();

    public abstract boolean systemLookAndFeelDefault();

    public abstract String getUserHome();

    public String getLocalStorageDir() {
        return this.getUserHome();
    }

    public abstract void cacheCurrentConfig(Properties var1);

    public abstract String getUserHomeOverride();

    public abstract String getOSHome();

    public abstract String getSystemHome();

    public abstract String getPlatformSpecificJavaName();

    public abstract String getPlatformExtension();

    public abstract String getDebugJavaPath(String var1);

    public abstract String getLongPathName(String var1);

    public abstract boolean samePaths(String var1, String var2);

    public abstract int getPlatformMaxCommandLineLength();

    public abstract boolean useAltFileSystemView();

    public abstract String toExecArg(String var1);

    public abstract void onLoad(Object var1);

    public abstract void onSave(Object var1);

    public abstract boolean shouldPromptForAutoCheck();

    public abstract void handleUserResponse(int var1);

    public abstract void resetJavaHome();

    public abstract String findSecureLauncher();

    void setDefaultConfigProperties(DefaultConfig defaultConfig) {
    }

    public String getJucheckPath() {
        return null;
    }

    private boolean addJfxRuntimeIfValid(Collection collection, String string) {
        if (string == null) {
            return false;
        }
        JfxRuntime jfxRuntime = JfxRuntime.runtimeForPath(string);
        if (jfxRuntime != null) {
            collection.add(jfxRuntime);
            return true;
        }
        return false;
    }

    public JfxRuntime getStandaloneJfxRuntime() {
        return null;
    }

    protected Collection detectInstalledJfxRuntimes() {
        LinkedList<JfxRuntime> linkedList = new LinkedList<JfxRuntime>();
        if (this.addJfxRuntimeIfValid(linkedList, Environment.getenv("FORCED_FX_ROOT"))) {
            return linkedList;
        }
        if (this.addJfxRuntimeIfValid(linkedList, System.getProperty("java.home"))) {
            return linkedList;
        }
        JfxRuntime jfxRuntime = this.getStandaloneJfxRuntime();
        if (jfxRuntime != null) {
            linkedList.add(jfxRuntime);
        }
        return linkedList;
    }

    public Collection getInstalledJfxRuntimes() {
        return this.getInstalledJfxRuntimes(false);
    }

    public Collection getInstalledJfxRuntimes(boolean bl) {
        if (bl || null == this.fx_runtimes) {
            this.fx_runtimes = Collections.unmodifiableCollection(this.detectInstalledJfxRuntimes());
            if (DEBUG) {
                System.out.println(this.fx_runtimes.size() + " JavaFX runtime found.");
                Iterator iterator = this.fx_runtimes.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    JfxRuntime jfxRuntime = (JfxRuntime)iterator.next();
                    System.out.println("  " + ++n + ") " + jfxRuntime.toString());
                }
            }
        }
        return this.fx_runtimes;
    }

    public String getPlatformNativeEncoding() {
        return "UTF-8";
    }

    public JfxRuntime getBestJfxRuntime(VersionID versionID) {
        String string;
        if (DEBUG) {
            System.out.println("Looking for best JavaFX runtime for " + versionID + " ...");
        }
        if ((string = Environment.getenv("FORCED_FX_ROOT")) != null) {
            return JfxRuntime.runtimeForPath(string);
        }
        if (null == versionID) {
            versionID = new VersionID("2.0+");
        }
        JfxRuntime jfxRuntime = null;
        Iterator iterator = this.getInstalledJfxRuntimes().iterator();
        while (iterator.hasNext()) {
            JfxRuntime jfxRuntime2 = (JfxRuntime)iterator.next();
            VersionID versionID2 = jfxRuntime2.getProductVersion();
            if (DEBUG) {
                System.out.println("Test " + jfxRuntime2);
            }
            if (versionID.equals(versionID2)) {
                if (DEBUG) {
                    System.out.println("Perfect match: " + jfxRuntime2);
                }
                return jfxRuntime2;
            }
            if (!versionID.match(versionID2)) continue;
            if (DEBUG) {
                System.out.println("A match: " + jfxRuntime2);
            }
            if (jfxRuntime != null && !jfxRuntime2.getProductVersion().isGreaterThan(jfxRuntime.getProductVersion())) continue;
            jfxRuntime = jfxRuntime2;
            if (!DEBUG) continue;
            System.out.println("A better match: " + jfxRuntime);
        }
        return jfxRuntime;
    }

    public void storeCacheUpgradeInfo(final Properties properties) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    if (properties == null) {
                        File file = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (file.exists()) {
                            file.delete();
                        }
                        return null;
                    }
                    OutputStream outputStream = null;
                    try {
                        Properties properties2 = Platform.this.getCacheUpgradeProperties();
                        properties2.putAll((Map<?, ?>)properties);
                        File file = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        outputStream = new FileOutputStream(file);
                        properties2.store(outputStream, "");
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException, true);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    public Properties getCacheUpgradeInfo(String[] stringArray) {
        Properties properties = this.getCacheUpgradeProperties();
        Properties properties2 = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = properties.getProperty(stringArray[i]);
            if (string == null) continue;
            properties2.put(stringArray[i], string);
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getCacheUpgradeProperties() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            final File file = new File(this.getUserHome(), UPGRADE_FILENAME);
            inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (file.isFile()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
            });
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException, true);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
        }
        return properties;
    }

    public abstract String getLoadedNativeLibPath(String var1);

    public synchronized AutoUpdater getAutoUpdater() {
        if (this.auInstance == null) {
            this.auInstance = new AutoUpdater();
        }
        return this.auInstance;
    }

    public synchronized IconEncoder getIconEncoder() {
        if (this.ieInstance == null) {
            this.ieInstance = new IcoEncoder();
        }
        return this.ieInstance;
    }

    public String getPlatformIconType() {
        return "ico";
    }

    public boolean isGTKAvailable(int n, int n2, int n3) {
        return false;
    }

    public String getDefaultIconPath() {
        return null;
    }

    public Properties getPendingConfigProperties() {
        return null;
    }

    public Process startProcessBuilder(ProcessBuilder processBuilder) throws IOException {
        return processBuilder.start();
    }

    public void verifyPermissionsForFileSystem() {
    }

    long getUserDeploymentPropCacheTimestamp() {
        return -1L;
    }

    long getSysDeploymentPropCacheTimestamp() {
        return -1L;
    }

    public abstract WebJavaSwitch getWebJavaSwitch();

    public static abstract class WebJavaSwitch {
        protected abstract void setSystemWebJavaEnabled(boolean var1);

        protected abstract boolean isSystemWebJavaEnabled();

        public WebJavaState queryWebJavaState() {
            if (!this.isSystemWebJavaEnabled()) {
                return WebJavaState.DISABLED;
            }
            if (!this.isUserWebJavaEnabled()) {
                return WebJavaState.USER_DISABLED;
            }
            return WebJavaState.ENABLED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWebJavaEnabled(boolean bl) {
            try {
                this.setUserWebJavaEnabled(bl);
            }
            finally {
                this.setSystemWebJavaEnabled(bl);
            }
        }

        private void setUserWebJavaEnabled(boolean bl) {
            String string = "undefined";
            if (OSType.isUnix() && !Platform.get().isGTKAvailable(2, 14, 0)) {
                string = bl ? "later" : "block";
            }
            Config.setStringProperty("deployment.expiration.decision." + SecurityBaseline.getDeployNoBuildVersion(), string);
            Config.setBooleanProperty("deployment.webjava.enabled", bl);
            Config.get().storeIfNeeded();
        }

        private boolean isUserWebJavaEnabled() {
            boolean bl;
            String string = "deployment.expiration.decision." + SecurityBaseline.getDeployNoBuildVersion();
            boolean bl2 = "block".equals(Config.getStringProperty(string));
            boolean bl3 = Config.getBooleanProperty("deployment.webjava.enabled");
            if (bl3 != (bl = this.isSystemWebJavaEnabled())) {
                long l = Platform.get().getUserDeploymentPropCacheTimestamp();
                long l2 = Platform.get().getSysDeploymentPropCacheTimestamp();
                if (l != -1L && l2 != -1L && l2 >= l) {
                    this.setUserWebJavaEnabled(bl);
                    bl3 = bl;
                }
            }
            return bl3 && !bl2;
        }

        public boolean isWebJavaEnabled() {
            return this.queryWebJavaState() == WebJavaState.ENABLED;
        }

        public static final class WebJavaState {
            public static final WebJavaState ENABLED = new WebJavaState();
            public static final WebJavaState DISABLED = new WebJavaState();
            public static final WebJavaState USER_DISABLED = new WebJavaState();

            private WebJavaState() {
            }
        }
    }
}

