/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DomUtils {
    public static List getChildElementsByTagName(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, string)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public static Element getChildElementByTagName(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, string)) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getChildElementValueByTagName(Element element, String string) {
        Element element2 = DomUtils.getChildElementByTagName(element, string);
        return element2 != null ? DomUtils.getTextValue(element2) : null;
    }

    public static boolean nodeNameEquals(Node node, String string) {
        Assert.notNull(node, "Node must not be null");
        Assert.notNull(string, "Desired name must not be null");
        return string.equals(node.getNodeName()) || string.equals(node.getLocalName());
    }

    public static String getTextValue(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if ((!(node instanceof CharacterData) || node instanceof Comment) && !(node instanceof EntityReference)) continue;
            stringBuffer.append(node.getNodeValue());
        }
        return stringBuffer.toString();
    }
}

