/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.parsing;

import java.util.ArrayList;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.parsing.ComponentDefinition;

public class BeanComponentDefinition
extends BeanDefinitionHolder
implements ComponentDefinition {
    private BeanDefinition[] innerBeanDefinitions;
    private BeanReference[] beanReferences;

    public BeanComponentDefinition(BeanDefinition beanDefinition, String string) {
        super(beanDefinition, string);
        this.findInnerBeanDefinitionsAndBeanReferences(beanDefinition);
    }

    public BeanComponentDefinition(BeanDefinitionHolder beanDefinitionHolder) {
        super(beanDefinitionHolder);
        this.findInnerBeanDefinitionsAndBeanReferences(beanDefinitionHolder.getBeanDefinition());
    }

    private void findInnerBeanDefinitionsAndBeanReferences(BeanDefinition beanDefinition) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        MutablePropertyValues mutablePropertyValues = beanDefinition.getPropertyValues();
        for (int i = 0; i < mutablePropertyValues.getPropertyValues().length; ++i) {
            PropertyValue propertyValue = mutablePropertyValues.getPropertyValues()[i];
            Object object = propertyValue.getValue();
            if (object instanceof BeanDefinitionHolder) {
                arrayList.add(((BeanDefinitionHolder)object).getBeanDefinition());
                continue;
            }
            if (object instanceof BeanDefinition) {
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof BeanReference)) continue;
            arrayList2.add(object);
        }
        this.innerBeanDefinitions = arrayList.toArray(new BeanDefinition[arrayList.size()]);
        this.beanReferences = arrayList2.toArray(new BeanReference[arrayList2.size()]);
    }

    public String getName() {
        return this.getBeanName();
    }

    public String getDescription() {
        return this.getShortDescription();
    }

    public BeanDefinition[] getBeanDefinitions() {
        return new BeanDefinition[]{this.getBeanDefinition()};
    }

    public BeanDefinition[] getInnerBeanDefinitions() {
        return this.innerBeanDefinitions;
    }

    public BeanReference[] getBeanReferences() {
        return this.beanReferences;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof BeanComponentDefinition && super.equals(object);
    }
}

