/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.daemon.ClientHandler;
import com.sun.jmx.snmp.daemon.CommunicationException;
import com.sun.jmx.snmp.daemon.CommunicatorServerMBean;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;

public abstract class CommunicatorServer
implements Runnable,
MBeanRegistration,
NotificationBroadcaster,
CommunicatorServerMBean {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    public static final int SNMP_TYPE = 4;
    volatile transient int state = 1;
    ObjectName objectName;
    MBeanServer topMBS;
    MBeanServer bottomMBS;
    transient String dbgTag = null;
    int maxActiveClientCount = 1;
    transient int servedClientCount = 0;
    String host = null;
    int port = -1;
    private transient Object stateLock = new Object();
    private transient Vector<ClientHandler> clientHandlerVector = new Vector();
    private transient Thread fatherThread = Thread.currentThread();
    private transient Thread mainThread = null;
    private volatile boolean stopRequested = false;
    private boolean interrupted = false;
    private transient Exception startException = null;
    private transient long notifCount = 0L;
    private transient NotificationBroadcasterSupport notifBroadcaster = new NotificationBroadcasterSupport();
    private transient MBeanNotificationInfo[] notifInfos = null;

    public CommunicatorServer(int n) throws IllegalArgumentException {
        switch (n) {
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connector Type");
            }
        }
        this.dbgTag = this.makeDebugTag();
    }

    protected Thread createMainThread() {
        return new Thread((Runnable)this, this.makeThreadName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long l) throws CommunicationException, InterruptedException {
        boolean bl;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                this.waitState(1, 60000L);
            }
            boolean bl2 = bl = this.state == 1;
            if (bl) {
                this.changeState(3);
                this.stopRequested = false;
                this.interrupted = false;
                this.startException = null;
            }
        }
        if (!bl) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "start", "Connector is not OFFLINE");
            }
            return;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "start", "--> Start connector ");
        }
        this.mainThread = this.createMainThread();
        this.mainThread.start();
        if (l > 0L) {
            this.waitForStart(l);
        }
    }

    @Override
    public void start() {
        block2: {
            try {
                this.start(0L);
            }
            catch (InterruptedException interruptedException) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) break block2;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "start", "interrupted", interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1 || this.state == 2) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "Connector is not ONLINE");
                }
                return;
            }
            this.changeState(2);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "Interrupt main thread");
            }
            this.stopRequested = true;
            if (!this.interrupted) {
                this.interrupted = true;
                this.mainThread.interrupt();
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "terminateAllClient");
        }
        this.terminateAllClient();
        object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                this.changeState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitState(int n, long l) {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", n + "(0on,1off,2st) TO=" + l + " ; current state = " + this.getStateString());
        }
        long l2 = 0L;
        if (l > 0L) {
            l2 = System.currentTimeMillis() + l;
        }
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state != n) {
                if (l < 0L) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) return false;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", "timeOut < 0, return without wait");
                    return false;
                }
                try {
                    if (l > 0L) {
                        long l3 = l2 - System.currentTimeMillis();
                        if (l3 <= 0L) {
                            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) return false;
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", "timed out");
                            return false;
                        }
                        this.stateLock.wait(l3);
                        continue;
                    }
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", "wait interrupted");
                    }
                    if (this.state != n) return false;
                    return true;
                }
            }
            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) return true;
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", "returning in desired state");
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForStart(long l) throws CommunicationException, InterruptedException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitForStart", "Timeout=" + l + " ; current state = " + this.getStateString());
        }
        long l2 = System.currentTimeMillis();
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state == 3) {
                long l3 = System.currentTimeMillis() - l2;
                long l4 = l - l3;
                if (l4 < 0L) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitForStart", "timeout < 0, return without wait");
                    }
                    throw new InterruptedException("Timeout expired");
                }
                try {
                    this.stateLock.wait(l4);
                }
                catch (InterruptedException interruptedException) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitForStart", "wait interrupted");
                    }
                    if (this.state == 0) continue;
                    throw interruptedException;
                }
            }
            if (this.state == 0) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitForStart", "started");
                }
                return;
            }
            if (this.startException instanceof CommunicationException) {
                throw (CommunicationException)this.startException;
            }
            if (this.startException instanceof InterruptedException) {
                throw (InterruptedException)this.startException;
            }
            if (this.startException != null) {
                throw new CommunicationException(this.startException, "Failed to start: " + this.startException);
            }
            throw new CommunicationException("Failed to start: state is " + CommunicatorServer.getStringForState(this.state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public String getStateString() {
        return CommunicatorServer.getStringForState(this.state);
    }

    @Override
    public String getHost() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.host = "Unknown host";
        }
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPort() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPort(int n) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.port = n;
            this.dbgTag = this.makeDebugTag();
        }
    }

    @Override
    public abstract String getProtocol();

    int getServedClientCount() {
        return this.servedClientCount;
    }

    int getActiveClientCount() {
        int n = this.clientHandlerVector.size();
        return n;
    }

    int getMaxActiveClientCount() {
        return this.maxActiveClientCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxActiveClientCount(int n) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.maxActiveClientCount = n;
        }
    }

    void notifyClientHandlerCreated(ClientHandler clientHandler) {
        this.clientHandlerVector.addElement(clientHandler);
    }

    synchronized void notifyClientHandlerDeleted(ClientHandler clientHandler) {
        this.clientHandlerVector.removeElement(clientHandler);
        this.notifyAll();
    }

    protected int getBindTries() {
        return 50;
    }

    protected long getBindSleepTime() {
        return 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        boolean bl = false;
        try {
            int n2 = this.getBindTries();
            long l = this.getBindSleepTime();
            while (n < n2 && !bl) {
                try {
                    this.doBind();
                    bl = true;
                }
                catch (CommunicationException communicationException) {
                    ++n;
                    Thread.sleep(l);
                }
            }
            if (!bl) {
                this.doBind();
            }
        }
        catch (Exception exception) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "run", "Got unexpected exception", exception);
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.startException = exception;
                this.changeState(1);
            }
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "run", "State is OFFLINE");
            }
            this.doError(exception);
            return;
        }
        try {
            this.changeState(0);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "run", "State is ONLINE");
            }
            while (!this.stopRequested) {
                ++this.servedClientCount;
                this.doReceive();
                this.waitIfTooManyClients();
                this.doProcess();
            }
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "run", "Stop has been requested");
            }
        }
        catch (InterruptedException interruptedException) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "run", "Interrupt caught");
            }
            this.changeState(2);
        }
        catch (Exception exception) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "run", "Got unexpected exception", exception);
            }
            this.changeState(2);
        }
        finally {
            Object object = this.stateLock;
            synchronized (object) {
                this.interrupted = true;
                Thread.currentThread();
                Thread.interrupted();
            }
            try {
                this.doUnbind();
                this.waitClientTermination();
                this.changeState(1);
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "run", "State is OFFLINE");
                }
            }
            catch (Exception exception) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "run", "Got unexpected exception", exception);
                }
                this.changeState(1);
            }
        }
    }

    protected abstract void doError(Exception var1) throws CommunicationException;

    protected abstract void doBind() throws CommunicationException, InterruptedException;

    protected abstract void doReceive() throws CommunicationException, InterruptedException;

    protected abstract void doProcess() throws CommunicationException, InterruptedException;

    protected abstract void doUnbind() throws CommunicationException, InterruptedException;

    public synchronized MBeanServer getMBeanServer() {
        return this.topMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMBeanServer(MBeanServer mBeanServer) throws IllegalArgumentException, IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
        }
        Vector<MBeanServer> vector = new Vector<MBeanServer>();
        MBeanServer mBeanServer2 = mBeanServer;
        while (mBeanServer2 != this.bottomMBS) {
            if (!(mBeanServer2 instanceof MBeanServerForwarder)) {
                throw new IllegalArgumentException("MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server");
            }
            if (vector.contains(mBeanServer2)) {
                throw new IllegalArgumentException("MBeanServerForwarder loop");
            }
            vector.addElement(mBeanServer2);
            mBeanServer2 = ((MBeanServerForwarder)mBeanServer2).getMBeanServer();
        }
        this.topMBS = mBeanServer;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeState(int n) {
        int n2;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == n) {
                return;
            }
            n2 = this.state;
            this.state = n;
            this.stateLock.notifyAll();
        }
        this.sendStateChangeNotification(n2, n);
    }

    String makeDebugTag() {
        return "CommunicatorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    String makeThreadName() {
        String string = this.objectName == null ? "CommunicatorServer" : this.objectName.toString();
        return string;
    }

    private synchronized void waitIfTooManyClients() throws InterruptedException {
        while (this.getActiveClientCount() >= this.maxActiveClientCount) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitIfTooManyClients", "Waiting for a client to terminate");
            }
            this.wait();
        }
    }

    private void waitClientTermination() {
        int n = this.clientHandlerVector.size();
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER) && n >= 1) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitClientTermination", "waiting for " + n + " clients to terminate");
        }
        while (!this.clientHandlerVector.isEmpty()) {
            try {
                this.clientHandlerVector.firstElement().join();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitClientTermination", "No elements left", noSuchElementException);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER) && n >= 1) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitClientTermination", "Ok, let's go...");
        }
    }

    private void terminateAllClient() {
        ClientHandler[] clientHandlerArray;
        int n = this.clientHandlerVector.size();
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER) && n >= 1) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "terminateAllClient", "Interrupting " + n + " clients");
        }
        for (ClientHandler clientHandler : clientHandlerArray = this.clientHandlerVector.toArray(new ClientHandler[0])) {
            try {
                clientHandler.interrupt();
            }
            catch (Exception exception) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "terminateAllClient", "Failed to interrupt pending request. Ignore the exception.", exception);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stateLock = new Object();
        this.state = 1;
        this.stopRequested = false;
        this.servedClientCount = 0;
        this.clientHandlerVector = new Vector();
        this.fatherThread = Thread.currentThread();
        this.mainThread = null;
        this.notifCount = 0L;
        this.notifInfos = null;
        this.notifBroadcaster = new NotificationBroadcasterSupport();
        this.dbgTag = this.makeDebugTag();
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "addNotificationListener", "Adding listener " + notificationListener + " with filter " + notificationFilter + " and handback " + object);
        }
        this.notifBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "removeNotificationListener", "Removing listener " + notificationListener);
        }
        this.notifBroadcaster.removeNotificationListener(notificationListener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfos == null) {
            this.notifInfos = new MBeanNotificationInfo[1];
            String[] stringArray = new String[]{"jmx.attribute.change"};
            this.notifInfos[0] = new MBeanNotificationInfo(stringArray, AttributeChangeNotification.class.getName(), "Sent to notify that the value of the State attribute of this CommunicatorServer instance has changed.");
        }
        return this.notifInfos;
    }

    private void sendStateChangeNotification(int n, int n2) {
        String string = CommunicatorServer.getStringForState(n);
        String string2 = CommunicatorServer.getStringForState(n2);
        String string3 = new StringBuffer().append(this.dbgTag).append(" The value of attribute State has changed from ").append(n).append(" (").append(string).append(") to ").append(n2).append(" (").append(string2).append(").").toString();
        ++this.notifCount;
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this, this.notifCount, System.currentTimeMillis(), string3, "State", "int", new Integer(n), new Integer(n2));
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendStateChangeNotification", "Sending AttributeChangeNotification #" + this.notifCount + " with message: " + string3);
        }
        this.notifBroadcaster.sendNotification(attributeChangeNotification);
    }

    private static String getStringForState(int n) {
        switch (n) {
            case 0: {
                return "ONLINE";
            }
            case 3: {
                return "STARTING";
            }
            case 1: {
                return "OFFLINE";
            }
            case 2: {
                return "STOPPING";
            }
        }
        return "UNDEFINED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            if (this.bottomMBS != null) {
                throw new IllegalArgumentException("connector already registered in an MBean server");
            }
            this.topMBS = this.bottomMBS = mBeanServer;
        }
        this.dbgTag = this.makeDebugTag();
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRegister(Boolean bl) {
        if (!bl.booleanValue()) {
            CommunicatorServer communicatorServer = this;
            synchronized (communicatorServer) {
                this.bottomMBS = null;
                this.topMBS = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDeregister() throws Exception {
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            this.bottomMBS = null;
            this.topMBS = null;
        }
        this.objectName = null;
        int n = this.getState();
        if (n == 0 || n == 3) {
            this.stop();
        }
    }

    @Override
    public void postDeregister() {
    }

    Class loadClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoaderRepository classLoaderRepository = MBeanServerFactory.getClassLoaderRepository(this.bottomMBS);
            if (classLoaderRepository == null) {
                throw new ClassNotFoundException(string);
            }
            return classLoaderRepository.loadClass(string);
        }
    }
}

