/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc.ee;

import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import sun.jdbc.odbc.ee.ConnectionPool;
import sun.jdbc.odbc.ee.ConnectionPoolFactory;
import sun.jdbc.odbc.ee.PooledObject;

public class ConnectionEventListener
implements javax.sql.ConnectionEventListener {
    private PooledObject objPool;
    private String name;

    public ConnectionEventListener(String string) {
        this.name = string;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        Object object = connectionEvent.getSource();
        this.objPool = (PooledObject)object;
        ConnectionPool connectionPool = ConnectionPoolFactory.obtainConnectionPool(this.name);
        connectionPool.checkIn(this.objPool);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        Object object = connectionEvent.getSource();
        this.objPool = (PooledObject)object;
        this.objPool.markForSweep();
        ConnectionPool connectionPool = ConnectionPoolFactory.obtainConnectionPool(this.name);
        connectionPool.checkIn(this.objPool);
    }

    public void connectionCheckOut(ConnectionEvent connectionEvent) throws SQLException {
        Object object = connectionEvent.getSource();
        this.objPool = (PooledObject)object;
        ConnectionPool connectionPool = ConnectionPoolFactory.obtainConnectionPool(this.name);
        connectionPool.tryCheckOut(this.objPool);
    }
}

