/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.P17ComUSBProcessor;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class P176TO30KComUSBProcessor
extends P17ComUSBProcessor {
    private static final Logger LOGGER = Logger.getLogger(P176TO30KComUSBProcessor.class);
    protected final int TEN = 10;
    protected final int HUNDRED = 100;
    private String pollFaultID = null;
    protected static final int SIXK = 6000;
    protected static final int TENK = 10000;
    protected static final int FIFTEENK = 15000;
    protected static final int TWEMTYK = 20000;
    protected static final int outputA = 0;

    public P176TO30KComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public boolean pollQueryStatus() {
        if (this.currenttime == null) {
            ++this.reconnectTimes;
            return false;
        }
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String qpicf;
            String qpiws;
            workinfo.setProdid(this._protocol.getProtocolID());
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            if (this.currenttime != null) {
                workinfo.setCurrentTime(this.currenttime.getTime());
            }
            if ("".equals(qpiws = handler.excuteCommand("WS", true)) || qpiws.equals("(NAK")) {
                return result;
            }
            String[] ws = qpiws.split(",");
            if (ws.length != 0) {
                this.handlerEventP1730K(ws, workinfo);
                if (ws[9].equals("1") || ws[10].equals("1") || ws[11].equals("1") || ws[12].equals("1") || ws[13].equals("1")) {
                    workinfo.setLineLoss(true);
                } else {
                    workinfo.setLineLoss(false);
                }
                if (ws[6].equals("1")) {
                    workinfo.setNoBattery(true);
                } else {
                    workinfo.setNoBattery(false);
                }
                if (ws[19].equals("1")) {
                    workinfo.setOverLoad(true);
                } else {
                    workinfo.setOverLoad(false);
                }
            }
            Calendar machineTime = Calendar.getInstance();
            machineTime.setTime(workinfo.getCurrentTime());
            Calendar serverTime = Calendar.getInstance(usLocale);
            if (Math.abs(machineTime.getTimeInMillis() - serverTime.getTimeInMillis()) > (long)(GlobalVariables.globalConfig.getShowWarningForDatetime() * 60 * 1000)) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "3003");
            }
            if (!"".equals(qpicf = handler.excuteCommand("CFS", true)) && !qpicf.equals("(NAK")) {
                String[] qpicfArr = qpicf.split(",");
                String faultID = qpicfArr[1];
                String saveFullFaultCodeDetailFlag = qpicfArr[2];
                if (this.pollFaultID != null && this.pollFaultID.equals(faultID)) {
                    return result;
                }
                this.pollFaultID = faultID;
                String nn = null;
                int i = 0;
                while (i < 9) {
                    nn = i <= 9 ? "0" + i : "" + i / 10 + i % 10;
                    String qhfs = handler.excuteCommand("HFS" + nn, true);
                    if (!"".equals(qhfs) && !qhfs.equals("(NAK")) {
                        String[] qhfsArr = qhfs.split(",");
                        String faultstr = qhfsArr[1];
                        DataBeforeFault data = new DataBeforeFault();
                        String timeStr = qhfsArr[2];
                        data.setTrandate(DateUtils.parseDate(timeStr, "yyMMddHHmmss"));
                        data.setProdid(this._protocol.getProtocolID());
                        data.setSerialno(this.getProtocol().getSerialNo());
                        data.setWorkMode(qhfsArr[3]);
                        data.setPvinputvoltage1(VolUtil.parseDouble(qhfsArr[4]) / 10.0);
                        data.setPvinputvoltage2(VolUtil.parseDouble(qhfsArr[5]) / 10.0);
                        data.setPvinputpower1(VolUtil.parseDouble(qhfsArr[6]));
                        data.setPvinputpower2(VolUtil.parseDouble(qhfsArr[7]));
                        data.setAcinputvoltager(VolUtil.parseDouble(qhfsArr[8]) / 10.0);
                        data.setAcinputvoltages(VolUtil.parseDouble(qhfsArr[9]) / 10.0);
                        data.setAcinputvoltaget(VolUtil.parseDouble(qhfsArr[10]) / 10.0);
                        data.setGridFrequency(VolUtil.parseDouble(qhfsArr[11]) / 100.0);
                        data.setBatteryVoltage(VolUtil.parseDouble(qhfsArr[12]) / 10.0);
                        String batCurrent = qhfsArr[13];
                        if (batCurrent.startsWith("+")) {
                            data.setBatteryCurrent(VolUtil.parseDouble(qhfsArr[13].substring(1)) / 10.0);
                        } else {
                            data.setBatteryCurrent(-VolUtil.parseDouble(qhfsArr[13].substring(1)) / 10.0);
                        }
                        data.setAcoutputvoltager(VolUtil.parseDouble(qhfsArr[14]) / 10.0);
                        data.setAcoutputvoltages(VolUtil.parseDouble(qhfsArr[15]) / 10.0);
                        data.setAcoutputvoltaget(VolUtil.parseDouble(qhfsArr[16]) / 10.0);
                        data.setOutputLoadFrequency(VolUtil.parseDouble(qhfsArr[17]) / 100.0);
                        data.setAcoutputapperentpowerr(VolUtil.parseDouble(qhfsArr[18]));
                        data.setAcoutputapperentpowers(VolUtil.parseDouble(qhfsArr[19]));
                        data.setAcoutputapperentpowert(VolUtil.parseDouble(qhfsArr[20]));
                        data.setOutputLoadPercent(VolUtil.parseInt(qhfsArr[21]));
                        data.setInnertemperature(VolUtil.parseInt(qhfsArr[22]));
                        data.setComponenttemperature(VolUtil.parseInt(qhfsArr[23]));
                        if (qhfsArr.length == 24) {
                            data.setExternalbatterytemperature(0.0);
                        } else {
                            data.setExternalbatterytemperature(VolUtil.parseInt(qhfsArr[24]));
                        }
                        data.setPVLoss(qhfsArr[25]);
                        data.setInverter1OverTempretureFlag(qhfsArr[26]);
                        data.setBatterySCROverTempretureFlag(qhfsArr[27]);
                        data.setGridVoltHighLoss(qhfsArr[28]);
                        data.setGridVoltLowLoss(qhfsArr[29]);
                        data.setGridFreqHighLoss(qhfsArr[30]);
                        data.setGridFreqLowLoss(qhfsArr[31]);
                        data.setGridVoltLTLoss(qhfsArr[32]);
                        data.setGridIslandDetect(qhfsArr[33]);
                        data.setGridWaveLoss(qhfsArr[34]);
                        data.setGridPhaseError(qhfsArr[35]);
                        data.setEPO(qhfsArr[36]);
                        data.setTransferOT(qhfsArr[37]);
                        data.setOverLoad(qhfsArr[38]);
                        data.setDCDCTempreture(qhfsArr[39]);
                        data.setBatteryLow(qhfsArr[40]);
                        data.setBatteryWeak(qhfsArr[41]);
                        data.setInverterOverTempretureFlag(qhfsArr[42]);
                        data.setSCRTempretureOverFlag(qhfsArr[43]);
                        data.setLoadOnStates(qhfsArr[44]);
                        data.setConfigurationChangeFlag(qhfsArr[45]);
                        data.setAS477EPO(qhfsArr[46]);
                        data.setRunResult(qhfsArr[47]);
                        data.setACOutputtotallApperentPowerR(VolUtil.parseDouble(qhfsArr[48]));
                        data.setAcoutputactivepowerr(VolUtil.parseDouble(qhfsArr[49]));
                        data.setAcoutputactivepowers(VolUtil.parseDouble(qhfsArr[50]));
                        data.setAcoutputactivepowert(VolUtil.parseDouble(qhfsArr[51]));
                        data.setACOutputTotallActivePowerR(VolUtil.parseDouble(qhfsArr[52]));
                        FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                    }
                    ++i;
                }
            }
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            LOGGER.error((Object)e.getMessage());
            workinfo.clear();
            ++this.reconnectTimes;
        }
        return result;
    }

    protected void handlerEventP1730K(String[] ws, WorkInfo workinfo) {
        this.warnsHandler(ws[0], "2001", workinfo);
        this.warnsHandler(ws[1], "2002", workinfo);
        this.warnsHandler(ws[2], "2003", workinfo);
        this.warnsHandler(ws[3], "2004", workinfo);
        this.warnsHandler(ws[4], "2005", workinfo);
        this.warnsHandler(ws[5], "2006", workinfo);
        this.warnsHandler(ws[6], "2007", workinfo);
        this.warnsHandler(ws[7], "2008", workinfo);
        this.warnsHandler(ws[8], "2009", workinfo);
        this.warnsHandler(ws[9], "2010", workinfo);
        this.warnsHandler(ws[10], "2011", workinfo);
        this.warnsHandler(ws[11], "2012", workinfo);
        this.warnsHandler(ws[12], "2013", workinfo);
        this.warnsHandler(ws[13], "2014", workinfo);
        this.warnsHandler(ws[14], "2015", workinfo);
        this.warnsHandler(ws[15], "2016", workinfo);
        this.warnsHandler(ws[16], "2017", workinfo);
        this.warnsHandler(ws[17], "2018", workinfo);
        this.warnsHandler(ws[18], "2019", workinfo);
        this.warnsHandler(ws[19], "2020", workinfo);
        this.warnsHandler(ws[20], "2021", workinfo);
        this.warnsHandler(ws[21], "2022", workinfo);
        this.warnsHandler(ws[22], "2023", workinfo);
        this.warnsHandler(ws[23], "2024", workinfo);
        this.warnsHandler(ws[24], "2025", workinfo);
        this.warnsHandler(ws[25], "2026", workinfo);
        this.warnsHandler(ws[26], "2027", workinfo);
        this.warnsHandler(ws[27], "2028", workinfo);
    }

    @Override
    public boolean queryConfigData() {
        boolean result = true;
        try {
            String btnum;
            String aapf;
            String qfppf;
            String qfpadj;
            String qdmStr;
            String qgpmp;
            String queryQPIRI;
            String qmpptv;
            String qgltv;
            String qlstStr;
            String qpvipv;
            String qopmpStr;
            String qmd;
            String qftStr;
            String qgof;
            String qgov;
            String fpra;
            String qchgsStr;
            String qbyf;
            String qbyv;
            WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
            ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String qvftrStr = handler.excuteCommand("MAR", true);
            if (!"".equals(qvftrStr) && !qvftrStr.equals("(NAK")) {
                String[] queryQvftrStr = qvftrStr.split(",");
                double maxGridOutputHighV = VolUtil.parseDouble(queryQvftrStr[0]) / 10.0;
                double minGridOutputHighV = VolUtil.parseDouble(queryQvftrStr[1]) / 10.0;
                double maxGridOutputLowV = VolUtil.parseDouble(queryQvftrStr[2]) / 10.0;
                double minGridOutputLowV = VolUtil.parseDouble(queryQvftrStr[3]) / 10.0;
                configdata.setMaxGridoutputhighV(maxGridOutputHighV);
                configdata.setMinGridoutputhighV(minGridOutputHighV);
                configdata.setMaxGridoutputlowV(maxGridOutputLowV);
                configdata.setMinGridoutputlowV(minGridOutputLowV);
                configdata.setMaxGridInputHighV(maxGridOutputHighV);
                configdata.setMinGridInputHighV(minGridOutputHighV);
                configdata.setMaxGridInputLowV(maxGridOutputLowV);
                configdata.setMinGridInputLowV(minGridOutputLowV);
                double maxGridOutputHighF = VolUtil.parseDouble(queryQvftrStr[4]) / 100.0;
                double minGridOutputHighF = VolUtil.parseDouble(queryQvftrStr[5]) / 100.0;
                double maxGridOutputLowF = VolUtil.parseDouble(queryQvftrStr[6]) / 100.0;
                double minGridOutputLowF = VolUtil.parseDouble(queryQvftrStr[7]) / 100.0;
                configdata.setMaxGridoutputhighF(maxGridOutputHighF);
                configdata.setMinGridoutputhighF(minGridOutputHighF);
                configdata.setMaxGridoutputlowF(maxGridOutputLowF);
                configdata.setMinGridoutputlowF(minGridOutputLowF);
                configdata.setMaxGridInputHighF(maxGridOutputHighF);
                configdata.setMinGridInputHighF(minGridOutputHighF);
                configdata.setMaxGridInputLowF(maxGridOutputLowF);
                configdata.setMinGridInputLowF(minGridOutputLowF);
                int maxWaittime = VolUtil.parseInt(queryQvftrStr[8]);
                int minWaittime = VolUtil.parseInt(queryQvftrStr[9]);
                configdata.setMaxGridWaittime(maxWaittime);
                configdata.setMinGridWaittime(minWaittime);
                int maxPvInputHighV = Integer.parseInt(queryQvftrStr[10]) / 10;
                int minPvInputHighV = Integer.parseInt(queryQvftrStr[11]) / 10;
                int maxPvInputLowV = Integer.parseInt(queryQvftrStr[12]) / 10;
                int minPvInputLowV = Integer.parseInt(queryQvftrStr[13]) / 10;
                int maxMpptHighV = Integer.parseInt(queryQvftrStr[14]) / 10;
                int minMpptHighV = Integer.parseInt(queryQvftrStr[15]) / 10;
                int maxMpptLowV = Integer.parseInt(queryQvftrStr[16]) / 10;
                int minMpptLowV = Integer.parseInt(queryQvftrStr[17]) / 10;
                double maxMaxChargingV = VolUtil.parseDouble(queryQvftrStr[18]) / 10.0;
                double minMaxChargingV = VolUtil.parseDouble(queryQvftrStr[19]) / 10.0;
                double maxMaxChargingCurrent = Double.parseDouble(queryQvftrStr[20]) / 10.0;
                double minMaxChargingCurrent = Double.parseDouble(queryQvftrStr[21]) / 10.0;
                configdata.setMaxMaxChargingCurrent(maxMaxChargingCurrent);
                configdata.setMinMaxChargingCurrent(minMaxChargingCurrent);
                configdata.setMaxPvInputHighV(maxPvInputHighV);
                configdata.setMinPvInputHighV(minPvInputHighV);
                configdata.setMaxPvInputLowV(maxPvInputLowV);
                configdata.setMinPvInputLowV(minPvInputLowV);
                configdata.setMaxMpptHighV(maxMpptHighV);
                configdata.setMinMpptHighV(minMpptHighV);
                configdata.setMaxMpptLowV(maxMpptLowV);
                configdata.setMinMpptLowV(minMpptLowV);
                configdata.setMaxMaxChargingVoltage(maxMaxChargingV);
                configdata.setMinMaxChargingVoltage(minMaxChargingV);
                configdata.setMaxFloatingVoltage(maxMaxChargingV);
                configdata.setMinFloatingVoltage(minMaxChargingV);
                int maxPowerFeedGrid = Integer.valueOf(queryQvftrStr[22]);
                int minPowerFeedGrid = Integer.valueOf(queryQvftrStr[23]);
                configdata.setMinPowerFeedGrid(minPowerFeedGrid);
                configdata.setMaxPowerFeedGrid(maxPowerFeedGrid);
            }
            if (!"".equals(qbyv = handler.excuteCommand("GOV", true)) && !qbyv.equals("(NAK")) {
                String[] qbyvArr = qbyv.split(",");
                double gridInputHighV = VolUtil.parseDouble(qbyvArr[0]) / 10.0;
                double gridInputLowV = VolUtil.parseDouble(qbyvArr[1]) / 10.0;
                configdata.setGridInputHighV(gridInputHighV);
                configdata.setGridInputLowV(gridInputLowV);
            }
            if (!"".equals(qbyf = handler.excuteCommand("GOF", true)) && !qbyf.equals("(NAK")) {
                String[] qbyfArr = qbyf.split(",");
                double gridInputHighF = VolUtil.parseDouble(qbyfArr[0]) / 100.0;
                double gridInputLowF = VolUtil.parseDouble(qbyfArr[1]) / 100.0;
                configdata.setGridInputHighF(gridInputHighF);
                configdata.setGridInputLowF(gridInputLowF);
            }
            if (!"".equals(qchgsStr = handler.excuteCommand("BATS", true)) && !qchgsStr.equals("(NAK")) {
                try {
                    String[] qchgsArr = qchgsStr.split(",");
                    double maxChargingCurrent = VolUtil.parseDouble(qchgsArr[0]) / 10.0;
                    double maxChargingVoltage = VolUtil.parseDouble(qchgsArr[1]) / 10.0;
                    double floatVoltage = VolUtil.parseDouble(qchgsArr[2]) / 10.0;
                    configdata.setFloatingVoltage(floatVoltage);
                    configdata.setMaxChargingCurrent(maxChargingCurrent);
                    configdata.setMaxChargingVoltage(maxChargingVoltage);
                    configdata.setLiFloatChargingCurrent(VolUtil.parseDouble(qchgsArr[3]) / 10.0);
                    configdata.setLimaxFloatChargingCurrent(50.0);
                    configdata.setLiminFloatChargingCurrent(0.0);
                    configdata.setMinMaxChargingCurrent(configdata.getLiFloatChargingCurrent());
                    configdata.setLiRemainingtime(VolUtil.parseInt(qchgsArr[4]));
                    configdata.setLimaxRemainingtime(999.0);
                    configdata.setLiminRemainingtime(0.0);
                    configdata.setLiRecoverVoltage(VolUtil.parseDouble(qchgsArr[5]) / 10.0);
                    configdata.setLimaxrecoverVoltage(60.0);
                    configdata.setLiminRecoverVoltage(40.0);
                    double cutoffVoltageGridLoss = VolUtil.parseDouble(qchgsArr[6]) / 10.0;
                    double recoverVoltageGridLoss = VolUtil.parseDouble(qchgsArr[7]) / 10.0;
                    double cutoffVoltage = VolUtil.parseDouble(qchgsArr[8]) / 10.0;
                    double recoverVoltage = VolUtil.parseDouble(qchgsArr[9]) / 10.0;
                    configdata.setCutoffVoltageGridLoss(cutoffVoltageGridLoss);
                    configdata.setMinCutoffVoltageGridLoss(40.0);
                    configdata.setMaxCutoffVoltageGridLoss(recoverVoltageGridLoss);
                    configdata.setRecoverVoltageGridLoss(recoverVoltageGridLoss);
                    configdata.setMinRecoverVoltageGridLoss(configdata.getCutoffVoltageGridLoss());
                    configdata.setMaxRecoverVoltageGridLoss(configdata.getFloatingVoltage());
                    configdata.setCutoffVoltage(cutoffVoltage);
                    configdata.setMinCutoffVoltage(42.0);
                    configdata.setMaxCutoffVoltage(recoverVoltage);
                    configdata.setRecoverVoltage(recoverVoltage);
                    configdata.setMinRecoverVoltage(configdata.getCutoffVoltage());
                    configdata.setMaxRecoverVoltage(configdata.getFloatingVoltage());
                    int batteryType = VolUtil.parseInt(qchgsArr[10]);
                    if (batteryType == 0) {
                        configdata.setLiFeBattery(false);
                    } else if (batteryType == 1) {
                        configdata.setLiFeBattery(true);
                    }
                    configdata.setCheck_gridChargingLowestBatVol(Integer.parseInt(qchgsArr[13]));
                    configdata.setGridChargingLowestBatVol(VolUtil.parseDouble(qchgsArr[14]) / 10.0);
                    double batTptCompensate = VolUtil.parseDouble(qchgsArr[15]) / 10.0;
                    if (batTptCompensate > 0.0 && configdata.isBatTptCompensateFirstQry()) {
                        workInfo.setNeedToReresh(true);
                        configdata.setBatTptCompensateFirstQry(false);
                        workInfo.setHaveRefreshed(true);
                    } else if (batTptCompensate <= 0.0 && workInfo.isHaveRefreshed()) {
                        workInfo.setNeedToReresh(true);
                        configdata.setBatTptCompensateFirstQry(true);
                        workInfo.setHaveRefreshed(false);
                    }
                    configdata.setBatTptCompensate(batTptCompensate);
                    configdata.setMinBatTptCompensate(0.0);
                    configdata.setMaxBatTptCompensate(10.0);
                    configdata.setMaxAcChargingCurrent(VolUtil.parseDouble(qchgsArr[16]) / 10.0);
                    configdata.setBatDischargeMaxCurrentInHybridMode(VolUtil.parseInt(qchgsArr[17]));
                    configdata.setMinBatDischargeMaxCurrentInHybridMode(10);
                    configdata.setMaxBatDischargeMaxCurrentInHybridMode(300);
                    try {
                        if (qchgsArr.length >= 21) {
                            configdata.setEnabledEPS(qchgsArr[18].equals("1"));
                            double batCutOffMainOutputVol = VolUtil.parseDouble(qchgsArr[19]) / 10.0;
                            configdata.setBatCutOffMainOutputVol(batCutOffMainOutputVol);
                            configdata.setMinBatCutOffMainOutputVol(40.0);
                            configdata.setMaxBatCutOffMainOutputVol(60.0);
                            double batReConnectedMainOutputVol = VolUtil.parseDouble(qchgsArr[20]) / 10.0;
                            configdata.setBatReConnectedMainOutputVol(batReConnectedMainOutputVol);
                            configdata.setMinBatReConnectedMainOutputVol(40.0);
                            configdata.setMaxBatReConnectedMainOutputVol(60.0);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage());
                }
            }
            if (this.getProtocol().getMCUVersion().compareTo("170711123000") >= 0 && !"".equals(fpra = handler.excuteCommand("FPRA", true)) && !fpra.equals("(NAK")) {
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                double feefInReactivePower = 0.0;
                if (machineInfo.getOutputRateVA() == 4000.0) {
                    feefInReactivePower = VolUtil.parseDouble(fpra);
                    configdata.setFeefInReactivePower(feefInReactivePower);
                    configdata.setMinfeefInReactivePower(-2000.0);
                    configdata.setMaxfeefInReactivePower(2000.0);
                } else if (machineInfo.getOutputRateVA() == 5000.0) {
                    feefInReactivePower = VolUtil.parseDouble(fpra);
                    configdata.setFeefInReactivePower(feefInReactivePower);
                    configdata.setMinfeefInReactivePower(-2500.0);
                    configdata.setMaxfeefInReactivePower(2500.0);
                } else if (machineInfo.getOutputRateVA() == 10000.0) {
                    feefInReactivePower = VolUtil.parseDouble(fpra);
                    configdata.setFeefInReactivePower(feefInReactivePower);
                    configdata.setMinfeefInReactivePower(-5000.0);
                    configdata.setMaxfeefInReactivePower(5000.0);
                }
            }
            if (!"".equals(qgov = handler.excuteCommand("GOV", true)) && !qgov.equals("(NAK")) {
                String[] qgovStr = qgov.split(",");
                double gridOutputHighV = VolUtil.parseDouble(qgovStr[0]) / 10.0;
                double gridOutputLowV = VolUtil.parseDouble(qgovStr[1]) / 10.0;
                configdata.setGridoutputhighV(gridOutputHighV);
                configdata.setGridoutputlowV(gridOutputLowV);
            }
            if (!"".equals(qgof = handler.excuteCommand("GOF", true)) && !qgof.equals("(NAK")) {
                String[] qgofStr = qgof.split(",");
                double gridOutputHighF = VolUtil.parseDouble(qgofStr[0]) / 100.0;
                double gridOutputLowF = VolUtil.parseDouble(qgofStr[1]) / 100.0;
                configdata.setGridoutputhighF(gridOutputHighF);
                configdata.setGridoutputlowF(gridOutputLowF);
            }
            if (!"".equals(qftStr = handler.excuteCommand("FT", true)) && !qftStr.equals("(NAK")) {
                int waitingTime = VolUtil.parseInt(qftStr);
                configdata.setGridwaittime(waitingTime);
            }
            if (!"".equals(qmd = handler.excuteCommand("MD", true)) && !qmd.equals("(NAK")) {
                String[] qmdAttr = qmd.split(",");
                String outputVAStr = qmdAttr[1];
                int outputRateVA = VolUtil.parseInt(outputVAStr);
                configdata.setMinMaxoutputPower(0);
                configdata.setMaxMaxoutputPower(outputRateVA);
            }
            if (!"".equals(qopmpStr = handler.excuteCommand("OPMP", true)) && !qopmpStr.equals("(NAK")) {
                int maxOutputPower = VolUtil.parseInt(qopmpStr);
                configdata.setMaxoutputPower(maxOutputPower);
            }
            if (!"".equals(qpvipv = handler.excuteCommand("SV", true)) && !qpvipv.equals("(NAK")) {
                String[] qpvipvStr = qpvipv.split(",");
                int upperLimitInputV = VolUtil.parseInt(qpvipvStr[0]) / 10;
                int lowestLimtInputV = VolUtil.parseInt(qpvipvStr[1]) / 10;
                configdata.setPvInputLowV(lowestLimtInputV);
                configdata.setPvInputHighV(upperLimitInputV);
            }
            if (!"".equals(qlstStr = handler.excuteCommand("LST", true)) && !qlstStr.equals("(NAK")) {
                configdata.setLcdSleepTime(qlstStr);
            }
            if (!"".equals(qgltv = handler.excuteCommand("GLTHV", true)) && !qgltv.equals("(NAK")) {
                int gridInputAverageHighV = VolUtil.parseInt(qgltv) / 10;
                configdata.setGridAvgHighV(gridInputAverageHighV);
                configdata.setMaxGridAvgHighV(265);
                configdata.setMinGridAvgHighV(235);
            }
            if (!"".equals(qmpptv = handler.excuteCommand("MPPTV", true)) && !qmpptv.equals("(NAK")) {
                String[] qmpptvStr = qmpptv.split(",");
                int highVoltage = VolUtil.parseInt(qmpptvStr[0]) / 10;
                int lowVoltage = VolUtil.parseInt(qmpptvStr[1]) / 10;
                configdata.setMpptHighV(highVoltage);
                configdata.setMpptLowV(lowVoltage);
            }
            if (!"".equals(queryQPIRI = handler.excuteCommand("PIRI", true)) && !queryQPIRI.equals("(NAK")) {
                String[] queryQPIRIStr = queryQPIRI.split(",");
                double gridRatingVoltage = VolUtil.parseDouble(queryQPIRIStr[0]) / 10.0;
                double gridRatingFrequency = VolUtil.parseDouble(queryQPIRIStr[1]) / 10.0;
                double gridRatingCurrent = VolUtil.parseDouble(queryQPIRIStr[2]) / 10.0;
                configdata.setNominalVoltage(gridRatingVoltage);
                configdata.setNominalFreq(gridRatingFrequency);
                int queryPVN = VolUtil.parseInt(queryQPIRIStr[7]);
                configdata.setPvnNumber(queryPVN);
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                machineInfo.setGridRatingCurrent(gridRatingCurrent);
                machineInfo.setGridRatingVoltage(gridRatingVoltage);
                machineInfo.setGridRatingFrequency(gridRatingFrequency);
                String machineTypeStr = queryQPIRIStr[8];
                if (machineTypeStr.equals("00")) {
                    machineInfo.setMachineType("Grid-Tie");
                } else if (machineTypeStr.equals("01")) {
                    machineInfo.setMachineType("Off-Grid");
                } else if (machineTypeStr.equals("10")) {
                    machineInfo.setMachineType("Hybrid");
                } else if (machineTypeStr.equals("11")) {
                    machineInfo.setMachineType("Self-Use");
                }
                this.getProtocol().setModelType(machineTypeStr);
            }
            if (!"".equals(qgpmp = handler.excuteCommand("GPMP", true)) && !qgpmp.equals("(NAK")) {
                int maxfeedgrid = VolUtil.parseInt(qgpmp);
                configdata.setMinMaxoutputPower(maxfeedgrid);
                configdata.setPowerfeedGrid(maxfeedgrid);
            }
            if (!"".equals(qdmStr = handler.excuteCommand("DM", true)) && !qdmStr.equals("(NAK")) {
                int modeid = VolUtil.parseInt(qdmStr);
                String retString = handler.excuteCommand("HECS", true);
                if (!"".equals(retString) && !retString.equals("(NAK")) {
                    try {
                        String[] retAtt = retString.split(",");
                        if (modeid == 151) {
                            configdata.setPlanID("02");
                        } else if (modeid == 150) {
                            if (retAtt[0].equals("00")) {
                                configdata.setPlanID("01");
                            } else if (retAtt[0].equals("01")) {
                                configdata.setPlanID("00");
                            }
                        } else {
                            configdata.setPlanID(retAtt[0]);
                        }
                        configdata.setCheck_charge(VolUtil.parseInt(retAtt[1]));
                        configdata.setCheck_accharge(VolUtil.parseInt(retAtt[2]));
                        configdata.setCheck_pvfeedgrid(VolUtil.parseInt(retAtt[3]));
                        configdata.setCheck_batdispvon(VolUtil.parseInt(retAtt[4]));
                        configdata.setCheck_batdispvloss(VolUtil.parseInt(retAtt[5]));
                        configdata.setCheck_batfeedpvon(VolUtil.parseInt(retAtt[6]));
                        configdata.setCheck_batfeedpvloss(VolUtil.parseInt(retAtt[7]));
                        configdata.setCheck_reactivePowerAutoControl(VolUtil.parseInt(retAtt[8]));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e.getMessage());
                    }
                }
                if (!"".equals(retString = handler.excuteCommand("ACCT", true)) && !retString.equals("(NAK")) {
                    String[] attr = retString.split(",");
                    configdata.setAcChargeStarttime(attr[0]);
                    configdata.setAcChargeEndtime(attr[1]);
                    try {
                        configdata.setAcctParams(attr.length);
                        configdata.setAcChargeStarttime2(attr[2]);
                        configdata.setAcChargeEndtime2(attr[3]);
                    }
                    catch (Exception gridRatingCurrent) {
                        // empty catch block
                    }
                }
                if (!"".equals(retString = handler.excuteCommand("ACLT", true)) && !retString.equals("(NAK")) {
                    String[] splitArray = retString.split(",");
                    configdata.setAcoutputStarttime(splitArray[0]);
                    configdata.setAcoutputEndtime(splitArray[1]);
                }
            }
            if (!"".equals(qfpadj = handler.excuteCommand("FPADJ", true)) && !qfpadj.equals("(NAK")) {
                String[] qfpadjAttr = qfpadj.split(",");
                if (qfpadjAttr[0].equals("0")) {
                    configdata.setGridPowerDeviation(-VolUtil.parseInt(qfpadjAttr[1]));
                } else if (qfpadjAttr[0].equals("1")) {
                    configdata.setGridPowerDeviation(VolUtil.parseInt(qfpadjAttr[1]));
                }
                configdata.setMaxGridPowerDeviation(1000);
                configdata.setMinGridPowerDeviation(-1000);
                if (qfpadjAttr[2].equals("0")) {
                    configdata.setFeedingGridCalibrationPowerR(-VolUtil.parseInt(qfpadjAttr[3]));
                } else if (qfpadjAttr[2].equals("1")) {
                    configdata.setFeedingGridCalibrationPowerR(VolUtil.parseInt(qfpadjAttr[3]));
                }
                configdata.setMinFeedingGridCalibrationPowerR(-1000);
                configdata.setMaxFeedingGridCalibrationPowerR(1000);
                if (qfpadjAttr[4].equals("0")) {
                    configdata.setFeedingGridCalibrationPowerS(-VolUtil.parseInt(qfpadjAttr[5]));
                } else if (qfpadjAttr[4].equals("1")) {
                    configdata.setFeedingGridCalibrationPowerS(VolUtil.parseInt(qfpadjAttr[5]));
                }
                configdata.setMinFeedingGridCalibrationPowerS(-1000);
                configdata.setMaxFeedingGridCalibrationPowerS(1000);
                if (qfpadjAttr[6].equals("0")) {
                    configdata.setFeedingGridCalibrationPowerT(-VolUtil.parseInt(qfpadjAttr[7]));
                } else if (qfpadjAttr[6].equals("1")) {
                    configdata.setFeedingGridCalibrationPowerT(VolUtil.parseInt(qfpadjAttr[7]));
                }
                configdata.setMinFeedingGridCalibrationPowerT(-1000);
                configdata.setMaxFeedingGridCalibrationPowerT(1000);
            }
            if (!"".equals(qfppf = handler.excuteCommand("FPPF", true)) && !qfppf.equals("(NAK")) {
                int fppf = VolUtil.parseInt(qfppf);
                if (fppf > 100) {
                    configdata.setFeedinPowerFactor((double)(-(fppf -= 100)) / 100.0);
                } else {
                    configdata.setFeedinPowerFactor((double)fppf / 100.0);
                }
                if (configdata.getFeefInReactivePower() == 0.0) {
                    configdata.setMinFeedinPowerFactor(-0.99);
                    configdata.setMaxFeedinPowerFactor(1.0);
                }
            }
            if (!"".equals(aapf = handler.excuteCommand("AAPF", true)) && !aapf.equals("(NAK")) {
                String[] aapfAttr = aapf.split(",");
                configdata.setEnabledAAPF(aapfAttr[0].equals("1"));
                int startPowerPercentage = VolUtil.parseInt(aapfAttr[1]);
                configdata.setStartPowerPercentage(startPowerPercentage);
                configdata.setMinStartPowerPercentage(10);
                configdata.setMaxStartPowerPercentage(90);
                double minmumPFValue = VolUtil.parseDouble(aapfAttr[2]);
                if (minmumPFValue >= 190.0) {
                    minmumPFValue = (minmumPFValue - 100.0) / 100.0;
                    configdata.setMinmumPFValue(-minmumPFValue);
                    configdata.setMinMinmumPFValue(-0.99);
                    configdata.setMaxMinmumPFValue(-0.9);
                }
            }
            String ple = handler.excuteCommand("PLE", true);
            if (!"".equals(aapf) && !aapf.equals("(NAK")) {
                if (ple.equals("1")) {
                    configdata.setAllowSTPhaseLoss(true);
                } else {
                    configdata.setAllowSTPhaseLoss(false);
                }
            }
            if (!"".equals(btnum = handler.excuteCommand("BTNUM", true)) && !btnum.equals("(NAK")) {
                int batnum = VolUtil.parseInt(btnum);
                if (batnum >= 29 && batnum <= 32) {
                    configdata.setBatteryNumber(batnum);
                }
                configdata.setMinBatteryNumber(29);
                configdata.setMaxBatteryNumber(32);
            }
        }
        catch (Exception e) {
            result = false;
            LOGGER.error((Object)e.getMessage());
        }
        return result;
    }
}

