/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.security.AccessController;
import sun.awt.SunToolkit;
import sun.awt.X11.XErrorEvent;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XlibWrapper;
import sun.security.action.GetBooleanAction;
import sun.util.logging.PlatformLogger;

public final class XErrorHandlerUtil {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XErrorHandlerUtil");
    private static long display;
    private static long saved_error_handler;
    static volatile XErrorEvent saved_error;
    private static XErrorHandler current_error_handler;
    private static boolean noisyAwtHandler;
    private static boolean initPassed;

    private XErrorHandlerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(long l) {
        SunToolkit.awtLock();
        try {
            if (!initPassed) {
                display = l;
                saved_error_handler = XlibWrapper.SetToolkitErrorHandler();
                initPassed = true;
            }
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public static void WITH_XERROR_HANDLER(XErrorHandler xErrorHandler) {
        XErrorHandlerUtil.XSync();
        saved_error = null;
        current_error_handler = xErrorHandler;
    }

    public static void RESTORE_XERROR_HANDLER() {
        XErrorHandlerUtil.XSync();
        current_error_handler = null;
    }

    public static int SAVED_XERROR_HANDLER(long l, XErrorEvent xErrorEvent) {
        if (saved_error_handler != 0L) {
            // empty if block
        }
        if (log.isLoggable(500)) {
            log.fine("Unhandled XErrorEvent: id=" + xErrorEvent.get_resourceid() + ", " + "serial=" + xErrorEvent.get_serial() + ", " + "ec=" + xErrorEvent.get_error_code() + ", " + "rc=" + xErrorEvent.get_request_code() + ", " + "mc=" + xErrorEvent.get_minor_code());
        }
        return 0;
    }

    private static int globalErrorHandler(long l, long l2) {
        XErrorEvent xErrorEvent;
        if (noisyAwtHandler) {
            XlibWrapper.PrintXErrorEvent(l, l2);
        }
        saved_error = xErrorEvent = new XErrorEvent(l2);
        try {
            if (current_error_handler != null) {
                return current_error_handler.handleError(l, xErrorEvent);
            }
            return XErrorHandlerUtil.SAVED_XERROR_HANDLER(l, xErrorEvent);
        }
        catch (Throwable throwable) {
            log.fine("Error in GlobalErrorHandler", throwable);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void XSync() {
        SunToolkit.awtLock();
        try {
            XlibWrapper.XSync(display, 0);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    static {
        noisyAwtHandler = AccessController.doPrivileged(new GetBooleanAction("sun.awt.noisyerrorhandler"));
    }
}

