/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class BeanUtils {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$Class;

    public static Object instantiateClass(Class clazz) throws BeanInstantiationException {
        Assert.notNull((Object)clazz, (String)"Class must not be null");
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        try {
            return BeanUtils.instantiateClass(clazz.getDeclaredConstructor(null), null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BeanInstantiationException(clazz, "No default constructor found", noSuchMethodException);
        }
    }

    public static Object instantiateClass(Constructor constructor, Object[] objectArray) throws BeanInstantiationException {
        Assert.notNull((Object)constructor, (String)"Constructor must not be null");
        try {
            if (!Modifier.isPublic(constructor.getModifiers()) || !Modifier.isPublic(constructor.getDeclaringClass().getModifiers())) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new BeanInstantiationException(constructor.getDeclaringClass(), "Is it an abstract class?", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanInstantiationException(constructor.getDeclaringClass(), "Has the class definition changed? Is the constructor accessible?", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanInstantiationException(constructor.getDeclaringClass(), "Illegal arguments for constructor", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new BeanInstantiationException(constructor.getDeclaringClass(), "Constructor threw exception", invocationTargetException.getTargetException());
        }
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return BeanUtils.findDeclaredMethod(clazz, string, classArray);
        }
    }

    public static Method findDeclaredMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (clazz.getSuperclass() != null) {
                return BeanUtils.findDeclaredMethod(clazz.getSuperclass(), string, classArray);
            }
            return null;
        }
    }

    public static Method findMethodWithMinimalParameters(Class clazz, String string) throws IllegalArgumentException {
        Method method = BeanUtils.doFindMethodWithMinimalParameters(clazz.getDeclaredMethods(), string);
        if (method == null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz, string);
        }
        return method;
    }

    public static Method findDeclaredMethodWithMinimalParameters(Class clazz, String string) throws IllegalArgumentException {
        Method method = BeanUtils.doFindMethodWithMinimalParameters(clazz.getDeclaredMethods(), string);
        if (method == null && clazz.getSuperclass() != null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz.getSuperclass(), string);
        }
        return method;
    }

    private static Method doFindMethodWithMinimalParameters(Method[] methodArray, String string) throws IllegalArgumentException {
        Method method = null;
        int n = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            int n2 = methodArray[i].getParameterTypes().length;
            if (method == null || n2 < method.getParameterTypes().length) {
                method = methodArray[i];
                n = 1;
                continue;
            }
            if (method.getParameterTypes().length != n2) continue;
            ++n;
        }
        if (n > 1) {
            throw new IllegalArgumentException("Cannot resolve method '" + string + "' to a unique method. Attempted to resolve to overloaded method with " + "the least number of parameters, but there were " + n + " candidates.");
        }
        return method;
    }

    public static Method resolveSignature(String string, Class clazz) {
        Assert.hasText((String)string, (String)"'signature' must not be empty");
        Assert.notNull((Object)clazz, (String)"Class must not be null");
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n > -1 && n2 == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + string + "': expected closing ')' for args list");
        }
        if (n2 > -1 && n == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + string + "': expected opening '(' for args list");
        }
        if (n == -1 && n2 == -1) {
            return BeanUtils.findMethodWithMinimalParameters(clazz, string);
        }
        String string2 = string.substring(0, n);
        String[] stringArray = StringUtils.commaDelimitedListToStringArray((String)string.substring(n + 1, n2));
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            try {
                classArray[i] = ClassUtils.forName((String)string3, (ClassLoader)clazz.getClassLoader());
                continue;
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Invalid method signature: unable to resolve type [" + string3 + "] for argument " + i + ". Root cause: " + throwable);
            }
        }
        return BeanUtils.findMethod(clazz, string2, classArray);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws BeansException {
        CachedIntrospectionResults cachedIntrospectionResults = CachedIntrospectionResults.forClass(clazz);
        return cachedIntrospectionResults.getBeanInfo().getPropertyDescriptors();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) throws BeansException {
        CachedIntrospectionResults cachedIntrospectionResults = CachedIntrospectionResults.forClass(clazz);
        return cachedIntrospectionResults.getPropertyDescriptor(string);
    }

    public static PropertyDescriptor findPropertyForMethod(Method method) throws BeansException {
        Assert.notNull((Object)method, (String)"Method must not be null");
        PropertyDescriptor[] propertyDescriptorArray = BeanUtils.getPropertyDescriptors(method.getDeclaringClass());
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!method.equals(propertyDescriptorArray[i].getReadMethod()) && !method.equals(propertyDescriptorArray[i].getWriteMethod())) continue;
            return propertyDescriptorArray[i];
        }
        return null;
    }

    public static Class findPropertyType(String string, Class[] classArray) {
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(classArray[i], string);
                if (propertyDescriptor == null) continue;
                return propertyDescriptor.getPropertyType();
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = BeanUtils.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public static boolean isSimpleProperty(Class clazz) {
        Assert.notNull((Object)clazz, (String)"Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveArray((Class)clazz) || ClassUtils.isPrimitiveWrapper((Class)clazz) || ClassUtils.isPrimitiveWrapperArray((Class)clazz) || clazz.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtils.class$("java.lang.String")) : class$java$lang$String) || clazz.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtils.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || clazz.equals(class$java$lang$Class == null ? (class$java$lang$Class = BeanUtils.class$("java.lang.Class")) : class$java$lang$Class) || clazz.equals(array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = BeanUtils.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class);
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        return ClassUtils.isAssignable((Class)clazz, (Class)clazz2);
    }

    public static boolean isAssignable(Class clazz, Object object) {
        return ClassUtils.isAssignableValue((Class)clazz, (Object)object);
    }

    public static void copyProperties(Object object, Object object2) throws BeansException {
        BeanUtils.copyProperties(object, object2, null, null);
    }

    public static void copyProperties(Object object, Object object2, Class clazz) throws BeansException {
        BeanUtils.copyProperties(object, object2, clazz, null);
    }

    public static void copyProperties(Object object, Object object2, String[] stringArray) throws BeansException {
        BeanUtils.copyProperties(object, object2, null, stringArray);
    }

    private static void copyProperties(Object object, Object object2, Class clazz, String[] stringArray) throws BeansException {
        Assert.notNull((Object)object, (String)"Source must not be null");
        Assert.notNull((Object)object2, (String)"Target must not be null");
        Class clazz2 = object2.getClass();
        if (clazz != null) {
            if (!clazz.isInstance(object2)) {
                throw new IllegalArgumentException("Target class [" + object2.getClass().getName() + "] not assignable to Editable class [" + clazz.getName() + "]");
            }
            clazz2 = clazz;
        }
        PropertyDescriptor[] propertyDescriptorArray = BeanUtils.getPropertyDescriptors(clazz2);
        List<String> list = stringArray != null ? Arrays.asList(stringArray) : null;
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptorArray[i];
            if (propertyDescriptor2.getWriteMethod() == null || stringArray != null && list.contains(propertyDescriptor2.getName()) || (propertyDescriptor = BeanUtils.getPropertyDescriptor(object.getClass(), propertyDescriptor2.getName())) == null || propertyDescriptor.getReadMethod() == null) continue;
            try {
                Method method = propertyDescriptor.getReadMethod();
                if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    method.setAccessible(true);
                }
                Object object3 = method.invoke(object, new Object[0]);
                Method method2 = propertyDescriptor2.getWriteMethod();
                if (!Modifier.isPublic(method2.getDeclaringClass().getModifiers())) {
                    method2.setAccessible(true);
                }
                method2.invoke(object2, object3);
                continue;
            }
            catch (Throwable throwable) {
                throw new FatalBeanException("Could not copy properties from source to target", throwable);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

