/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.resolver.readers;

import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.CatalogException;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.helpers.BootstrapResolver;
import com.sun.org.apache.xml.internal.resolver.helpers.Debug;
import com.sun.org.apache.xml.internal.resolver.readers.CatalogReader;
import com.sun.org.apache.xml.internal.resolver.readers.SAXCatalogParser;
import com.sun.org.apache.xml.internal.resolver.readers.SAXParserHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sun.reflect.misc.ReflectUtil;

public class SAXCatalogReader
implements CatalogReader,
ContentHandler,
DocumentHandler {
    protected SAXParserFactory parserFactory = null;
    protected String parserClass = null;
    protected Hashtable namespaceMap = new Hashtable();
    private SAXCatalogParser saxParser = null;
    private boolean abandonHope = false;
    private Catalog catalog;
    protected Debug debug;

    public void setParserFactory(SAXParserFactory sAXParserFactory) {
        this.parserFactory = sAXParserFactory;
    }

    public void setParserClass(String string) {
        this.parserClass = string;
    }

    public SAXParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public String getParserClass() {
        return this.parserClass;
    }

    public SAXCatalogReader() {
        this.debug = CatalogManager.getStaticManager().debug;
        this.parserFactory = null;
        this.parserClass = null;
    }

    public SAXCatalogReader(SAXParserFactory sAXParserFactory) {
        this.debug = CatalogManager.getStaticManager().debug;
        this.parserFactory = sAXParserFactory;
    }

    public SAXCatalogReader(String string) {
        this.debug = CatalogManager.getStaticManager().debug;
        this.parserClass = string;
    }

    public void setCatalogParser(String string, String string2, String string3) {
        if (string == null) {
            this.namespaceMap.put(string2, string3);
        } else {
            this.namespaceMap.put("{" + string + "}" + string2, string3);
        }
    }

    public String getCatalogParser(String string, String string2) {
        if (string == null) {
            return (String)this.namespaceMap.get(string2);
        }
        return (String)this.namespaceMap.get("{" + string + "}" + string2);
    }

    @Override
    public void readCatalog(Catalog catalog, String string) throws MalformedURLException, IOException, CatalogException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL("file:///" + string);
        }
        this.debug = catalog.getCatalogManager().debug;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.readCatalog(catalog, uRLConnection.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            catalog.getCatalogManager().debug.message(1, "Failed to load catalog, file not found", uRL.toString());
        }
    }

    @Override
    public void readCatalog(Catalog catalog, InputStream inputStream) throws IOException, CatalogException {
        if (this.parserFactory == null && this.parserClass == null) {
            this.debug.message(1, "Cannot read SAX catalog without a parser");
            throw new CatalogException(6);
        }
        this.debug = catalog.getCatalogManager().debug;
        BootstrapResolver bootstrapResolver = catalog.getCatalogManager().getBootstrapResolver();
        this.catalog = catalog;
        try {
            if (this.parserFactory != null) {
                SAXParser sAXParser = this.parserFactory.newSAXParser();
                SAXParserHandler sAXParserHandler = new SAXParserHandler();
                sAXParserHandler.setContentHandler(this);
                if (bootstrapResolver != null) {
                    sAXParserHandler.setEntityResolver(bootstrapResolver);
                }
                sAXParser.parse(new InputSource(inputStream), (DefaultHandler)sAXParserHandler);
            } else {
                Parser parser = (Parser)ReflectUtil.forName(this.parserClass).newInstance();
                parser.setDocumentHandler(this);
                if (bootstrapResolver != null) {
                    parser.setEntityResolver(bootstrapResolver);
                }
                parser.parse(new InputSource(inputStream));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CatalogException(6);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CatalogException(6);
        }
        catch (InstantiationException instantiationException) {
            throw new CatalogException(6);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CatalogException(5);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            UnknownHostException unknownHostException = new UnknownHostException();
            FileNotFoundException fileNotFoundException = new FileNotFoundException();
            if (exception != null) {
                if (exception.getClass() == unknownHostException.getClass()) {
                    throw new CatalogException(7, exception.toString());
                }
                if (exception.getClass() == fileNotFoundException.getClass()) {
                    throw new CatalogException(7, exception.toString());
                }
            }
            throw new CatalogException(sAXException);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.saxParser != null) {
            this.saxParser.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.saxParser = null;
        this.abandonHope = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.endDocument();
        }
    }

    @Override
    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.abandonHope) {
            return;
        }
        if (this.saxParser == null) {
            String string2;
            String string3 = "";
            if (string.indexOf(58) > 0) {
                string3 = string.substring(0, string.indexOf(58));
            }
            if ((string2 = string).indexOf(58) > 0) {
                string2 = string2.substring(string2.indexOf(58) + 1);
            }
            String string4 = null;
            string4 = string3.equals("") ? attributeList.getValue("xmlns") : attributeList.getValue("xmlns:" + string3);
            String string5 = this.getCatalogParser(string4, string2);
            if (string5 == null) {
                this.abandonHope = true;
                if (string4 == null) {
                    this.debug.message(2, "No Catalog parser for " + string);
                } else {
                    this.debug.message(2, "No Catalog parser for {" + string4 + "}" + string);
                }
                return;
            }
            try {
                this.saxParser = (SAXCatalogParser)ReflectUtil.forName(string5).newInstance();
                this.saxParser.setCatalog(this.catalog);
                this.saxParser.startDocument();
                this.saxParser.startElement(string, attributeList);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, classNotFoundException.toString());
            }
            catch (InstantiationException instantiationException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, illegalAccessException.toString());
            }
            catch (ClassCastException classCastException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, classCastException.toString());
            }
        } else {
            this.saxParser.startElement(string, attributeList);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.abandonHope) {
            return;
        }
        if (this.saxParser == null) {
            String string4 = this.getCatalogParser(string, string2);
            if (string4 == null) {
                this.abandonHope = true;
                if (string == null) {
                    this.debug.message(2, "No Catalog parser for " + string2);
                } else {
                    this.debug.message(2, "No Catalog parser for {" + string + "}" + string2);
                }
                return;
            }
            try {
                this.saxParser = (SAXCatalogParser)ReflectUtil.forName(string4).newInstance();
                this.saxParser.setCatalog(this.catalog);
                this.saxParser.startDocument();
                this.saxParser.startElement(string, string2, string3, attributes);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, classNotFoundException.toString());
            }
            catch (InstantiationException instantiationException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, illegalAccessException.toString());
            }
            catch (ClassCastException classCastException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, classCastException.toString());
            }
        } else {
            this.saxParser.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.endElement(string);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.endElement(string, string2, string3);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.characters(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.ignorableWhitespace(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.processingInstruction(string, string2);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.startPrefixMapping(string, string2);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.endPrefixMapping(string);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.skippedEntity(string);
        }
    }
}

