/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.misc;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public final class ReflectUtil {
    public static final String PROXY_PACKAGE = "com.sun.proxy";

    private ReflectUtil() {
    }

    public static Class forName(String string) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(string);
        return Class.forName(string);
    }

    public static Object newInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        ReflectUtil.checkPackageAccess(clazz);
        return clazz.newInstance();
    }

    public static void ensureMemberAccess(Class clazz, Class clazz2, Object object, int n) throws IllegalAccessException {
        if (object == null && Modifier.isProtected(n)) {
            int n2 = n;
            n2 &= 0xFFFFFFFB;
            Reflection.ensureMemberAccess(clazz, clazz2, object, n2 |= 1);
            try {
                Reflection.ensureMemberAccess(clazz, clazz2, object, n2 &= 0xFFFFFFFE);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (ReflectUtil.isSubclassOf(clazz, clazz2)) {
                    return;
                }
                throw illegalAccessException;
            }
        }
        Reflection.ensureMemberAccess(clazz, clazz2, object, n);
    }

    private static boolean isSubclassOf(Class clazz, Class clazz2) {
        while (clazz != null) {
            if (clazz == clazz2) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static void conservativeCheckMemberAccess(Member member) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        Class<?> clazz = member.getDeclaringClass();
        ReflectUtil.checkPackageAccess(clazz);
        if (Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers())) {
            return;
        }
        securityManager.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
    }

    public static void checkPackageAccess(Class<?> clazz) {
        ReflectUtil.checkPackageAccess(clazz.getName());
        if (ReflectUtil.isNonPublicProxyClass(clazz)) {
            ReflectUtil.checkProxyPackageAccess(clazz);
        }
    }

    public static void checkPackageAccess(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n;
            String string2 = string.replace('/', '.');
            if (string2.startsWith("[") && (n = string2.lastIndexOf(91) + 2) > 1 && n < string2.length()) {
                string2 = string2.substring(n);
            }
            if ((n = string2.lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(string2.substring(0, n));
            }
        }
    }

    public static boolean isPackageAccessible(Class clazz) {
        try {
            ReflectUtil.checkPackageAccess(clazz);
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private static boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
        ClassLoader classLoader3 = classLoader2;
        do {
            if (classLoader != (classLoader3 = classLoader3.getParent())) continue;
            return true;
        } while (classLoader3 != null);
        return false;
    }

    public static boolean needsPackageAccessCheck(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader == null || classLoader == classLoader2) {
            return false;
        }
        if (classLoader2 == null) {
            return true;
        }
        return !ReflectUtil.isAncestor(classLoader, classLoader2);
    }

    public static void checkProxyPackageAccess(Class<?> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && Proxy.isProxyClass(clazz)) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                ReflectUtil.checkPackageAccess(clazz2);
            }
        }
    }

    public static void checkProxyPackageAccess(ClassLoader classLoader, Class<?> ... classArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            for (Class<?> clazz : classArray) {
                ClassLoader classLoader2 = clazz.getClassLoader();
                if (!ReflectUtil.needsPackageAccessCheck(classLoader, classLoader2)) continue;
                ReflectUtil.checkPackageAccess(clazz);
            }
        }
    }

    public static boolean isNonPublicProxyClass(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        String string2 = n != -1 ? string.substring(0, n) : "";
        return Proxy.isProxyClass(clazz) && !string2.equals(PROXY_PACKAGE);
    }

    public static void checkProxyMethod(Object object, Method method) {
        String string;
        if (object == null || !Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("Not a Proxy instance");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Can't handle static method");
        }
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Object.class && ((string = method.getName()).equals("hashCode") || string.equals("equals") || string.equals("toString"))) {
            return;
        }
        if (ReflectUtil.isSuperInterface(object.getClass(), clazz)) {
            return;
        }
        throw new IllegalArgumentException("Can't handle: " + method);
    }

    private static boolean isSuperInterface(Class<?> clazz, Class<?> clazz2) {
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (!ReflectUtil.isSuperInterface(clazz3, clazz2)) continue;
            return true;
        }
        return false;
    }
}

