/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractComUSBProcessor
extends AbstractProcessor {
    public AbstractComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    public boolean notEmpty(String str) {
        return !StringUtils.isEmpty((String)str) && !str.equals("(NAK");
    }

    public boolean isEmpty(String str) {
        return StringUtils.isEmpty((String)str) || str.equals("(NAK");
    }

    public void warnsHandler(String warns, String eventid, WorkInfo workinfo) {
        if (warns.equals("1")) {
            if (!workinfo.getWarnings().contains(eventid)) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), eventid);
                workinfo.addWarning(eventid);
            }
        } else if (workinfo.getWarnings().contains(eventid)) {
            workinfo.getWarnings().remove(eventid);
        }
    }

    public void faultsHandler(String faultCode, WorkInfo workinfo, DataBeforeFault data) {
        Set<String> keys = FaultHandler.eventMap.keySet();
        for (String key : keys) {
            String eventid = FaultHandler.eventMap.get(key);
            if (faultCode.equals(key)) {
                if (workinfo.getWarnings().contains(eventid)) continue;
                FaultHandler.recordEvent(workinfo.getProdid(), workinfo.getSerialno(), eventid, data);
                workinfo.addWarning(eventid);
                continue;
            }
            if (!workinfo.getWarnings().contains(eventid)) continue;
            workinfo.getWarnings().remove(eventid);
        }
    }
}

