/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class RunTools {
    private static boolean typeEqual(Class class1, Class class2) {
        if (class1 == class2) {
            return true;
        }
        Class[][] sameclass = new Class[][]{{Integer.TYPE, Integer.class}, {Long.TYPE, Long.class}, {Float.TYPE, Float.class}, {Double.TYPE, Double.class}, {Boolean.TYPE, Boolean.class}};
        int row_i = 0;
        while (row_i < sameclass.length) {
            if (!(class1 != sameclass[row_i][0] && class1 != sameclass[row_i][1] || class2 != sameclass[row_i][0] && class2 != sameclass[row_i][1])) {
                return true;
            }
            ++row_i;
        }
        return false;
    }

    private static boolean class2Extendfrom1(Class class1, Class class2) {
        if (class1 == Object.class) {
            return true;
        }
        Class superclass = class2;
        while (superclass != Object.class) {
            if (class1 == superclass) {
                return true;
            }
            if (class1.isInterface()) {
                Class<?>[] classArray = superclass.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> iface = classArray[n2];
                    if (iface == class1) {
                        return true;
                    }
                    ++n2;
                }
            }
            superclass = superclass.getSuperclass();
        }
        return false;
    }

    public static void logFile(String caption, String data) {
        System.out.println(String.valueOf(caption) + "=" + data);
    }

    private static Method findMethod(Object obj, String methodName, Object[] paras) {
        Method[] methods;
        Method method = null;
        int paralen = 0;
        if (paras != null) {
            paralen = paras.length;
        }
        Method[] methodArray = methods = obj.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] ptypes;
            Method method1 = methodArray[n2];
            if (method1.getName().equals(methodName) && (ptypes = method1.getParameterTypes()).length == paralen) {
                if (paralen == 0) {
                    method = method1;
                    break;
                }
                boolean equal = true;
                int index = 0;
                while (index < paralen) {
                    if (!RunTools.typeEqual(ptypes[index], paras[index].getClass()) && !RunTools.class2Extendfrom1(ptypes[index], paras[index].getClass())) {
                        equal = false;
                        break;
                    }
                    ++index;
                }
                if (equal) {
                    method = method1;
                    break;
                }
            }
            ++n2;
        }
        return method;
    }

    private static Constructor findConstructor(Class cls, Object[] paras) {
        Constructor<?>[] constructors;
        Constructor<?> constructor = null;
        int paralen = paras.length;
        Constructor<?>[] constructorArray = constructors = cls.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor1 = constructorArray[n2];
            Class<?>[] ptypes = constructor1.getParameterTypes();
            if (ptypes.length == paralen) {
                boolean equal = true;
                int index = 0;
                while (index < paralen) {
                    if (!RunTools.typeEqual(ptypes[index], paras[index].getClass()) && !RunTools.class2Extendfrom1(ptypes[index], paras[index].getClass())) {
                        equal = false;
                        break;
                    }
                    ++index;
                }
                if (equal) {
                    constructor = constructor1;
                    break;
                }
            }
            ++n2;
        }
        return constructor;
    }

    private static Object runMethod(Object obj, Method method, Object[] paras) {
        Object result = null;
        if (method != null) {
            try {
                result = method.getParameterTypes().length == 0 ? method.invoke(obj, new Object[0]) : method.invoke(obj, paras);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Object runMethod(Object obj, String methodName, Object[] paras) {
        Method method = RunTools.findMethod(obj, methodName, paras);
        return RunTools.runMethod(obj, method, paras);
    }

    public static Object newInstance(Class instanceclass, Object[] params) {
        Object instance = null;
        try {
            if (params == null || params.length == 0) {
                instance = instanceclass.newInstance();
            } else {
                Constructor con = RunTools.findConstructor(instanceclass, params);
                if (con != null) {
                    instance = con.newInstance(params);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    public static List<Method> getGetters(Object obj) {
        Method[] methods;
        ArrayList<Method> getters = new ArrayList<Method>();
        Method[] methodArray = methods = obj.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String getterName = method.getName();
            if ((getterName.startsWith("get") || getterName.startsWith("is")) && method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType())) {
                String setterName = "";
                setterName = getterName.startsWith("get") ? getterName.replaceFirst("get", "set") : getterName.replaceFirst("is", "set");
                try {
                    Method setter = obj.getClass().getMethod(setterName, method.getReturnType());
                    if (setter != null && Void.TYPE.equals(setter.getReturnType())) {
                        getters.add(method);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return getters;
    }

    public static List<Method> getSetters(Object obj) {
        Method[] methods;
        ArrayList<Method> setters = new ArrayList<Method>();
        Method[] methodArray = methods = obj.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String setterName = method.getName();
            if (setterName.startsWith("set") && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType())) {
                int i = 0;
                while (i < 2) {
                    String getterName = "";
                    getterName = i == 0 ? setterName.replaceFirst("set", "get") : setterName.replaceFirst("set", "is");
                    try {
                        Method getter = obj.getClass().getMethod(getterName, new Class[0]);
                        if (getter != null && getter.getReturnType().equals(method.getParameterTypes()[0])) {
                            setters.add(method);
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return setters;
    }
}

