/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.prism.Graphics;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.platform.graphics.WCGraphicsManager;
import com.sun.webpane.platform.graphics.WCRectangle;
import com.sun.webpane.sg.PGWebView;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NGWebView
extends NGGroup
implements PGWebView {
    private static final Logger log = Logger.getLogger(NGWebView.class.getName());
    private volatile WebPage page;
    private volatile float width;
    private volatile float height;

    @Override
    public void setPage(WebPage webPage) {
        this.page = webPage;
    }

    @Override
    public void resize(float f, float f2) {
        if (this.width != f || this.height != f2) {
            this.width = f;
            this.height = f2;
            this.geometryChanged();
            if (this.page != null) {
                this.page.setBounds(0, 0, (int)f, (int)f2);
            }
        }
    }

    @Override
    public void update() {
        BaseBounds baseBounds;
        if (this.page != null && !(baseBounds = this.getClippedBounds(new RectBounds(), BaseTransform.IDENTITY_TRANSFORM)).isEmpty()) {
            log.log(Level.FINEST, "updating rectangle: {0}", baseBounds);
            this.page.updateContent(new WCRectangle(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getWidth(), baseBounds.getHeight()));
        }
    }

    @Override
    public void requestRender() {
        this.visualsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderContent(Graphics graphics) {
        log.log(Level.FINEST, "rendering into {0}", graphics);
        if (graphics == null || this.page == null || this.width <= 0.0f || this.height <= 0.0f) {
            return;
        }
        WCGraphicsContext wCGraphicsContext = WCGraphicsManager.getGraphicsManager().createGraphicsContext(graphics);
        try {
            this.page.paint(wCGraphicsContext, new WCRectangle(0.0f, 0.0f, this.width, this.height));
        }
        finally {
            wCGraphicsContext.dispose();
        }
    }

    @Override
    public boolean hasOverlappingContents() {
        return false;
    }
}

