/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$util$ClassUtils == null ? (class$org$springframework$util$ClassUtils = ClassUtils.class$("org.springframework.util.ClassUtils")) : class$org$springframework$util$ClassUtils));
    private static final Map primitiveWrapperTypeMap = new HashMap(8);
    private static final Map primitiveTypeNameMap = new HashMap(8);
    static /* synthetic */ Class class$org$springframework$util$ClassUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Cannot access thread context ClassLoader - falling back to system class loader", throwable);
        }
        if (classLoader == null) {
            classLoader = (class$org$springframework$util$ClassUtils == null ? (class$org$springframework$util$ClassUtils = ClassUtils.class$("org.springframework.util.ClassUtils")) : class$org$springframework$util$ClassUtils).getClassLoader();
        }
        return classLoader;
    }

    public static boolean isPresent(String string) {
        return ClassUtils.isPresent(string, ClassUtils.getDefaultClassLoader());
    }

    public static boolean isPresent(String string, ClassLoader classLoader) {
        try {
            ClassUtils.forName(string, classLoader);
            return true;
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Class [" + string + "] or one of its dependencies is not present: " + throwable));
            }
            return false;
        }
    }

    public static Class forName(String string) throws ClassNotFoundException, LinkageError {
        return ClassUtils.forName(string, ClassUtils.getDefaultClassLoader());
    }

    public static Class forName(String string, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull(string, "Name must not be null");
        Class clazz = ClassUtils.resolvePrimitiveClassName(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.endsWith(ARRAY_SUFFIX)) {
            String string2 = string.substring(0, string.length() - ARRAY_SUFFIX.length());
            Class clazz2 = ClassUtils.forName(string2, classLoader);
            return Array.newInstance(clazz2, 0).getClass();
        }
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ClassUtils.getDefaultClassLoader();
        }
        return classLoader2.loadClass(string);
    }

    public static Class resolveClassName(String string, ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassUtils.forName(string, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Cannot find class [" + string + "]. Root cause: " + classNotFoundException);
        }
        catch (LinkageError linkageError) {
            throw new IllegalArgumentException("Error loading class [" + string + "]: problem with class file or dependent class. Root cause: " + linkageError);
        }
    }

    public static Class resolvePrimitiveClassName(String string) {
        Class clazz = null;
        if (string != null && string.length() <= 8) {
            clazz = (Class)primitiveTypeNameMap.get(string);
        }
        return clazz;
    }

    public static Class getUserClass(Object object) {
        Assert.notNull(object, "Instance must not be null");
        return ClassUtils.getUserClass(object.getClass());
    }

    public static Class getUserClass(Class clazz) {
        return clazz != null && clazz.getName().indexOf(CGLIB_CLASS_SEPARATOR) != -1 ? clazz.getSuperclass() : clazz;
    }

    public static String getShortName(String string) {
        Assert.hasLength(string, "Class name must not be empty");
        int n = string.lastIndexOf(46);
        int n2 = string.indexOf(CGLIB_CLASS_SEPARATOR);
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n + 1, n2);
        string2 = string2.replace('$', '.');
        return string2;
    }

    public static String getShortName(Class clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class clazz) {
        return Introspector.decapitalize(ClassUtils.getShortName(clazz));
    }

    public static String getClassFileName(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1) + CLASS_FILE_SUFFIX;
    }

    public static String getQualifiedName(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isArray()) {
            return ClassUtils.getQualifiedNameForArray(clazz);
        }
        return clazz.getName();
    }

    private static String getQualifiedNameForArray(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            stringBuffer.append(ARRAY_SUFFIX);
        }
        stringBuffer.insert(0, clazz.getName());
        return stringBuffer.toString();
    }

    public static String getQualifiedMethodName(Method method) {
        Assert.notNull(method, "Method must not be null");
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    public static boolean hasConstructor(Class clazz, Class[] classArray) {
        return ClassUtils.getConstructorIfAvailable(clazz, classArray) != null;
    }

    public static Constructor getConstructorIfAvailable(Class clazz, Class[] classArray) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean hasMethod(Class clazz, String string, Class[] classArray) {
        return ClassUtils.getMethodIfAvailable(clazz, string, classArray) != null;
    }

    public static Method getMethodIfAvailable(Class clazz, String string, Class[] classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(string, "Method name must not be null");
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static int getMethodCountForName(Class clazz, String string) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(string, "Method name must not be null");
        int n = 0;
        for (int i = 0; i < clazz.getDeclaredMethods().length; ++i) {
            Method method = clazz.getDeclaredMethods()[i];
            if (!string.equals(method.getName())) continue;
            ++n;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            n += ClassUtils.getMethodCountForName(classArray[i], string);
        }
        if (clazz.getSuperclass() != null) {
            n += ClassUtils.getMethodCountForName(clazz.getSuperclass(), string);
        }
        return n;
    }

    public static boolean hasAtLeastOneMethodWithName(Class clazz, String string) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(string, "Method name must not be null");
        for (int i = 0; i < clazz.getDeclaredMethods().length; ++i) {
            Method method = clazz.getDeclaredMethods()[i];
            if (!method.getName().equals(string)) continue;
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!ClassUtils.hasAtLeastOneMethodWithName(classArray[i], string)) continue;
            return true;
        }
        return clazz.getSuperclass() != null && ClassUtils.hasAtLeastOneMethodWithName(clazz.getSuperclass(), string);
    }

    public static Method getStaticMethod(Class clazz, String string, Class[] classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(string, "Method name must not be null");
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        Assert.notNull(clazz, "Target type must not be null");
        Assert.notNull(clazz2, "Value type must not be null");
        return clazz.isAssignableFrom(clazz2) || clazz.equals(primitiveWrapperTypeMap.get(clazz2));
    }

    public static boolean isAssignableValue(Class clazz, Object object) {
        Assert.notNull(clazz, "Type must not be null");
        return object != null ? ClassUtils.isAssignable(clazz, object.getClass()) : !clazz.isPrimitive();
    }

    public static String addResourcePathToPackagePath(Class clazz, String string) {
        Assert.notNull(string, "Resource name must not be null");
        if (!string.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + string;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + string;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null) {
            return "";
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        String string2 = string.substring(0, n);
        return string2.replace('.', '/');
    }

    public static String classNamesToString(Class[] classArray) {
        return ClassUtils.classNamesToString(Arrays.asList(classArray));
    }

    public static String classNamesToString(Collection collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return ARRAY_SUFFIX;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            stringBuffer.append(clazz.getName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static Class[] getAllInterfaces(Object object) {
        Assert.notNull(object, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClass(object.getClass());
    }

    public static Class[] getAllInterfacesForClass(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface()) {
            return new Class[]{clazz};
        }
        ArrayList arrayList = new ArrayList();
        while (clazz != null) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> clazz2 = clazz.getInterfaces()[i];
                if (arrayList.contains(clazz2)) continue;
                arrayList.add(clazz2);
            }
            clazz = clazz.getSuperclass();
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public static Set getAllInterfacesAsSet(Object object) {
        Assert.notNull(object, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClassAsSet(object.getClass());
    }

    public static Set getAllInterfacesForClassAsSet(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        HashSet hashSet = new HashSet();
        while (clazz != null) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> clazz2 = clazz.getInterfaces()[i];
                hashSet.add(clazz2);
            }
            clazz = clazz.getSuperclass();
        }
        return hashSet;
    }

    public static Class createCompositeInterface(Class[] classArray, ClassLoader classLoader) {
        Assert.notEmpty(classArray, "Interfaces must not be empty");
        Assert.notNull(classLoader, "ClassLoader must not be null");
        return Proxy.getProxyClass(classLoader, classArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        primitiveWrapperTypeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
        primitiveWrapperTypeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
        Iterator iterator = primitiveWrapperTypeMap.values().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
    }
}

