/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P18;
import cn.com.voltronic.solar.util.VolUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class P18VII6k
extends P18
implements IProtocol {
    protected static final int TWO_K = 2000;
    public Logger logger = Logger.getLogger(P18VII6k.class);

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            IComUSBHandler _handler = (IComUSBHandler)handler;
            return this.doComUSB(_handler);
        }
        return false;
    }

    private boolean doComUSB(IComUSBHandler handler) {
        handler.setUseCRC(true);
        String qPI = handler.excuteSimpleCommand("PI");
        if (StringUtils.isEmpty((String)qPI) || !qPI.startsWith("18")) {
            return false;
        }
        String qID = handler.getSerialNo();
        if (StringUtils.isEmpty((String)qID)) {
            return false;
        }
        this.serialNo = qID;
        String pPIRI = handler.excuteCommand("PIRI", true);
        if (StringUtils.isEmpty((String)pPIRI)) {
            return false;
        }
        String[] piri = pPIRI.split(",");
        this.outputMode = VolUtil.parseInt(piri[22]);
        int acOutputRatingApparentPower = VolUtil.parseInt(piri[5]);
        int parallelNum = VolUtil.parseInt(piri[19]);
        return (acOutputRatingApparentPower != 2000 || parallelNum != 0) && acOutputRatingApparentPower < 3000;
    }

    @Override
    public String getProtocolID() {
        return "P18";
    }
}

