/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.ModelPlanBean;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P16;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.QueryParameterThread;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AACheckBox;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AAPanel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class ModelChangeP17
extends AADialog {
    private static final long serialVersionUID = 1L;
    private JPanel PVPlanPanel;
    private JToggleButton btnGridTie;
    private JToggleButton btnHybrid;
    private JToggleButton btnOffGrid;
    private ButtonGroup buttonGroup1;
    private JComboBox cboChargingSource;
    private JComboBox cboPVAvailable;
    private JComboBox cboPVLoss;
    private JComboBox cboPVPlan;
    private JComboBox cboRule;
    private AACheckBox chkACChargingBat;
    private AACheckBox chkChargingBat;
    private AACheckBox chkFeedingGrid;
    private AACheckBox chkbatDischargForPVAvailable;
    private AACheckBox chkbatDischargForPVLoss;
    private AACheckBox chkbatFeedingForPVAvailable;
    private AACheckBox chkbatFeedingForPVLoss;
    private AALabel AALabel11;
    private AALabel AALabel12;
    private AALabel AALabel13;
    private AALabel AALabel14;
    private AALabel lblAcOutputTime;
    private AALabel lblAcOutputTimeExplain;
    private AALabel lblChargingSource;
    private AALabel lblChargingSrcInfo;
    private AALabel lblChargingSrcInfo2;
    private AALabel lblPVAvailable;
    private AALabel lblPVAvailableInfo1;
    private AALabel lblPVAvailableInfo2;
    private AALabel lblPVLoss;
    private AALabel lblPVLossInfo1;
    private AALabel lblPVLossInfo2;
    private AALabel lblAcChgTime;
    private AALabel lblAcChgTimeExplain;
    private AALabel lblAcChgTime2;
    private AALabel lblAcChgTimeExplain2;
    private AALabel lblRule;
    private AAPanel modelTypePanel;
    private AAPanel planConfigPanel;
    private AAPanel settingPanel;
    private JSpinner sprnAcOutputEndTime;
    private JSpinner sprnAcOutputstartTime;
    private JSpinner sprnAcChgEndTime;
    private JSpinner sprnAcChgStartTime;
    private JSpinner sprnAcChgEndTime2;
    private JSpinner sprnAcChgStartTime2;
    private Object preRuleObj = 0;
    private volatile int rollback = 0;
    private AAButton btnApply;
    private AAButton btnCancel;
    public ConfigData configData = new ConfigData();
    public Capability cappbility = new Capability();
    private String currModetype;
    private AbstractProcessor processor = null;
    private IProtocol protocol = null;
    private ModelPlanBean modelbean = null;
    private AALabel lblPVPlanInfo1;
    private AALabel lblPVPlanInfo2;
    private AALabel lblACChargingVol;
    private AACheckBox chkACCharBatVolLimit;
    private JSpinner sprnACChargingVol;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private JComboBox cboOutputVoltage;
    private JComboBox cboOutputFrequency;
    private AACheckBox gridChargingLowestBatVolBox;
    private AALabel gridChargingLowestBatVolUnit;
    private JSpinner gridChargingLowestBatVolSPinner;
    private AALabel gridChargingLowestBatVolExplain;

    public ModelChangeP17(Frame parent, boolean modal) {
        super(parent, modal);
        try {
            this.processor = GlobalProcessors.getCurrentProcessor();
            if (this.processor != null) {
                this.protocol = this.processor.getProtocol();
                this.configData = (ConfigData)this.processor.getBeanBag().getBean("configdata");
                this.cappbility = (Capability)this.processor.getBeanBag().getBean("capability");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.protocol == null) {
            this.protocol = new P16();
            this.configData.setModelID("050");
            this.configData.setPlanID("01");
        }
        this.modelbean = new ModelPlanBean();
        this.modelbean.readFromConfigDataP17(this.configData);
        SolarPowerTray.loginasFactory = false;
        this.setTitle("message.modelchange");
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void dataToControl() {
        this.cboRule.setModel(this.getRuleComboBoxModel());
        this.cboOutputVoltage.setModel(this.getNominalOutputVoltage());
        this.cboOutputFrequency.setModel(this.getNominalOutputFrequency());
        this.currModetype = this.modelbean.getModeltype();
        this.cboPVPlan.setModel(this.getPlanComboBoxModel(this.modelbean.getModeltype()));
        this.cboChargingSource.setModel(this.getChargeSourceComboBoxModel(this.currModetype, this.modelbean.getPlanindex()));
        this.cboPVAvailable.setModel(this.getLoadPVOnComboBoxModel(this.currModetype, this.modelbean.getPlanindex()));
        this.cboPVLoss.setModel(this.getLoadPVNoComboBoxModel(this.currModetype, this.modelbean.getPlanindex()));
        if (!this.modelbean.getModeltype().equals("01")) {
            try {
                this.cboRule.setSelectedIndex(this.modelbean.getRuleindex());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cboRule.setSelectedIndex(0);
            }
        }
        if (!this.modelbean.getModeltype().equals("00")) {
            this.cboPVPlan.setSelectedIndex(this.modelbean.getPlanindex());
        }
        if (!this.modelbean.getModeltype().equals("00")) {
            this.cboChargingSource.setSelectedIndex(this.modelbean.getChargingIndex17(this.modelbean.getPlanindex()));
            this.cboPVAvailable.setSelectedIndex(this.modelbean.getLoadPVonIndex());
            this.cboPVLoss.setSelectedIndex(this.modelbean.getLoadPVLossIndex());
        }
        this.cboOutputVoltage.setSelectedIndex(this.modelbean.getNominalVIndex());
        this.cboOutputFrequency.setSelectedIndex(this.modelbean.getNominalFIndex());
        this.sprnAcOutputstartTime.setValue(this.modelbean.getAcoutputStarttimeFormat());
        this.sprnAcOutputEndTime.setValue(this.modelbean.getAcoutputEndtimeFormat());
        this.sprnAcChgStartTime.setValue(this.modelbean.getAcChargingStarttimeFormat());
        this.sprnAcChgEndTime.setValue(this.modelbean.getAcChargingEndtimeFormat());
        this.sprnAcChgStartTime2.setValue(this.modelbean.getAcChargingStarttimeFormat2());
        this.sprnAcChgEndTime2.setValue(this.modelbean.getAcChargingEndtimeFormat2());
        SpinnerModel model = this.sprnACChargingVol.getModel();
        if (this.modelbean.getCheck_acchargelimit() == 0) {
            this.chkACCharBatVolLimit.setSelected(false);
            model.setValue(this.modelbean.getMaxacchargelimit());
        } else {
            model.setValue(this.modelbean.getAcchargelimit());
            this.chkACCharBatVolLimit.setSelected(true);
        }
        this.chkFeedingGrid.setSelected(this.modelbean.getCheck_pvfeedgrid() == 1);
        this.chkbatFeedingForPVAvailable.setSelected(this.modelbean.getCheck_batfeedpvon() == 1);
        this.chkbatFeedingForPVLoss.setSelected(this.modelbean.getCheck_batfeedpvloss() == 1);
        this.gridChargingLowestBatVolBox.setSelected(this.modelbean.getCheck_gridChargingLowestBatVol() == 1);
        SpinnerNumberModel volModel = new SpinnerNumberModel();
        volModel.setMaximum(Double.valueOf(60.0));
        volModel.setMinimum(Double.valueOf(40.0));
        volModel.setStepSize(0.1);
        volModel.setValue(this.modelbean.getGridChargingLowestBatVol());
        this.gridChargingLowestBatVolSPinner = new JSpinner(volModel);
        this.enableAndCheckCheckBox(true);
    }

    private void componentText() {
        this.buttonGroup1.add(this.btnGridTie);
        this.btnGridTie.setText("Grid-Tie");
        this.buttonGroup1.add(this.btnOffGrid);
        this.btnOffGrid.setText("Off-Grid");
        this.buttonGroup1.add(this.btnHybrid);
        this.btnHybrid.setText("Grid-tie with backup");
        if (this.modelbean.getModeltype().equalsIgnoreCase("10")) {
            this.btnHybrid.setSelected(true);
        } else if (this.modelbean.getModeltype().equalsIgnoreCase("01")) {
            this.btnOffGrid.setSelected(true);
        } else if (this.modelbean.getModeltype().equalsIgnoreCase("00")) {
            this.btnGridTie.setSelected(true);
        }
        this.lblRule.setText("message.standard[:]");
        this.jLabel1.setText("message.nominaloutputvoltage[:]");
        this.jLabel2.setText("message.nominaloutputfreq[:]");
        this.lblChargingSource.setText("message.chargingsource[:]");
        this.lblPVAvailable.setText("message.loadsourcepvon[:]");
        this.lblPVLoss.setText("message.loadsourcepvloss[:]");
        this.lblAcChgTime.setText("message.acchargingtime[:]");
        this.lblAcOutputTime.setText("message.acoutputtime[:]");
        this.AALabel11.setText("~");
        this.AALabel14.setText("~");
        this.AALabel12.setText("/");
        this.sprnAcChgStartTime.setPreferredSize(new Dimension(65, 22));
        this.sprnAcChgEndTime.setPreferredSize(new Dimension(65, 22));
        this.sprnAcChgStartTime2.setPreferredSize(new Dimension(65, 22));
        this.sprnAcChgEndTime2.setPreferredSize(new Dimension(65, 22));
        this.sprnAcOutputstartTime.setPreferredSize(new Dimension(65, 22));
        this.sprnAcOutputEndTime.setPreferredSize(new Dimension(65, 22));
        this.lblAcChgTimeExplain.setText("message.archargtimeremark");
        this.lblAcChgTimeExplain2.setText("message.archargtimeremark");
        this.lblAcOutputTimeExplain.setText("message.aroutputtimeremark");
        this.chkChargingBat.setText("message.allowcharge");
        this.chkACChargingBat.setText("message.allowaccharge");
        this.chkFeedingGrid.setText("message.allowfeedgrid");
        this.chkbatDischargForPVAvailable.setText("message.allowdischargwhenpvon");
        this.chkbatDischargForPVLoss.setText("message.allowdischargwhenpvloss");
        this.chkbatFeedingForPVAvailable.setText("message.allowbatfeedgridwhenpvon");
        this.chkbatFeedingForPVLoss.setText("message.allowbatfeedgridwhenpvloss");
        this.btnApply.setText("message.apply");
        this.btnCancel.setText("message.close");
        String[] desc = this.getPlanDescription(this.currModetype, this.modelbean.getPlanindex());
        this.lblPVPlanInfo1.setText(desc[0]);
        this.lblPVPlanInfo2.setText(desc[1]);
        desc = this.getChargingDescription(this.currModetype, this.modelbean.getPlanindex(), this.cboChargingSource.getSelectedIndex());
        this.lblChargingSrcInfo.setText(desc[0]);
        this.lblChargingSrcInfo2.setText(desc[1]);
        desc = this.getLoadpvonDescription(this.currModetype, this.modelbean.getPlanindex(), this.cboPVAvailable.getSelectedIndex());
        this.lblPVAvailableInfo1.setText(desc[0]);
        this.lblPVAvailableInfo2.setText(desc[1]);
        desc = this.getLoadpvnoDesctiption(this.currModetype, this.modelbean.getPlanindex(), this.cboPVLoss.getSelectedIndex());
        this.lblPVLossInfo1.setText(desc[0]);
        this.lblPVLossInfo2.setText(desc[1]);
        this.lblACChargingVol.setText("AC Charging Voltage:");
        this.chkACCharBatVolLimit.setText("AC charging battery voltage limit");
        this.sprnACChargingVol.setPreferredSize(new Dimension(65, 22));
        this.AALabel13.setText("V");
        this.displayDesc(this.currModetype, this.modelbean.getPlanindex());
        this.gridChargingLowestBatVolBox.setText("message.whenBatteryVoltage");
        this.gridChargingLowestBatVolUnit.setText("V,");
        this.gridChargingLowestBatVolExplain.setText("message.theACstartsCharging");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.modelTypePanel = new AAPanel();
        this.cboRule = new JComboBox();
        this.btnGridTie = new JToggleButton();
        this.btnOffGrid = new JToggleButton();
        this.btnHybrid = new JToggleButton();
        this.lblRule = new AALabel();
        this.settingPanel = new AAPanel();
        this.PVPlanPanel = new AAPanel();
        this.cboPVPlan = new JComboBox();
        this.planConfigPanel = new AAPanel();
        this.lblChargingSource = new AALabel();
        this.cboChargingSource = new JComboBox();
        this.lblChargingSrcInfo = new AALabel();
        this.lblChargingSrcInfo2 = new AALabel();
        this.lblPVAvailable = new AALabel();
        this.cboPVAvailable = new JComboBox();
        this.lblPVAvailableInfo1 = new AALabel();
        this.lblPVAvailableInfo2 = new AALabel();
        this.lblPVLoss = new AALabel();
        this.cboPVLoss = new JComboBox();
        this.lblPVLossInfo1 = new AALabel();
        this.lblPVLossInfo2 = new AALabel();
        this.lblAcChgTime = new AALabel();
        this.lblAcChgTime2 = new AALabel();
        this.lblAcOutputTime = new AALabel();
        this.sprnAcOutputstartTime = new JSpinner();
        this.setTimeFormat(this.sprnAcOutputstartTime);
        this.AALabel11 = new AALabel();
        this.AALabel12 = new AALabel();
        this.AALabel14 = new AALabel();
        this.sprnAcChgStartTime = new JSpinner();
        this.setTimeFormat(this.sprnAcChgStartTime);
        this.sprnAcChgStartTime2 = new JSpinner();
        this.setTimeFormat(this.sprnAcChgStartTime2);
        this.sprnAcChgEndTime = new JSpinner();
        this.setTimeFormat(this.sprnAcChgEndTime);
        this.sprnAcChgEndTime2 = new JSpinner();
        this.setTimeFormat(this.sprnAcChgEndTime2);
        this.sprnAcOutputEndTime = new JSpinner();
        this.setTimeFormat(this.sprnAcOutputEndTime);
        this.lblAcChgTimeExplain = new AALabel();
        this.lblAcChgTimeExplain2 = new AALabel();
        this.lblAcOutputTimeExplain = new AALabel();
        this.chkChargingBat = new AACheckBox();
        this.chkACChargingBat = new AACheckBox();
        this.chkFeedingGrid = new AACheckBox();
        this.chkbatDischargForPVAvailable = new AACheckBox();
        this.chkbatDischargForPVLoss = new AACheckBox();
        this.chkbatFeedingForPVAvailable = new AACheckBox();
        this.chkbatFeedingForPVLoss = new AACheckBox();
        this.btnApply = new AAButton();
        this.btnCancel = new AAButton();
        this.lblPVPlanInfo1 = new AALabel();
        this.lblPVPlanInfo2 = new AALabel();
        this.lblACChargingVol = new AALabel();
        this.AALabel13 = new AALabel();
        this.chkACCharBatVolLimit = new AACheckBox();
        this.jLabel1 = new AALabel();
        this.jLabel2 = new AALabel();
        this.cboOutputVoltage = new JComboBox();
        this.cboOutputFrequency = new JComboBox();
        SpinnerNumberModel model = new SpinnerNumberModel();
        model.setMinimum(Double.valueOf(this.modelbean.getMinacchargelimit()));
        model.setMaximum(Double.valueOf(this.modelbean.getMaxacchargelimit()));
        model.setStepSize(0.1);
        this.sprnACChargingVol = new JSpinner(model);
        this.lblACChargingVol.setVisible(false);
        this.AALabel13.setVisible(false);
        this.chkACCharBatVolLimit.setVisible(false);
        this.sprnACChargingVol.setVisible(false);
        this.gridChargingLowestBatVolBox = new AACheckBox();
        this.gridChargingLowestBatVolUnit = new AALabel();
        this.gridChargingLowestBatVolExplain = new AALabel();
        this.dataToControl();
        this.componentText();
        this.modelTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bd.getString("message.mode")));
        GroupLayout modelTypePanelLayout = new GroupLayout(this.modelTypePanel);
        this.modelTypePanel.setLayout(modelTypePanelLayout);
        modelTypePanelLayout.setHorizontalGroup(modelTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modelTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.btnHybrid).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnGridTie).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnOffGrid).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGap(54, 54, 54).addComponent(this.lblRule).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cboRule, -2, 100, -2).addGap(24, 24, 24).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboOutputVoltage, -2, 60, -2).addGap(24, 24, 24).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboOutputFrequency, -2, 60, -2).addContainerGap(100, Short.MAX_VALUE)));
        modelTypePanelLayout.setVerticalGroup(modelTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modelTypePanelLayout.createSequentialGroup().addContainerGap().addGroup(modelTypePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnGridTie).addComponent(this.btnOffGrid).addComponent(this.btnHybrid).addComponent(this.lblRule).addComponent(this.cboRule, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.cboOutputVoltage, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.cboOutputFrequency, -2, -1, -2)).addContainerGap(20, Short.MAX_VALUE)));
        this.settingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bd.getString("message.setting")));
        this.PVPlanPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bd.getString("message.pvenergysupplypriorities")));
        GroupLayout PVPlanPanelLayout = new GroupLayout(this.PVPlanPanel);
        this.PVPlanPanel.setLayout(PVPlanPanelLayout);
        PVPlanPanelLayout.setHorizontalGroup(PVPlanPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PVPlanPanelLayout.createSequentialGroup().addContainerGap().addGroup(PVPlanPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboPVPlan, -2, 400, -2).addComponent(this.lblPVPlanInfo1).addComponent(this.lblPVPlanInfo2)).addContainerGap(663, Short.MAX_VALUE)));
        PVPlanPanelLayout.setVerticalGroup(PVPlanPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PVPlanPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cboPVPlan, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPVPlanInfo1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPVPlanInfo2).addContainerGap(2, Short.MAX_VALUE)));
        this.planConfigPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bd.getString("message.detailconfiguration")));
        GroupLayout planConfigPanelLayout = new GroupLayout(this.planConfigPanel);
        this.planConfigPanel.setLayout(planConfigPanelLayout);
        planConfigPanelLayout.setHorizontalGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(planConfigPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblChargingSource, GroupLayout.Alignment.TRAILING).addComponent(this.lblPVAvailable, GroupLayout.Alignment.TRAILING).addComponent(this.lblPVLoss, GroupLayout.Alignment.TRAILING).addComponent(this.gridChargingLowestBatVolBox, GroupLayout.Alignment.TRAILING).addComponent(this.lblAcChgTime, GroupLayout.Alignment.TRAILING).addComponent(this.lblAcChgTime2, GroupLayout.Alignment.TRAILING).addComponent(this.lblAcOutputTime, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(planConfigPanelLayout.createSequentialGroup().addComponent(this.sprnAcOutputstartTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AALabel12).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sprnAcOutputEndTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblAcOutputTimeExplain)).addGroup(planConfigPanelLayout.createSequentialGroup().addComponent(this.sprnAcChgStartTime2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AALabel14).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sprnAcChgEndTime2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblAcChgTimeExplain2)).addGroup(planConfigPanelLayout.createSequentialGroup().addComponent(this.sprnAcChgStartTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AALabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sprnAcChgEndTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblAcChgTimeExplain)).addGroup(planConfigPanelLayout.createSequentialGroup().addComponent(this.gridChargingLowestBatVolSPinner, 65, 65, 65).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.gridChargingLowestBatVolUnit).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.gridChargingLowestBatVolExplain)).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblPVAvailableInfo1).addComponent(this.lblPVAvailableInfo2).addComponent(this.lblChargingSrcInfo).addComponent(this.lblChargingSrcInfo2).addComponent(this.lblPVLossInfo1).addComponent(this.lblPVLossInfo2).addComponent(this.cboChargingSource, 0, 317, Short.MAX_VALUE).addComponent(this.cboPVAvailable, 0, -1, Short.MAX_VALUE).addComponent(this.cboPVLoss, 0, -1, Short.MAX_VALUE))).addGap(14, 14, 14).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkChargingBat).addComponent(this.chkbatDischargForPVAvailable).addComponent(this.chkACChargingBat).addComponent(this.chkFeedingGrid).addComponent(this.chkbatFeedingForPVLoss).addComponent(this.chkbatFeedingForPVAvailable).addComponent(this.chkbatDischargForPVLoss)).addContainerGap(-1, Short.MAX_VALUE)));
        planConfigPanelLayout.setVerticalGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(planConfigPanelLayout.createSequentialGroup().addContainerGap().addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(planConfigPanelLayout.createSequentialGroup().addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblChargingSource).addComponent(this.cboChargingSource, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblChargingSrcInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblChargingSrcInfo2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGap(12, 12, 12).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblPVAvailable).addComponent(this.cboPVAvailable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPVAvailableInfo1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPVAvailableInfo2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblPVLoss).addComponent(this.cboPVLoss, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPVLossInfo1).addGap(10, 10, 10).addComponent(this.lblPVLossInfo2).addGap(18, 18, 18).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gridChargingLowestBatVolBox).addComponent(this.gridChargingLowestBatVolSPinner, -2, -1, -2).addComponent(this.gridChargingLowestBatVolUnit).addComponent(this.gridChargingLowestBatVolExplain)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblAcChgTime).addComponent(this.sprnAcChgStartTime, -2, -1, -2).addComponent(this.AALabel11).addComponent(this.sprnAcChgEndTime, -2, -1, -2).addComponent(this.lblAcChgTimeExplain)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblAcChgTime2).addComponent(this.sprnAcChgStartTime2, -2, -1, -2).addComponent(this.AALabel14).addComponent(this.sprnAcChgEndTime2, -2, -1, -2).addComponent(this.lblAcChgTimeExplain2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(planConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblAcOutputTime).addComponent(this.sprnAcOutputstartTime, -2, -1, -2).addComponent(this.AALabel12).addComponent(this.sprnAcOutputEndTime, -2, -1, -2).addComponent(this.lblAcOutputTimeExplain))).addGroup(planConfigPanelLayout.createSequentialGroup().addComponent(this.chkChargingBat, -2, 23, -2).addGap(4, 4, 4).addComponent(this.chkACChargingBat, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkFeedingGrid, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkbatDischargForPVAvailable, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkbatDischargForPVLoss, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkbatFeedingForPVAvailable, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkbatFeedingForPVLoss, -2, 23, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout settingPanelLayout = new GroupLayout(this.settingPanel);
        this.settingPanel.setLayout(settingPanelLayout);
        settingPanelLayout.setHorizontalGroup(settingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingPanelLayout.createSequentialGroup().addContainerGap().addGroup(settingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PVPlanPanel, -1, -1, Short.MAX_VALUE).addComponent(this.planConfigPanel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, settingPanelLayout.createSequentialGroup().addComponent(this.btnApply).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCancel).addContainerGap()))));
        settingPanelLayout.setVerticalGroup(settingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.PVPlanPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.planConfigPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnApply)).addGap(10, 10, 10)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.modelTypePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.settingPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.modelTypePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.settingPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.componentListener();
        this.clickButtonEvent();
        this.pack();
    }

    protected void componentListener() {
        this.cboRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ModelChangeP17.this.cboRule.isEnabled() && ModelChangeP17.this.rollback == 0) {
                    if (e.getStateChange() == 2) {
                        ModelChangeP17.this.preRuleObj = e.getItem();
                    } else if (e.getStateChange() == 1) {
                        if (!SolarPowerTray.loginasFactory) {
                            LoginJDialog.loginasFactory = true;
                            new LoginJDialog(new Frame(), true);
                            LoginJDialog.loginasFactory = false;
                        }
                        if (!SolarPowerTray.loginasFactory) {
                            ModelChangeP17.this.rollback = 2;
                            ModelChangeP17.this.cboRule.setSelectedItem(ModelChangeP17.this.preRuleObj);
                        }
                        ModelChangeP17.this.vde4105CboRule();
                    }
                } else if (ModelChangeP17.this.rollback > 0) {
                    ModelChangeP17 modelChangeP17 = ModelChangeP17.this;
                    modelChangeP17.rollback = modelChangeP17.rollback - 1;
                }
            }
        });
        this.cboPVPlan.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (ModelChangeP17.this.btnHybrid.isSelected()) {
                        ModelChangeP17.this.currModetype = "10";
                    }
                    ModelChangeP17.this.cboChargingSource.setModel(ModelChangeP17.this.getChargeSourceComboBoxModel(ModelChangeP17.this.currModetype, ModelChangeP17.this.cboPVPlan.getSelectedIndex()));
                    ModelChangeP17.this.cboChargingSource.updateUI();
                    ModelChangeP17.this.cboPVAvailable.setModel(ModelChangeP17.this.getLoadPVOnComboBoxModel(ModelChangeP17.this.currModetype, ModelChangeP17.this.cboPVPlan.getSelectedIndex()));
                    ModelChangeP17.this.cboPVAvailable.updateUI();
                    ModelChangeP17.this.cboPVLoss.setModel(ModelChangeP17.this.getLoadPVNoComboBoxModel(ModelChangeP17.this.currModetype, ModelChangeP17.this.cboPVPlan.getSelectedIndex()));
                    ModelChangeP17.this.cboPVLoss.updateUI();
                    ModelChangeP17.this.displayDesc(ModelChangeP17.this.currModetype, ModelChangeP17.this.cboPVPlan.getSelectedIndex());
                    ModelChangeP17.this.enableAndCheckCheckBox(false);
                }
            }
        });
        this.cboChargingSource.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelChangeP17.this.displayDesc(ModelChangeP17.this.currModetype, ModelChangeP17.this.cboPVPlan.getSelectedIndex());
                    ModelChangeP17.this.enableAndCheckCheckBox(false);
                }
            }
        });
        this.cboPVAvailable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelChangeP17.this.displayDesc(ModelChangeP17.this.currModetype, ModelChangeP17.this.cboPVPlan.getSelectedIndex());
                    ModelChangeP17.this.enableAndCheckCheckBox(false);
                }
            }
        });
        this.cboPVLoss.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelChangeP17.this.displayDesc(ModelChangeP17.this.currModetype, ModelChangeP17.this.cboPVPlan.getSelectedIndex());
                    ModelChangeP17.this.enableAndCheckCheckBox(false);
                }
            }
        });
        this.btnHybrid.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelChangeP17.this.loadDefault("10");
                }
            }
        });
        this.btnGridTie.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelChangeP17.this.loadDefault("00");
                }
            }
        });
        this.btnOffGrid.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelChangeP17.this.loadDefault("01");
                }
            }
        });
    }

    protected void clickButtonEvent() {
        this.chkChargingBat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.chkFeedingGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelChangeP17.this.enableAndCheckCheckBox(false);
            }
        });
        this.chkACChargingBat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.chkbatDischargForPVAvailable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.chkbatDischargForPVLoss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.chkbatFeedingForPVAvailable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ModelChangeP17.this.chkbatFeedingForPVAvailable.isSelected()) {
                    return;
                }
                ModelChangeP17.this.chkbatFeedingForPVAvailable.setSelected(false);
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                if (!SolarPowerTray.loginasFactory) {
                    LoginJDialog.loginasFactory = true;
                    new LoginJDialog(new Frame(), true);
                    LoginJDialog.loginasFactory = false;
                }
                if (SolarPowerTray.loginasFactory) {
                    ModelChangeP17.this.chkbatFeedingForPVAvailable.setSelected(true);
                }
            }
        });
        this.chkbatFeedingForPVLoss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ModelChangeP17.this.chkbatFeedingForPVLoss.isSelected()) {
                    return;
                }
                ModelChangeP17.this.chkbatFeedingForPVLoss.setSelected(false);
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                if (!SolarPowerTray.loginasFactory) {
                    LoginJDialog.loginasFactory = true;
                    new LoginJDialog(new Frame(), true);
                    LoginJDialog.loginasFactory = false;
                }
                if (SolarPowerTray.loginasFactory) {
                    ModelChangeP17.this.chkbatFeedingForPVLoss.setSelected(true);
                }
            }
        });
        this.chkACCharBatVolLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModelChangeP17.this.chkACCharBatVolLimit.isSelected()) {
                    ModelChangeP17.this.sprnACChargingVol.setEnabled(true);
                } else {
                    ModelChangeP17.this.sprnACChargingVol.setEnabled(false);
                }
            }
        });
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelChangeP17.this.apply();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelChangeP17.this.closeWindows();
            }
        });
        this.gridChargingLowestBatVolBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelChangeP17.this.gridChargingLowestBatVolSPinner.setEnabled(true);
                if (!ModelChangeP17.this.gridChargingLowestBatVolBox.isSelected()) {
                    ModelChangeP17.this.gridChargingLowestBatVolSPinner.setEnabled(false);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ModelChangeP17.this.closeWindows();
            }
        });
    }

    private synchronized void closeWindows() {
        QueryParameterThread thread = new QueryParameterThread();
        thread.start();
        this.dispose();
    }

    private synchronized void apply() {
        boolean result = false;
        if (this.processor != null) {
            if (!SolarPowerTray.isLogin) {
                new LoginJDialog(new Frame(), true);
                return;
            }
            this.modelbean.setModeltype(this.currModetype);
            if (this.modelbean.getP17NominalVoltage() >= 180.0) {
                if (!this.modelbean.getModeltype().equals("01")) {
                    this.modelbean.setRuleindex(this.cboRule.getSelectedIndex());
                } else {
                    this.modelbean.setRuleindex(0);
                }
            } else if (!this.modelbean.getModeltype().equals("01")) {
                this.modelbean.setRuleindex(8);
            } else {
                this.modelbean.setRuleindex(0);
            }
            this.modelbean.setNominalVIndex(this.cboOutputVoltage.getSelectedIndex());
            this.modelbean.setNominalFIndex(this.cboOutputFrequency.getSelectedIndex());
            if (!this.modelbean.getModeltype().equalsIgnoreCase("00")) {
                this.modelbean.setPlanindex(this.cboPVPlan.getSelectedIndex());
                if (this.chkChargingBat.isSelected()) {
                    this.modelbean.setCheck_charge(1);
                } else {
                    this.modelbean.setCheck_charge(0);
                }
                if (this.chkACChargingBat.isSelected()) {
                    this.modelbean.setCheck_accharge(1);
                } else {
                    this.modelbean.setCheck_accharge(0);
                }
                if (this.chkFeedingGrid.isSelected()) {
                    this.modelbean.setCheck_pvfeedgrid(1);
                } else {
                    this.modelbean.setCheck_pvfeedgrid(0);
                }
                if (this.chkbatDischargForPVAvailable.isSelected()) {
                    this.modelbean.setCheck_batdispvon(1);
                } else {
                    this.modelbean.setCheck_batdispvon(0);
                }
                if (this.chkbatDischargForPVLoss.isSelected()) {
                    this.modelbean.setCheck_batdispvloss(1);
                } else {
                    this.modelbean.setCheck_batdispvloss(0);
                }
                if (this.chkbatFeedingForPVAvailable.isSelected()) {
                    this.modelbean.setCheck_batfeedpvon(1);
                } else {
                    this.modelbean.setCheck_batfeedpvon(0);
                }
                if (this.chkbatFeedingForPVLoss.isSelected()) {
                    this.modelbean.setCheck_batfeedpvloss(1);
                } else {
                    this.modelbean.setCheck_batfeedpvloss(0);
                }
                this.modelbean.setAcChargingStarttime((Date)this.sprnAcChgStartTime.getValue());
                this.modelbean.setAcChargingEndtime((Date)this.sprnAcChgEndTime.getValue());
                this.modelbean.setAcChargingStarttime2((Date)this.sprnAcChgStartTime2.getValue());
                this.modelbean.setAcChargingEndtime2((Date)this.sprnAcChgEndTime2.getValue());
                this.modelbean.setAcoutputStarttime((Date)this.sprnAcOutputstartTime.getValue());
                this.modelbean.setAcoutputEndtime((Date)this.sprnAcOutputEndTime.getValue());
                if (this.gridChargingLowestBatVolBox.isSelected()) {
                    this.modelbean.setCheck_gridChargingLowestBatVol(1);
                } else {
                    this.modelbean.setCheck_gridChargingLowestBatVol(0);
                }
                this.modelbean.setGridChargingLowestBatVol(VolUtil.parseDouble(this.gridChargingLowestBatVolSPinner.getValue().toString()));
            } else {
                this.modelbean.setPlanindex(0);
            }
            result = this.processor.executeControl("setModelChange", new Object[]{this.modelbean, this.configData, this.protocol});
            if (result) {
                DisplayMessage.showInfoDialog("message.setTrue");
            } else {
                DisplayMessage.showErrorDialog("message.setFalse");
                this.modelbean.readFromConfigDataP17(this.configData);
            }
        }
    }

    private void loadDefault(String modetype) {
        this.currModetype = modetype;
        this.cboPVPlan.setModel(this.getPlanComboBoxModel(this.currModetype));
        this.cboPVPlan.updateUI();
        this.cboChargingSource.setModel(this.getChargeSourceComboBoxModel(this.currModetype, 0));
        this.cboChargingSource.updateUI();
        this.cboPVAvailable.setModel(this.getLoadPVOnComboBoxModel(this.currModetype, 0));
        this.cboPVAvailable.updateUI();
        this.cboPVLoss.setModel(this.getLoadPVNoComboBoxModel(this.currModetype, 0));
        this.cboPVLoss.updateUI();
        System.out.println("---------:" + this.modelbean.getRuleindex());
        this.displayDesc(this.currModetype, 0);
        this.enableAndCheckCheckBox(false);
    }

    private DefaultComboBoxModel getRuleComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{"VDE0126", "AS4777", "DK", "RD1663", "G83", "TaiWan", "USH(240V)", "USL(208V)", "VDE4105", "Korea", "HongSun", "Sweden", "NRS097-2-1", "Indian Type", "EN50438", "Czech Type", " DanMark Type", "Finland Type", "Ireland Type", "NorWay Type"});
    }

    private DefaultComboBoxModel getNominalOutputVoltage() {
        return new DefaultComboBoxModel<String>(new String[]{"240", "230", "220", "208", "202"});
    }

    private DefaultComboBoxModel getNominalOutputFrequency() {
        return new DefaultComboBoxModel<String>(new String[]{"50", "60"});
    }

    private DefaultComboBoxModel getPlanComboBoxModel(String modeltype) {
        DefaultComboBoxModel<String> model = null;
        model = modeltype.equalsIgnoreCase("10") ? (this.protocol.getProtocolID().equals("P1730K") ? new DefaultComboBoxModel<String>(new String[]{"Grid-Tie with Backup (I)", "Grid-Tie with Backup (II)", "Grid-Tie with Backup (III)"}) : new DefaultComboBoxModel<String>(new String[]{"Grid-Tie with Backup (I)", "Grid-Tie with Backup (II)", "Grid-Tie with Backup (III)", "Grid-Tie with Backup(IV)"})) : (modeltype.equalsIgnoreCase("01") ? new DefaultComboBoxModel<String>(new String[]{"Off-Grid (I)", "Off-Grid (II)", "Off-Grid (III)"}) : new DefaultComboBoxModel<String>(new String[]{"Grid Only"}));
        return model;
    }

    private DefaultComboBoxModel getChargeSourceComboBoxModel(String modeltype, int plan) {
        DefaultComboBoxModel<String> model = null;
        model = modeltype.equalsIgnoreCase("10") ? (plan != 3 ? new DefaultComboBoxModel<String>(new String[]{"PV and Grid", "PV Only", "None"}) : new DefaultComboBoxModel<String>(new String[]{"Peak/Off-Peak Grid Electricity Demand"})) : (modeltype.equalsIgnoreCase("01") ? new DefaultComboBoxModel<String>(new String[]{"PV or Grid", "PV Only", "None"}) : new DefaultComboBoxModel<String>(new String[]{"N/A"}));
        return model;
    }

    private DefaultComboBoxModel getLoadPVOnComboBoxModel(String modeltype, int plan) {
        DefaultComboBoxModel<String> model = null;
        if (modeltype.equalsIgnoreCase("10") && plan != 3) {
            model = plan == 0 ? new DefaultComboBoxModel<String>(new String[]{"PV-Grid-Battery"}) : new DefaultComboBoxModel<String>(new String[]{"PV-Battery-Grid", "PV-Grid-Battery"});
        } else if (modeltype.equalsIgnoreCase("00")) {
            model = new DefaultComboBoxModel<String>(new String[]{"N/A"});
        } else if (modeltype.equalsIgnoreCase("01")) {
            model = plan == 0 ? new DefaultComboBoxModel<String>(new String[]{"PV-Battery-Grid", "PV-Grid-Battery"}) : (plan == 1 ? new DefaultComboBoxModel<String>(new String[]{"PV-Grid-Battery"}) : new DefaultComboBoxModel<String>(new String[]{"PV-Battery-Grid"}));
        } else if (modeltype.equalsIgnoreCase("10") && plan == 3) {
            model = new DefaultComboBoxModel<String>(new String[]{"Peak/Off-Peak Grid Electricity Demand"});
        }
        return model;
    }

    private DefaultComboBoxModel getLoadPVNoComboBoxModel(String modeltype, int plan) {
        DefaultComboBoxModel<String> model = null;
        if (modeltype.equalsIgnoreCase("10") && plan != 3) {
            model = plan == 0 ? new DefaultComboBoxModel<String>(new String[]{"Grid-Battery", "Battery-Grid"}) : new DefaultComboBoxModel<String>(new String[]{"Battery-Grid", "Grid-Battery"});
        } else if (modeltype.equalsIgnoreCase("00")) {
            model = new DefaultComboBoxModel<String>(new String[]{"N/A"});
        } else if (modeltype.equalsIgnoreCase("01")) {
            model = plan == 0 ? new DefaultComboBoxModel<String>(new String[]{"Battery-Grid", "Grid-Battery"}) : (plan == 1 ? new DefaultComboBoxModel<String>(new String[]{"Grid-Battery", "Battery-Grid"}) : new DefaultComboBoxModel<String>(new String[]{"Grid-Battery", "Battery-Grid"}));
        } else if (modeltype.equalsIgnoreCase("10") && plan == 3) {
            model = new DefaultComboBoxModel<String>(new String[]{"Peak/Off-Peak Grid Electricity Demand"});
        }
        return model;
    }

    private String[] getPlanDescription(String modeltype, int plan) {
        if (modeltype.equalsIgnoreCase("10")) {
            if (plan == 0) {
                return new String[]{"", "message.pvpblg", ""};
            }
            if (plan == 1) {
                return new String[]{"", "message.pvplbg", ""};
            }
            if (plan == 2) {
                return new String[]{"", "message.pvplgb"};
            }
            if (plan == 3) {
                return new String[]{"message.pvppk", "message.pvpopk"};
            }
        } else {
            if (modeltype.equalsIgnoreCase("00")) {
                return new String[]{"", ""};
            }
            if (modeltype.equalsIgnoreCase("01")) {
                if (plan == 0) {
                    return new String[]{"message.pvplb", "message.pvpdis1"};
                }
                if (plan == 1) {
                    return new String[]{"message.pvpbl", "message.pvpdis1"};
                }
                if (plan == 2) {
                    return new String[]{"message.pvplb", "message.pvpdis2"};
                }
            }
        }
        return new String[]{"", ""};
    }

    private String[] getChargingDescription(String modeltype, int plan, int chargplan) {
        if (modeltype.equalsIgnoreCase("10") && plan != 3 || modeltype.equalsIgnoreCase("01")) {
            if (chargplan == 0) {
                if (modeltype.equalsIgnoreCase("01")) {
                    return new String[]{"message.chargpvorgrid", ""};
                }
                return new String[]{"message.chargpvandgrid", ""};
            }
            if (chargplan == 1) {
                return new String[]{"message.chargpvonly", ""};
            }
            return new String[]{"message.chargnone", ""};
        }
        if (modeltype.equalsIgnoreCase("10") && plan == 3) {
            return new String[]{"message.chargpeak", "message.chargpeak2"};
        }
        return new String[]{"", ""};
    }

    private String[] getLoadpvonDescription(String modeltype, int plan, int pvonplan) {
        if (modeltype.equalsIgnoreCase("10") && plan != 3) {
            if (plan == 0) {
                return new String[]{"message.loadpvonpgb", ""};
            }
            if (pvonplan == 0) {
                return new String[]{"message.loadpvonpbg", ""};
            }
            return new String[]{"message.loadpvonpgb", ""};
        }
        if (modeltype.equalsIgnoreCase("00")) {
            return new String[]{"", ""};
        }
        if (modeltype.equalsIgnoreCase("01")) {
            if (plan == 0) {
                if (pvonplan == 0) {
                    return new String[]{"message.loadpvonpbg", ""};
                }
                return new String[]{"message.loadpvonpgb", ""};
            }
            if (plan == 1) {
                return new String[]{"message.loadpvonpgb", ""};
            }
            if (plan == 2) {
                return new String[]{"message.loadpvonpbg", ""};
            }
        } else if (modeltype.equalsIgnoreCase("10") && plan == 3) {
            return new String[]{"message.loadpvonpeak", "message.loadpvonopeak"};
        }
        return new String[]{"", ""};
    }

    private String[] getLoadpvnoDesctiption(String modeltype, int plan, int pvnoplan) {
        if (modeltype.equalsIgnoreCase("10") && plan != 3) {
            if (plan == 0) {
                if (pvnoplan == 0) {
                    return new String[]{"message.loadpvlossgb", ""};
                }
                return new String[]{"message.loadpvlossbg", "message.loadpvlossbg2"};
            }
            if (pvnoplan == 0) {
                return new String[]{"message.loadpvlossbg", "message.loadpvlossbg2"};
            }
            return new String[]{"message.loadpvlossgb", ""};
        }
        if (modeltype.equalsIgnoreCase("01")) {
            if (plan == 0) {
                if (pvnoplan == 0) {
                    return new String[]{"message.loadpvlossbg", "message.loadpvlossbg2"};
                }
                return new String[]{"message.loadpvlossgb", ""};
            }
            if (pvnoplan == 0) {
                return new String[]{"message.loadpvlossgb", ""};
            }
            return new String[]{"message.loadpvlossbg", "message.loadpvlossbg2"};
        }
        if (modeltype.equalsIgnoreCase("10") && plan == 3) {
            return new String[]{"message.loadpvlosspeak", "message.loadpvlossopeak"};
        }
        return new String[]{"", ""};
    }

    private void enableAndCheckCheckBox(boolean isInint) {
        int pvplan = this.cboPVPlan.getSelectedIndex();
        this.chkChargingBat.setEnabled(false);
        this.chkACChargingBat.setEnabled(false);
        if (this.currModetype.equalsIgnoreCase("10") && pvplan != 3) {
            this.cboPVPlan.setEnabled(true);
            this.cboChargingSource.setEnabled(true);
            this.cboPVAvailable.setEnabled(true);
            this.cboPVLoss.setEnabled(true);
            if (this.modelbean.getP17NominalVoltage() >= 180.0) {
                this.cboRule.setEnabled(false);
                this.cboRule.setSelectedIndex(this.modelbean.getRuleindex());
                this.cboRule.setEnabled(true);
            } else {
                this.cboRule.setEnabled(false);
                this.cboRule.setSelectedIndex(8);
            }
            this.sprnAcOutputEndTime.setEnabled(true);
            this.sprnAcOutputstartTime.setEnabled(true);
            this.chkFeedingGrid.setEnabled(true);
            if (this.cboChargingSource.getSelectedIndex() == 0) {
                this.chkChargingBat.setSelected(true);
                this.chkACChargingBat.setSelected(true);
                this.sprnAcChgStartTime.setEnabled(true);
                this.sprnAcChgEndTime.setEnabled(true);
                if (this.configData.getAcctParams() == 4) {
                    this.sprnAcChgStartTime2.setEnabled(true);
                    this.sprnAcChgEndTime2.setEnabled(true);
                } else {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                }
                this.gridChargingLowestBatVolEnabled();
                this.chkACCharBatVolLimit.setEnabled(true);
                if (this.chkACCharBatVolLimit.isSelected()) {
                    this.sprnACChargingVol.setEnabled(true);
                } else {
                    this.sprnACChargingVol.setEnabled(false);
                }
            } else if (this.cboChargingSource.getSelectedIndex() == 1) {
                this.chkChargingBat.setSelected(true);
                this.chkACChargingBat.setSelected(false);
                this.sprnAcChgStartTime.setEnabled(false);
                this.sprnAcChgEndTime.setEnabled(false);
                if (this.configData.getAcctParams() == 4) {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                } else {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                }
                this.gridChargingLowestBatVolDisabled();
                this.chkACCharBatVolLimit.setSelected(false);
                this.chkACCharBatVolLimit.setEnabled(false);
                this.sprnACChargingVol.setEnabled(false);
            } else {
                this.chkChargingBat.setSelected(false);
                this.chkACChargingBat.setSelected(false);
                this.sprnAcChgStartTime.setEnabled(false);
                this.sprnAcChgEndTime.setEnabled(false);
                if (this.configData.getAcctParams() == 4) {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                } else {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                }
                this.gridChargingLowestBatVolDisabled();
                this.chkACCharBatVolLimit.setSelected(false);
                this.chkACCharBatVolLimit.setEnabled(false);
                this.sprnACChargingVol.setEnabled(false);
            }
            if (pvplan == 0) {
                this.chkbatDischargForPVAvailable.setEnabled(false);
                this.chkbatDischargForPVAvailable.setSelected(false);
                this.chkbatDischargForPVLoss.setEnabled(false);
                this.chkbatFeedingForPVAvailable.setEnabled(false);
                this.chkbatFeedingForPVAvailable.setSelected(false);
                if (this.chkFeedingGrid.isSelected()) {
                    this.chkbatFeedingForPVLoss.setEnabled(true);
                } else {
                    this.chkbatFeedingForPVLoss.setEnabled(false);
                    this.chkbatFeedingForPVLoss.setSelected(false);
                }
                if (this.cboPVLoss.getSelectedIndex() == 0) {
                    this.chkbatDischargForPVLoss.setSelected(false);
                } else {
                    this.chkbatDischargForPVLoss.setSelected(true);
                }
            } else if (pvplan == 1 || pvplan == 2) {
                this.chkbatDischargForPVAvailable.setEnabled(false);
                this.chkbatDischargForPVLoss.setEnabled(false);
                if (this.chkFeedingGrid.isSelected()) {
                    this.chkbatFeedingForPVAvailable.setEnabled(true);
                    this.chkbatFeedingForPVLoss.setEnabled(true);
                } else {
                    this.chkbatFeedingForPVAvailable.setEnabled(false);
                    this.chkbatFeedingForPVAvailable.setSelected(false);
                    this.chkbatFeedingForPVLoss.setEnabled(false);
                    this.chkbatFeedingForPVLoss.setSelected(false);
                }
                if (this.cboPVAvailable.getSelectedIndex() == 0) {
                    this.chkbatDischargForPVAvailable.setSelected(true);
                } else {
                    this.chkbatDischargForPVAvailable.setSelected(false);
                }
                if (this.cboPVLoss.getSelectedIndex() == 0) {
                    this.chkbatDischargForPVLoss.setSelected(true);
                } else {
                    this.chkbatDischargForPVLoss.setSelected(false);
                }
            }
        } else if (this.currModetype.equalsIgnoreCase("00")) {
            if (this.modelbean.getP17NominalVoltage() >= 180.0) {
                this.cboRule.setEnabled(false);
                this.cboRule.setSelectedIndex(this.modelbean.getRuleindex());
                this.cboRule.setEnabled(true);
            } else {
                this.cboRule.setEnabled(false);
                this.cboRule.setSelectedIndex(8);
            }
            this.chkChargingBat.setEnabled(false);
            this.chkACChargingBat.setEnabled(false);
            this.chkFeedingGrid.setEnabled(false);
            this.chkbatDischargForPVAvailable.setEnabled(false);
            this.chkbatDischargForPVLoss.setEnabled(false);
            this.chkbatFeedingForPVAvailable.setEnabled(false);
            this.chkbatFeedingForPVLoss.setEnabled(false);
            this.chkChargingBat.setSelected(false);
            this.chkACChargingBat.setSelected(false);
            this.chkFeedingGrid.setSelected(true);
            this.chkbatDischargForPVAvailable.setSelected(false);
            this.chkbatDischargForPVLoss.setSelected(false);
            this.chkbatFeedingForPVAvailable.setSelected(false);
            this.chkbatFeedingForPVLoss.setSelected(false);
            this.sprnAcOutputEndTime.setEnabled(false);
            this.sprnAcOutputstartTime.setEnabled(false);
            this.sprnAcChgStartTime.setEnabled(false);
            this.sprnAcChgEndTime.setEnabled(false);
            if (this.configData.getAcctParams() == 4) {
                this.sprnAcChgStartTime2.setEnabled(false);
                this.sprnAcChgEndTime2.setEnabled(false);
            } else {
                this.sprnAcChgStartTime2.setEnabled(false);
                this.sprnAcChgEndTime2.setEnabled(false);
            }
            this.gridChargingLowestBatVolDisabled();
            this.chkACCharBatVolLimit.setSelected(false);
            this.chkACCharBatVolLimit.setEnabled(false);
            this.sprnACChargingVol.setEnabled(false);
        } else if (this.currModetype.equalsIgnoreCase("01")) {
            this.cboPVPlan.setEnabled(true);
            this.cboChargingSource.setEnabled(true);
            this.cboPVAvailable.setEnabled(true);
            this.cboPVLoss.setEnabled(true);
            this.cboRule.setEnabled(false);
            this.cboRule.setSelectedIndex(0);
            this.chkFeedingGrid.setEnabled(false);
            this.chkFeedingGrid.setSelected(false);
            this.chkbatFeedingForPVAvailable.setEnabled(false);
            this.chkbatFeedingForPVLoss.setEnabled(false);
            this.chkbatFeedingForPVAvailable.setSelected(false);
            this.chkbatFeedingForPVLoss.setSelected(false);
            this.sprnAcOutputEndTime.setEnabled(true);
            this.sprnAcOutputstartTime.setEnabled(true);
            this.chkbatDischargForPVAvailable.setEnabled(false);
            this.chkbatDischargForPVLoss.setEnabled(false);
            if (this.cboChargingSource.getSelectedIndex() == 0) {
                this.chkChargingBat.setSelected(true);
                this.chkACChargingBat.setSelected(true);
                this.sprnAcChgStartTime.setEnabled(true);
                this.sprnAcChgEndTime.setEnabled(true);
                if (this.configData.getAcctParams() == 4) {
                    this.sprnAcChgStartTime2.setEnabled(true);
                    this.sprnAcChgEndTime2.setEnabled(true);
                } else {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                }
                this.gridChargingLowestBatVolEnabled();
                this.chkACCharBatVolLimit.setEnabled(true);
                if (this.chkACCharBatVolLimit.isSelected()) {
                    this.sprnACChargingVol.setEnabled(true);
                } else {
                    this.sprnACChargingVol.setEnabled(false);
                }
            } else if (this.cboChargingSource.getSelectedIndex() == 1) {
                this.chkChargingBat.setSelected(true);
                this.chkACChargingBat.setSelected(false);
                this.sprnAcChgStartTime.setEnabled(false);
                this.sprnAcChgEndTime.setEnabled(false);
                if (this.configData.getAcctParams() == 4) {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                } else {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                }
                this.gridChargingLowestBatVolDisabled();
                this.chkACCharBatVolLimit.setSelected(false);
                this.chkACCharBatVolLimit.setEnabled(false);
                this.sprnACChargingVol.setEnabled(false);
            } else {
                this.chkChargingBat.setSelected(false);
                this.chkACChargingBat.setSelected(false);
                this.sprnAcChgStartTime.setEnabled(false);
                this.sprnAcChgEndTime.setEnabled(false);
                if (this.configData.getAcctParams() == 4) {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                } else {
                    this.sprnAcChgStartTime2.setEnabled(false);
                    this.sprnAcChgEndTime2.setEnabled(false);
                }
                this.gridChargingLowestBatVolDisabled();
                this.chkACCharBatVolLimit.setSelected(false);
                this.chkACCharBatVolLimit.setEnabled(false);
                this.sprnACChargingVol.setEnabled(false);
            }
            if (pvplan == 0) {
                if (this.cboPVAvailable.getSelectedIndex() == 0) {
                    this.chkbatDischargForPVAvailable.setSelected(true);
                } else {
                    this.chkbatDischargForPVAvailable.setSelected(false);
                }
                if (this.cboPVLoss.getSelectedIndex() == 0) {
                    this.chkbatDischargForPVLoss.setSelected(true);
                } else {
                    this.chkbatDischargForPVLoss.setSelected(false);
                }
            } else if (pvplan == 1) {
                this.chkbatDischargForPVAvailable.setSelected(false);
                if (this.cboPVLoss.getSelectedIndex() == 0) {
                    this.chkbatDischargForPVLoss.setSelected(false);
                } else {
                    this.chkbatDischargForPVLoss.setSelected(true);
                }
            } else if (pvplan == 2) {
                this.chkbatDischargForPVAvailable.setSelected(true);
                if (this.cboPVLoss.getSelectedIndex() == 0) {
                    this.chkbatDischargForPVLoss.setSelected(false);
                } else {
                    this.chkbatDischargForPVLoss.setSelected(true);
                }
            }
        } else if (this.currModetype.equalsIgnoreCase("10") && pvplan == 3) {
            if (this.modelbean.getP17NominalVoltage() >= 180.0) {
                this.cboRule.setEnabled(false);
                this.cboRule.setSelectedIndex(this.modelbean.getRuleindex());
                this.cboRule.setEnabled(true);
            } else {
                this.cboRule.setEnabled(false);
                this.cboRule.setSelectedIndex(0);
            }
            this.chkChargingBat.setEnabled(false);
            this.chkACChargingBat.setEnabled(false);
            this.chkFeedingGrid.setEnabled(true);
            this.chkbatDischargForPVAvailable.setEnabled(false);
            this.chkbatDischargForPVLoss.setEnabled(false);
            this.chkbatFeedingForPVAvailable.setEnabled(false);
            this.chkbatFeedingForPVLoss.setEnabled(false);
            this.chkChargingBat.setSelected(true);
            this.chkACChargingBat.setSelected(true);
            this.chkbatDischargForPVAvailable.setSelected(false);
            this.chkbatDischargForPVLoss.setSelected(false);
            this.chkbatFeedingForPVAvailable.setSelected(false);
            this.chkbatFeedingForPVLoss.setSelected(false);
            this.chkACCharBatVolLimit.setSelected(false);
            this.chkACCharBatVolLimit.setEnabled(false);
            this.sprnACChargingVol.setEnabled(false);
            this.sprnAcOutputEndTime.setEnabled(true);
            this.sprnAcOutputstartTime.setEnabled(true);
            this.sprnAcChgStartTime.setEnabled(true);
            this.sprnAcChgEndTime.setEnabled(true);
            if (this.configData.getAcctParams() == 4) {
                this.sprnAcChgStartTime2.setEnabled(true);
                this.sprnAcChgEndTime2.setEnabled(true);
            } else {
                this.sprnAcChgStartTime2.setEnabled(false);
                this.sprnAcChgEndTime2.setEnabled(false);
            }
            this.gridChargingLowestBatVolEnabled();
        }
        this.vde4105Enabled(isInint);
    }

    private void setTimeFormat(JSpinner spinner) {
        String format = "HH:mm";
        SimpleDateFormat timeFormat = new SimpleDateFormat(format);
        SpinnerDateModel dateModel = null;
        try {
            dateModel = new SpinnerDateModel(timeFormat.parse("00:00:00"), null, null, 12);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        spinner.setModel(dateModel);
        spinner.setEditor(new JSpinner.DateEditor(spinner, format));
    }

    private void displayDesc(String modetype, int pvplan) {
        String[] desc = this.getPlanDescription(modetype, pvplan);
        this.lblPVPlanInfo1.setText(desc[0]);
        this.lblPVPlanInfo2.setText(desc[1]);
        desc = this.getChargingDescription(modetype, pvplan, this.cboChargingSource.getSelectedIndex());
        this.lblChargingSrcInfo.setText(desc[0]);
        this.lblChargingSrcInfo2.setText(desc[1]);
        desc = this.getLoadpvonDescription(modetype, pvplan, this.cboPVAvailable.getSelectedIndex());
        this.lblPVAvailableInfo1.setText(desc[0]);
        this.lblPVAvailableInfo2.setText(desc[1]);
        desc = this.getLoadpvnoDesctiption(modetype, pvplan, this.cboPVLoss.getSelectedIndex());
        this.lblPVLossInfo1.setText(desc[0]);
        this.lblPVLossInfo2.setText(desc[1]);
        if (modetype.equals("10") && pvplan == 3) {
            this.lblAcChgTime.setText("message.offpeaktime[:]");
        } else {
            this.lblAcChgTime.setText("message.acchargingtime[:]");
        }
    }

    private void gridChargingLowestBatVolEnabled() {
        this.gridChargingLowestBatVolBox.setEnabled(true);
        this.gridChargingLowestBatVolSPinner.setEnabled(true);
        if (!this.gridChargingLowestBatVolBox.isSelected()) {
            this.gridChargingLowestBatVolSPinner.setEnabled(false);
        }
        this.gridChargingLowestBatVolUnit.setForeground(new Color(255, 255, 255));
        this.gridChargingLowestBatVolExplain.setForeground(new Color(255, 255, 255));
    }

    private void gridChargingLowestBatVolDisabled() {
        this.gridChargingLowestBatVolBox.setEnabled(false);
        this.gridChargingLowestBatVolSPinner.setEnabled(false);
        this.gridChargingLowestBatVolUnit.setForeground(new Color(158, 158, 158));
        this.gridChargingLowestBatVolExplain.setForeground(new Color(158, 158, 158));
    }

    private void vde4105CboRule() {
        int pvplan = this.cboPVPlan.getSelectedIndex();
        boolean homesolar = this.currModetype.equalsIgnoreCase("10") && pvplan == 3;
        int chargingid = this.cboChargingSource.getSelectedIndex();
        this.chkACChargingBat.setEnabled(false);
        this.chkACChargingBat.setSelected(false);
        if (this.currModetype.equalsIgnoreCase("00")) {
            return;
        }
        if (this.cboRule.getSelectedIndex() == 8 && !homesolar) {
            if (chargingid == 0) {
                this.chkACChargingBat.setEnabled(true);
                this.chkACChargingBat.setSelected(true);
            }
        } else if (chargingid == 0) {
            this.chkACChargingBat.setSelected(true);
        }
    }

    private void vde4105Enabled(boolean isInint) {
        boolean homesolar;
        int pvplan = this.cboPVPlan.getSelectedIndex();
        boolean bl = homesolar = this.currModetype.equalsIgnoreCase("10") && pvplan == 3;
        if (this.cboRule.getSelectedIndex() == 8 && !homesolar) {
            this.chkACChargingBat.setEnabled(true);
            this.chkACChargingBat.setSelected(true);
            if (this.cboChargingSource.getSelectedIndex() != 0) {
                this.chkACChargingBat.setEnabled(false);
                this.chkACChargingBat.setSelected(false);
            }
            if (this.currModetype.equalsIgnoreCase("00")) {
                this.chkACChargingBat.setEnabled(false);
                this.chkACChargingBat.setSelected(false);
            }
            if (isInint) {
                this.chkACChargingBat.setSelected(this.modelbean.getCheck_accharge() == 1);
            }
        }
    }
}

